/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.xml;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.objectweb.asm.xml.Processor;

public class XMLPerfTest {
    private static final String[] ENGINES = new String[]{"jd.xml.xslt.trax.TransformerFactoryImpl", "net.sf.saxon.TransformerFactoryImpl", "org.apache.xalan.processor.TransformerFactoryImpl"};
    private static final String[] TEMPLATES = new String[]{"copy.xsl", "linenumbers.xsl", "profile.xsl"};

    public static void main(String[] args) throws Exception {
        System.err.println("Comparing XSLT performance for ASM XSLT");
        System.err.println("This may take 20 to 30 minutes\n");
        File examplesDir = new File(args[0]);
        if (!examplesDir.isDirectory()) {
            System.err.println(String.valueOf(args[0]) + " must be directory");
            return;
        }
        int i = 0;
        while (i < ENGINES.length) {
            System.err.println(ENGINES[i]);
            XMLPerfTest.process(null, ENGINES[i]);
            int j = 0;
            while (j < TEMPLATES.length) {
                XMLPerfTest.process(new File(examplesDir, TEMPLATES[j]).getAbsolutePath(), ENGINES[i]);
                ++j;
            }
            System.err.println();
            ++i;
        }
    }

    private static void process(String name, String engine) throws Exception {
        System.setProperty("javax.xml.transform.TransformerFactory", engine);
        XMLPerfTest.processRep(name, 1);
        XMLPerfTest.processRep(name, 2);
        XMLPerfTest.processRep(name, 3);
    }

    private static void processRep(String name, int outRep) {
        long l1 = System.currentTimeMillis();
        int n = 0;
        try {
            Class<XMLPerfTest> c = XMLPerfTest.class;
            String u = c.getResource("/java/lang/String.class").toString();
            BufferedInputStream is = new BufferedInputStream(new URL(u.substring(4, u.indexOf(33))).openStream());
            IgnoringOutputStream os = new IgnoringOutputStream();
            StreamSource xslt = name == null ? null : new StreamSource(new FileInputStream(name));
            DotObserver p = new DotObserver(1, outRep, is, os, xslt);
            n = p.process();
        }
        catch (Exception ex) {
            System.err.println();
            System.err.println(ex);
        }
        long l2 = System.currentTimeMillis();
        System.err.println();
        System.err.println("  " + outRep + " " + name + "  " + (l2 - l1) + "ms  " + 1000.0f * (float)n / (float)(l2 - l1));
    }

    private static final class DotObserver
    extends Processor {
        public DotObserver(int inRepresenation, int outRepresentation, InputStream input, OutputStream output, Source xslt) {
            super(inRepresenation, outRepresentation, input, output, xslt);
        }
    }

    static final class IgnoringOutputStream
    extends OutputStream {
        IgnoringOutputStream() {
        }

        public final void write(int b) throws IOException {
        }

        public final void write(byte[] b) throws IOException {
        }

        public final void write(byte[] b, int off, int len) throws IOException {
        }
    }
}

