/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.util;

import java.util.StringTokenizer;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.util.TraceSignatureVisitor;

public class TraceSignatureVisitorUnitTest
extends TestCase {
    public static final String[] DATA = new String[]{"C|E|<E extends java.lang.Enum<E>> implements java.lang.Comparable<E>, java.io.Serializable|<E:Ljava/lang/Enum<TE;>;>Ljava/lang/Object;Ljava/lang/Comparable<TE;>;Ljava/io/Serializable;", "C|I|<D extends java.lang.reflect.GenericDeclaration> extends java.lang.reflect.Type|<D::Ljava/lang/reflect/GenericDeclaration;>Ljava/lang/Object;Ljava/lang/reflect/Type;", "C|C|<K, V> extends java.util.AbstractMap<K, V> implements java.util.concurrent.ConcurrentMap<K, V>, java.io.Serializable|<K:Ljava/lang/Object;V:Ljava/lang/Object;>Ljava/util/AbstractMap<TK;TV;>;Ljava/util/concurrent/ConcurrentMap<TK;TV;>;Ljava/io/Serializable;", "C|C|<K extends java.lang.Enum<K>, V> extends java.util.AbstractMap<K, V> implements java.io.Serializable, java.lang.Cloneable|<K:Ljava/lang/Enum<TK;>;V:Ljava/lang/Object;>Ljava/util/AbstractMap<TK;TV;>;Ljava/io/Serializable;Ljava/lang/Cloneable;", "F|C|java.lang.Class<?>|Ljava/lang/Class<*>;", "F|C|java.lang.reflect.Constructor<T>|Ljava/lang/reflect/Constructor<TT;>;", "F|C|T[]|[TT;", "F|C|java.util.Hashtable<?, ?>|Ljava/util/Hashtable<**>;", "F|C|java.util.concurrent.atomic.AtomicReferenceFieldUpdater<java.io.BufferedInputStream, byte[]>|Ljava/util/concurrent/atomic/AtomicReferenceFieldUpdater<Ljava/io/BufferedInputStream;[B>;", "F|C|AA<byte[][]>|LAA<[[B>;", "F|C|AA<java.util.Map<java.lang.String, java.lang.String>[][]>|LAA<[[Ljava/util/Map<Ljava/lang/String;Ljava/lang/String;>;>;", "F|C|java.util.Hashtable<java.lang.Object, java.lang.String>|Ljava/util/Hashtable<Ljava/lang/Object;Ljava/lang/String;>;", "M|C|void(boolean, byte, char, short, int, float, long, double)|(ZBCSIFJD)V", "M|C|void()E, F|()V^TE;^TF;", "M|C|java.lang.Class<? extends E><E extends java.lang.Class>()|<E:Ljava/lang/Class;>()Ljava/lang/Class<+TE;>;", "M|C|java.lang.Class<? super E><E extends java.lang.Class>()|<E:Ljava/lang/Class;>()Ljava/lang/Class<-TE;>;", "M|C|void(A<E>.B)|(LA<TE;>.B;)V", "M|C|void(A<E>.B<F>)|(LA<TE;>.B<TF;>;)V", "M|C|void(java.lang.String, java.lang.Class<?>, java.lang.reflect.Method[], java.lang.reflect.Method, java.lang.reflect.Method)|(Ljava/lang/String;Ljava/lang/Class<*>;[Ljava/lang/reflect/Method;Ljava/lang/reflect/Method;Ljava/lang/reflect/Method;)V", "M|C|java.util.Map<java.lang.Object, java.lang.String>(java.lang.Object, java.util.Map<java.lang.Object, java.lang.String>)|(Ljava/lang/Object;Ljava/util/Map<Ljava/lang/Object;Ljava/lang/String;>;)Ljava/util/Map<Ljava/lang/Object;Ljava/lang/String;>;", "M|C|java.util.Map<java.lang.Object, java.lang.String><T>(java.lang.Object, java.util.Map<java.lang.Object, java.lang.String>, T)|<T:Ljava/lang/Object;>(Ljava/lang/Object;Ljava/util/Map<Ljava/lang/Object;Ljava/lang/String;>;TT;)Ljava/util/Map<Ljava/lang/Object;Ljava/lang/String;>;", "M|C|java.util.Map<java.lang.Object, java.lang.String><E, T extends java.lang.Comparable<E>>(java.lang.Object, java.util.Map<java.lang.Object, java.lang.String>, T)|<E:Ljava/lang/Object;T::Ljava/lang/Comparable<TE;>;>(Ljava/lang/Object;Ljava/util/Map<Ljava/lang/Object;Ljava/lang/String;>;TT;)Ljava/util/Map<Ljava/lang/Object;Ljava/lang/String;>;"};
    private TestData data;

    public static TestSuite suite() {
        TestSuite suite = new TestSuite(TraceSignatureVisitorUnitTest.class.getName());
        int i = 0;
        while (i < DATA.length) {
            suite.addTest((Test)new TraceSignatureVisitorUnitTest(new TestData(DATA[i])));
            ++i;
        }
        return suite;
    }

    private TraceSignatureVisitorUnitTest(TestData data) {
        super("testSignature");
        this.data = data;
    }

    public void testSignature() {
        TraceSignatureVisitor d = new TraceSignatureVisitor(this.data.access);
        SignatureReader r = new SignatureReader(this.data.signature);
        switch (this.data.type) {
            case 'C': {
                r.accept(d);
                TraceSignatureVisitorUnitTest.assertEquals((String)this.data.declaration, (String)d.getDeclaration());
                break;
            }
            case 'F': {
                r.acceptType(d);
                TraceSignatureVisitorUnitTest.assertEquals((String)this.data.declaration, (String)d.getDeclaration());
                break;
            }
            case 'M': {
                r.accept(d);
                String fullMethodDeclaration = String.valueOf(d.getReturnType()) + d.getDeclaration() + (d.getExceptions() != null ? d.getExceptions() : "");
                TraceSignatureVisitorUnitTest.assertEquals((String)this.data.declaration, (String)fullMethodDeclaration);
            }
        }
    }

    public String getName() {
        return String.valueOf(super.getName()) + " " + this.data.signature;
    }

    public static class TestData {
        public final char type;
        public final int access;
        public final String declaration;
        public final String signature;

        public TestData(String data) {
            StringTokenizer st = new StringTokenizer(data, "|");
            this.type = st.nextToken().charAt(0);
            String acc = st.nextToken();
            switch (acc.charAt(0)) {
                case 'E': {
                    this.access = 16384;
                    break;
                }
                case 'I': {
                    this.access = 512;
                    break;
                }
                case 'A': {
                    this.access = 8192;
                    break;
                }
                default: {
                    this.access = 0;
                }
            }
            this.declaration = st.nextToken();
            this.signature = st.nextToken();
        }
    }
}

