/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.tree.analysis;

import junit.framework.TestCase;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.SimpleVerifier;

public class SimpleVerifierUnitTest
extends TestCase
implements Opcodes {
    private Analyzer<?> a;
    private MethodNode mn;

    protected void setUp() {
        Type c = Type.getType("LC;");
        Type d = Type.getType("Ljava/lang/Number;");
        this.a = new Analyzer<BasicValue>(new SimpleVerifier(c, d, false));
        this.mn = new MethodNode(1, "m", "()V", null, null);
    }

    private void assertValid() throws AnalyzerException {
        this.mn.visitInsn(177);
        this.mn.visitMaxs(10, 10);
        this.a.analyze("C", this.mn);
        Frame<?>[] frames = this.a.getFrames();
        int i = 0;
        while (i < frames.length) {
            if (frames[i] != null) {
                frames[i].toString();
            }
            ++i;
        }
        this.a.getHandlers(0);
    }

    private void assertInvalid() {
        this.mn.visitInsn(177);
        this.mn.visitMaxs(10, 10);
        try {
            this.a.analyze("C", this.mn);
            SimpleVerifierUnitTest.fail();
        }
        catch (AnalyzerException e) {
            SimpleVerifierUnitTest.success();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testInvalidOpcode() {
        this.mn.visitInsn(-1);
        this.assertInvalid();
    }

    public void testInvalidPop() {
        this.mn.visitInsn(9);
        this.mn.visitInsn(87);
        this.assertInvalid();
    }

    public void testInvalidPop2() {
        this.mn.visitInsn(9);
        this.mn.visitInsn(3);
        this.mn.visitInsn(88);
        this.assertInvalid();
    }

    public void testInvalidDup() {
        this.mn.visitInsn(9);
        this.mn.visitInsn(89);
        this.assertInvalid();
    }

    public void testInvalidDupx1() {
        this.mn.visitInsn(9);
        this.mn.visitInsn(3);
        this.mn.visitInsn(90);
        this.assertInvalid();
    }

    public void testInvalidDupx2() {
        this.mn.visitInsn(9);
        this.mn.visitInsn(3);
        this.mn.visitInsn(3);
        this.mn.visitInsn(91);
        this.assertInvalid();
    }

    public void testInvalidDup2() {
        this.mn.visitInsn(9);
        this.mn.visitInsn(3);
        this.mn.visitInsn(92);
        this.assertInvalid();
    }

    public void testInvalidDup2x1() {
        this.mn.visitInsn(9);
        this.mn.visitInsn(3);
        this.mn.visitInsn(3);
        this.mn.visitInsn(93);
        this.assertInvalid();
    }

    public void testInvalidDup2x2() {
        this.mn.visitInsn(9);
        this.mn.visitInsn(3);
        this.mn.visitInsn(3);
        this.mn.visitInsn(3);
        this.mn.visitInsn(94);
        this.assertInvalid();
    }

    public void testInvalidSwap() {
        this.mn.visitInsn(9);
        this.mn.visitInsn(3);
        this.mn.visitInsn(95);
        this.assertInvalid();
    }

    public void testInvalidGetLocal() {
        this.mn.visitVarInsn(25, 10);
        this.assertInvalid();
    }

    public void testInvalidSetLocal() {
        this.mn.visitInsn(1);
        this.mn.visitVarInsn(58, 10);
        this.assertInvalid();
    }

    public void testInvalidEmptyStack() {
        this.mn.visitInsn(87);
        this.assertInvalid();
    }

    public void testInvalidFullStack() {
        this.mn.visitInsn(3);
        this.mn.visitInsn(3);
        this.mn.visitInsn(3);
        this.mn.visitInsn(3);
        this.mn.visitInsn(3);
        this.mn.visitInsn(3);
        this.mn.visitInsn(3);
        this.mn.visitInsn(3);
        this.mn.visitInsn(3);
        this.mn.visitInsn(3);
        this.mn.visitInsn(3);
        this.assertInvalid();
    }

    public void testInconsistentStackHeights() {
        Label l0 = new Label();
        this.mn.visitInsn(3);
        this.mn.visitJumpInsn(153, l0);
        this.mn.visitInsn(3);
        this.mn.visitLabel(l0);
        this.assertInvalid();
    }

    public void testInvalidNewArray() {
        this.mn.visitInsn(4);
        this.mn.visitIntInsn(188, -1);
        this.assertInvalid();
    }

    public void testInvalidAload() {
        this.mn.visitInsn(3);
        this.mn.visitVarInsn(54, 1);
        this.mn.visitVarInsn(25, 1);
        this.assertInvalid();
    }

    public void testInvalidAstore() {
        this.mn.visitInsn(3);
        this.mn.visitVarInsn(58, 1);
        this.assertInvalid();
    }

    public void testInvalidIstore() {
        this.mn.visitInsn(1);
        this.mn.visitVarInsn(54, 1);
        this.assertInvalid();
    }

    public void testInvalidCheckcast() {
        this.mn.visitInsn(3);
        this.mn.visitTypeInsn(192, "java/lang/String");
        this.assertInvalid();
    }

    public void testInvalidArraylength() {
        this.mn.visitInsn(3);
        this.mn.visitInsn(190);
        this.assertInvalid();
    }

    public void testInvalidAthrow() {
        this.mn.visitInsn(3);
        this.mn.visitInsn(191);
        this.assertInvalid();
    }

    public void testInvalidIneg() {
        this.mn.visitInsn(11);
        this.mn.visitInsn(116);
        this.assertInvalid();
    }

    public void testInvalidIadd() {
        this.mn.visitInsn(11);
        this.mn.visitInsn(3);
        this.mn.visitInsn(96);
        this.assertInvalid();
    }

    public void testInvalidIsub() {
        this.mn.visitInsn(3);
        this.mn.visitInsn(11);
        this.mn.visitInsn(100);
        this.assertInvalid();
    }

    public void testInvalidIastore() {
        this.mn.visitInsn(4);
        this.mn.visitIntInsn(188, 10);
        this.mn.visitInsn(11);
        this.mn.visitInsn(3);
        this.mn.visitInsn(79);
        this.assertInvalid();
    }

    public void testInvalidFastore() {
        this.mn.visitInsn(4);
        this.mn.visitIntInsn(188, 6);
        this.mn.visitInsn(3);
        this.mn.visitInsn(3);
        this.mn.visitInsn(81);
        this.assertInvalid();
    }

    public void testInvalidLastore() {
        this.mn.visitInsn(4);
        this.mn.visitInsn(3);
        this.mn.visitInsn(9);
        this.mn.visitInsn(80);
        this.assertInvalid();
    }

    public void testInvalidMultianewarray() {
        this.mn.visitInsn(12);
        this.mn.visitInsn(5);
        this.mn.visitMultiANewArrayInsn("[[I", 2);
        this.assertInvalid();
    }

    public void testInvalidInvokevirtual() {
        this.mn.visitInsn(1);
        this.mn.visitTypeInsn(192, "java/lang/Object");
        this.mn.visitMethodInsn(182, "java/util/ArrayList", "size", "()I", false);
        this.assertInvalid();
    }

    public void testInvalidInvokeinterface() {
        this.mn.visitInsn(1);
        this.mn.visitTypeInsn(192, "java/util/List");
        this.mn.visitInsn(11);
        this.mn.visitMethodInsn(185, "java/util/List", "get", "(I)Ljava/lang/Object;", true);
        this.assertInvalid();
    }

    public void testInvalidRet() {
        this.mn.visitVarInsn(169, 1);
        this.assertInvalid();
    }

    public void testInvalidFalloff() {
        this.mn.visitMaxs(10, 10);
        try {
            this.a.analyze("C", this.mn);
            SimpleVerifierUnitTest.fail();
        }
        catch (AnalyzerException e) {
            SimpleVerifierUnitTest.success();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testInvalidSubroutineFalloff() {
        Label l0 = new Label();
        Label l1 = new Label();
        this.mn.visitJumpInsn(167, l0);
        this.mn.visitLabel(l1);
        this.mn.visitVarInsn(58, 1);
        this.mn.visitVarInsn(169, 1);
        this.mn.visitLabel(l0);
        this.mn.visitJumpInsn(168, l1);
        this.mn.visitMaxs(10, 10);
        try {
            this.a.analyze("C", this.mn);
            SimpleVerifierUnitTest.fail();
        }
        catch (AnalyzerException e) {
            SimpleVerifierUnitTest.success();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testNestedSubroutines() throws AnalyzerException {
        Label l0 = new Label();
        Label l1 = new Label();
        this.mn.visitJumpInsn(168, l0);
        this.mn.visitInsn(177);
        this.mn.visitLabel(l0);
        this.mn.visitVarInsn(58, 1);
        this.mn.visitJumpInsn(168, l1);
        this.mn.visitJumpInsn(168, l1);
        this.mn.visitVarInsn(169, 1);
        this.mn.visitLabel(l1);
        this.mn.visitVarInsn(58, 2);
        this.mn.visitVarInsn(169, 2);
        this.assertValid();
    }

    public void testSubroutineLocalsAccess() throws AnalyzerException {
        MethodNode mv = this.mn;
        ((MethodVisitor)mv).visitCode();
        Label l0 = new Label();
        Label l1 = new Label();
        Label l2 = new Label();
        Label l3 = new Label();
        ((MethodVisitor)mv).visitTryCatchBlock(l0, l0, l1, null);
        ((MethodVisitor)mv).visitTryCatchBlock(l0, l2, l2, "java/lang/RuntimeException");
        ((MethodVisitor)mv).visitLabel(l0);
        ((MethodVisitor)mv).visitJumpInsn(168, l3);
        ((MethodVisitor)mv).visitInsn(177);
        ((MethodVisitor)mv).visitLabel(l1);
        ((MethodVisitor)mv).visitVarInsn(58, 1);
        ((MethodVisitor)mv).visitJumpInsn(168, l3);
        ((MethodVisitor)mv).visitVarInsn(25, 1);
        ((MethodVisitor)mv).visitInsn(191);
        ((MethodVisitor)mv).visitLabel(l3);
        ((MethodVisitor)mv).visitVarInsn(58, 2);
        ((MethodVisitor)mv).visitInsn(1);
        ((MethodVisitor)mv).visitVarInsn(58, 3);
        ((MethodVisitor)mv).visitVarInsn(169, 2);
        ((MethodVisitor)mv).visitLabel(l2);
        ((MethodVisitor)mv).visitVarInsn(58, 4);
        ((MethodVisitor)mv).visitVarInsn(25, 4);
        ((MethodVisitor)mv).visitInsn(191);
        this.assertValid();
    }

    public void _testOverlappingSubroutines() {
        Label l0 = new Label();
        Label l1 = new Label();
        Label l2 = new Label();
        this.mn.visitJumpInsn(168, l0);
        this.mn.visitJumpInsn(168, l1);
        this.mn.visitInsn(177);
        this.mn.visitLabel(l0);
        this.mn.visitVarInsn(58, 1);
        this.mn.visitJumpInsn(167, l2);
        this.mn.visitLabel(l1);
        this.mn.visitVarInsn(58, 1);
        this.mn.visitLabel(l2);
        this.mn.visitVarInsn(169, 1);
        this.assertInvalid();
    }

    public void testMerge() throws AnalyzerException {
        Label l0 = new Label();
        this.mn.visitVarInsn(25, 0);
        this.mn.visitVarInsn(58, 1);
        this.mn.visitInsn(1);
        this.mn.visitTypeInsn(192, "java/lang/Number");
        this.mn.visitVarInsn(58, 2);
        this.mn.visitVarInsn(25, 0);
        this.mn.visitVarInsn(58, 3);
        this.mn.visitLabel(l0);
        this.mn.visitInsn(1);
        this.mn.visitTypeInsn(192, "java/lang/Number");
        this.mn.visitVarInsn(58, 1);
        this.mn.visitVarInsn(25, 0);
        this.mn.visitVarInsn(58, 2);
        this.mn.visitInsn(1);
        this.mn.visitTypeInsn(192, "java/lang/Integer");
        this.mn.visitVarInsn(58, 3);
        this.mn.visitJumpInsn(167, l0);
        this.assertValid();
    }

    public void testClassNotFound() {
        Label l0 = new Label();
        this.mn.visitVarInsn(25, 0);
        this.mn.visitVarInsn(58, 1);
        this.mn.visitLabel(l0);
        this.mn.visitInsn(1);
        this.mn.visitTypeInsn(192, "D");
        this.mn.visitVarInsn(58, 1);
        this.mn.visitJumpInsn(167, l0);
        this.mn.visitMaxs(10, 10);
        try {
            this.a.analyze("C", this.mn);
            SimpleVerifierUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void success() {
    }
}

