/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.tree.analysis;

import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriterComputeMaxsUnitTest;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Frame;

public class AnalyzerUnitTest
extends ClassWriterComputeMaxsUnitTest {
    protected boolean isComputeMaxs() {
        return false;
    }

    protected void assertMaxs(int maxStack, int maxLocals) {
        this.mv.visitMaxs(maxStack, maxLocals);
        this.mv.visitEnd();
        this.cw.visitEnd();
        byte[] b = this.cw.toByteArray();
        ClassReader cr = new ClassReader(b);
        cr.accept(new ClassVisitor(327680){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                if (name.equals("m")) {
                    return new MethodNode(327680, access, name, desc, signature, exceptions){

                        public void visitEnd() {
                            Analyzer<BasicValue> a = new Analyzer<BasicValue>(new BasicInterpreter());
                            try {
                                Frame<BasicValue>[] frames = a.analyze("C", this);
                                int mStack = 0;
                                int mLocals = 0;
                                int i = 0;
                                while (i < frames.length) {
                                    if (frames[i] != null) {
                                        mStack = Math.max(mStack, frames[i].getStackSize());
                                        mLocals = Math.max(mLocals, frames[i].getLocals());
                                    }
                                    ++i;
                                }
                                AnalyzerUnitTest.assertEquals((String)"maxStack", (int)this.maxStack, (int)mStack);
                                AnalyzerUnitTest.assertEquals((String)"maxLocals", (int)this.maxLocals, (int)mLocals);
                            }
                            catch (Exception e) {
                                AnalyzerUnitTest.fail((String)e.getMessage());
                            }
                        }
                    };
                }
                return null;
            }
        }, 0);
        try {
            ClassWriterComputeMaxsUnitTest.TestClassLoader loader = new ClassWriterComputeMaxsUnitTest.TestClassLoader();
            Class<?> c = loader.defineClass("C", b);
            c.newInstance();
        }
        catch (Throwable t) {
            AnalyzerUnitTest.fail((String)t.getMessage());
        }
    }

    protected void assertGraph(String graph) {
    }
}

