/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.tree;

import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import junit.framework.TestSuite;
import org.objectweb.asm.AbstractTest;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;

public class ClassNodeTest
extends AbstractTest {
    public static TestSuite suite() throws Exception {
        return new ClassNodeTest().getSuite();
    }

    public void test() throws Exception {
        ClassReader cr = new ClassReader(this.is);
        ClassNode cn = new ClassNode();
        cr.accept(cn, 0);
        int i = 0;
        while (i < cn.methods.size()) {
            MethodNode mn = cn.methods.get(i);
            ListIterator<AbstractInsnNode> it = mn.instructions.iterator();
            HashMap<LabelNode, LabelNode> m = new HashMap<LabelNode, LabelNode>(){

                @Override
                public LabelNode get(Object o) {
                    return (LabelNode)o;
                }
            };
            while (it.hasNext()) {
                AbstractInsnNode insn = (AbstractInsnNode)it.next();
                mn.instructions.set(insn, insn.clone((Map<LabelNode, LabelNode>)m));
            }
            ++i;
        }
        cn.accept(new ClassVisitor(327680){

            public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                return null;
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                return null;
            }
        });
        ClassWriter cw = new ClassWriter(0);
        cn.accept(cw);
        this.assertEquals(cr, new ClassReader(cw.toByteArray()));
    }
}

