/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.jbfc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.jbfc.BFCompiler;

public class BFCompilerTest {
    private BFCompiler bc = new BFCompiler();
    private ClassWriter cw = new ClassWriter(1);

    public static void main(String[] args) throws Throwable {
        new BFCompilerTest().testCompileHelloWorld();
        new BFCompilerTest().testCompileEcho();
        new BFCompilerTest().testCompileYaPi();
        new BFCompilerTest().testCompileTest1();
    }

    public void testCompileHelloWorld() throws Throwable {
        BFCompilerTest.assertEquals("Hello World!\n", this.execute("Hello", ">+++++++++[<++++++++>-]<.>+++++++[<++++>-]<+.+++++++..+++.[-]>++++++++[<++++>-]<.#>+++++++++++[<+++++>-]<.>++++++++[<+++>-]<.+++.------.--------.[-]>++++++++[<++++>-]<+.[-]++++++++++.", ""));
    }

    public void testCompileEcho() throws Throwable {
        BFCompilerTest.assertEquals("AAA", this.execute("Echo", ",+[-.,+]", "AAA"));
    }

    public void testCompileYaPi() throws Throwable {
        BFCompilerTest.assertEquals("3.1415926\n", this.execute("YaPi", ">+++++[<+++++++++>-]>>>>>>\r\n\r\n+++++ +++ (7 digits)\r\n\r\n[<<+>++++++++++>-]<<+>>+++<[->>+<-[>>>]>[[<+>-]>+>>]<<<<<]>[-]>[-]>[<+>-]<[>+<[-\r\n>>>>>>>+<<<<<<<]>[->+>>>>>>+<<<<<<<]>>>>++>>-]>[-]<<<[<<<<<<<]<[->>>>>[>>>>>>>]<\r\n<<<<<<[>>>>[-]>>>>>>>[-<<<<<<<+>>>>>>>]<<<<<<<<[<<++++++++++>>-]>[<<<<[>+>>+<<<-\r\n]>>>[<<<+>>>-]>-]<<<<[>>++>+<<<-]>>->[<<<+>>>-]>[-]<<<[->>+<-[>>>]>[[<+>-]>+>>]<\r\n<<<<]>[-]<<<<<<<<<]>+>>>>>>->>>>[<<<<<<<<+>>>>>>>>-]<<<<<<<[-]++++++++++<[->>+<-\r\n[>>>]>[[<+>-]>+>>]<<<<<]>[-]>[>>>>>+<<<<<-]>[<+>>+<-]>[<+>-]<<<+<+>>[-[-[-[-[-[-\r\n[-[-[-<->[-<+<->>[<<+>>[-]]]]]]]]]]]]<[+++++[<<<<++++++++>>>>>++++++++<-]>+<<<<-\r\n>>[>+>-<<<<<+++++++++>>>-]<<<<[>>>>>>+<<<<<<-]<[>>>>>>>.<<<<<<<<[+.[-]]>>]>[<]<+\r\n>>>[<.>-]<[-]>>>>>[-]<[>>[<<<<<<<+>>>>>>>-]<<-]]>>[-]>+<<<<[-]<]++++++++++.", ""));
    }

    public void testCompileTest1() throws Throwable {
        BFCompilerTest.assertEquals("H\n", this.execute("Test1", "[]++++++++++[>++++++++++++++++++>+++++++>+<<<-]A;?@![#>>+<<]>[>++<[-]]>.>.", ""));
    }

    public static void assertEquals(String s1, String s2) {
        if (!s1.equals(s2)) {
            System.out.println("ERROR: expected '" + s1 + "' but got '" + s2 + "'");
        }
    }

    private String execute(String name, String code, String input) throws Throwable {
        this.bc.compile(new StringReader(code), name, name, this.cw);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        InputStream is = System.in;
        PrintStream os = System.out;
        System.setIn(new ByteArrayInputStream(input.getBytes()));
        System.setOut(new PrintStream(bos));
        try {
            try {
                TestClassLoader cl = new TestClassLoader(this.getClass().getClassLoader(), name, this.cw.toByteArray());
                Class<?> c = cl.loadClass(name);
                Method m = c.getDeclaredMethod("main", String[].class);
                m.invoke(null, new Object[]{new String[0]});
            }
            catch (InvocationTargetException ex) {
                throw ex.getCause();
            }
        }
        finally {
            System.setIn(is);
            System.setOut(os);
        }
        String output = new String(bos.toByteArray(), "ASCII");
        System.out.println(String.valueOf(code) + " WITH INPUT '" + input + "' GIVES " + output);
        return output;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TestClassLoader
    extends ClassLoader {
        private final String className;
        private final ClassLoader cl;
        private final byte[] bytecode;

        public TestClassLoader(ClassLoader cl, String className, byte[] bytecode) {
            this.cl = cl;
            this.className = className;
            this.bytecode = bytecode;
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            if (this.className.equals(name)) {
                return super.defineClass(this.className, this.bytecode, 0, this.bytecode.length);
            }
            return this.cl.loadClass(name);
        }
    }
}

