/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.depend;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.depend.DependencyVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyTracker {
    private static final int CELL_PAD = 1;
    private static final int GRID_SIZE = 10;
    private static final int CELLS_SIZE = 8;
    private static final int LABEL_WIDTH = 200;
    private static final String LABEL_FONT = "Tahoma-9";

    public static void main(String[] args) throws IOException {
        DependencyVisitor v = new DependencyVisitor();
        ZipFile f = new ZipFile(args[0]);
        long l1 = System.currentTimeMillis();
        Enumeration<? extends ZipEntry> en = f.entries();
        while (en.hasMoreElements()) {
            ZipEntry e = en.nextElement();
            String name = e.getName();
            if (!name.endsWith(".class")) continue;
            new ClassReader(f.getInputStream(e)).accept(v, 0);
        }
        long l2 = System.currentTimeMillis();
        Map<String, Map<String, Integer>> globals = v.getGlobals();
        Set<String> jarPackages = globals.keySet();
        Set<String> classPackages = v.getPackages();
        int size = classPackages.size();
        System.err.println("time: " + (float)(l2 - l1) / 1000.0f + "  " + size);
        Object[] jarNames = jarPackages.toArray(new String[jarPackages.size()]);
        Object[] classNames = classPackages.toArray(new String[classPackages.size()]);
        Arrays.sort(jarNames);
        Arrays.sort(classNames);
        DependencyTracker.buildDiagram((String[])jarNames, (String[])classNames, globals);
    }

    public static void buildDiagram(String[] jarNames, String[] classNames, Map<String, Map<String, Integer>> globals) throws IOException {
        AffineTransform trans;
        int x;
        int max = 0;
        int i = 0;
        while (i < classNames.length) {
            Integer maxCount;
            Map<String, Integer> map = globals.get(classNames[i]);
            if (map != null && (maxCount = Collections.max(map.values())) > max) {
                max = maxCount;
            }
            ++i;
        }
        ArrayList<Color> colors = new ArrayList<Color>();
        int i2 = 200;
        while (i2 >= 0) {
            colors.add(new Color(i2, i2, 255));
            --i2;
        }
        i2 = 255;
        while (i2 >= 128) {
            colors.add(new Color(0, 0, i2));
            --i2;
        }
        int maxcolor = colors.size() - 1;
        int heigh = 1 + 9 * classNames.length;
        int width = 1 + 9 * jarNames.length;
        BufferedImage img = new BufferedImage(width + 200, heigh + 200, 1);
        Graphics2D g = img.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, width + 200, heigh + 200);
        g.setColor(Color.LIGHT_GRAY);
        int y = 10;
        while (y < classNames.length) {
            g.drawLine(0, y * 9, width, y * 9);
            y += 10;
        }
        int x2 = 10;
        while (x2 < jarNames.length) {
            g.drawLine(x2 * 9, 0, x2 * 9, heigh);
            x2 += 10;
        }
        y = 0;
        while (y < classNames.length) {
            x = 0;
            while (x < jarNames.length) {
                Integer count;
                Map<String, Integer> map = globals.get(jarNames[x]);
                Integer n = count = map == null ? null : map.get(classNames[y]);
                if (count != null) {
                    int b = (int)((float)count.intValue() * (float)maxcolor / (float)max);
                    g.setColor((Color)colors.get(b));
                    g.fillRect(1 + x * 9, 1 + y * 9, 8, 8);
                }
                ++x;
            }
            ++y;
        }
        Font f = Font.decode(LABEL_FONT);
        g.setFont(f);
        g.setColor(Color.GRAY);
        int y2 = 0;
        while (y2 < classNames.length) {
            trans = g.getTransform();
            g.transform(AffineTransform.getTranslateInstance(2 + width, 8 + y2 * 9));
            g.transform(AffineTransform.getRotateInstance(0.2617993877991494));
            g.drawString(classNames[y2], 0, 0);
            g.setTransform(trans);
            ++y2;
        }
        x = 0;
        while (x < jarNames.length) {
            trans = g.getTransform();
            g.transform(AffineTransform.getTranslateInstance(2 + x * 9, heigh + 2));
            g.transform(AffineTransform.getRotateInstance(1.2566370614359172));
            g.drawString(jarNames[x], 0, 0);
            g.setTransform(trans);
            ++x;
        }
        FileOutputStream fos = new FileOutputStream("test.png");
        ImageIO.write((RenderedImage)img, "png", fos);
        fos.flush();
        fos.close();
    }
}

