/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.commons;

import junit.framework.TestCase;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.JSRInlinerAdapter;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;

public class JSRInlinerAdapterUnitTest
extends TestCase {
    private JSRInlinerAdapter jsr;
    private MethodNode exp;
    private MethodVisitor current;

    protected void setUp() throws Exception {
        super.setUp();
        this.jsr = new JSRInlinerAdapter(327680, null, 0, "m", "()V", null, null){

            public void visitEnd() {
                System.err.println("started w/ method:" + this.name);
                Textifier t = new Textifier();
                TraceMethodVisitor mv = new TraceMethodVisitor(t);
                int i = 0;
                while (i < this.instructions.size()) {
                    this.instructions.get(i).accept(mv);
                    System.err.print(Integer.toString(i + 100000).substring(1));
                    System.err.print(" : " + t.text.get(i));
                    ++i;
                }
                super.visitEnd();
                System.err.println("finished w/ method:" + this.name);
            }
        };
        this.exp = new MethodNode(0, "m", "()V", null, null);
    }

    private void setCurrent(MethodVisitor cv) {
        this.current = cv;
    }

    private void ICONST_0() {
        this.current.visitInsn(3);
    }

    private void ISTORE(int var) {
        this.current.visitVarInsn(54, var);
    }

    private void ALOAD(int var) {
        this.current.visitVarInsn(25, var);
    }

    private void ILOAD(int var) {
        this.current.visitVarInsn(21, var);
    }

    private void ASTORE(int var) {
        this.current.visitVarInsn(58, var);
    }

    private void RET(int var) {
        this.current.visitVarInsn(169, var);
    }

    private void ATHROW() {
        this.current.visitInsn(191);
    }

    private void ACONST_NULL() {
        this.current.visitInsn(1);
    }

    private void RETURN() {
        this.current.visitInsn(177);
    }

    private void LABEL(Label l) {
        this.current.visitLabel(l);
    }

    private void IINC(int var, int amnt) {
        this.current.visitIincInsn(var, amnt);
    }

    private void GOTO(Label l) {
        this.current.visitJumpInsn(167, l);
    }

    private void JSR(Label l) {
        this.current.visitJumpInsn(168, l);
    }

    private void IFNONNULL(Label l) {
        this.current.visitJumpInsn(199, l);
    }

    private void IFNE(Label l) {
        this.current.visitJumpInsn(154, l);
    }

    private void TRYCATCH(Label start, Label end, Label handler) {
        this.current.visitTryCatchBlock(start, end, handler, null);
    }

    private void LINE(int line, Label start) {
        this.current.visitLineNumber(line, start);
    }

    private void LOCALVAR(String name, String desc, int index, Label start, Label end) {
        this.current.visitLocalVariable(name, desc, null, start, end, index);
    }

    private void END(int maxStack, int maxLocals) {
        this.current.visitMaxs(maxStack, maxLocals);
        this.current.visitEnd();
        ClassWriter cw = new ClassWriter(0);
        cw.visit(196653, 1, "C", null, "java/lang/Object", null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        ((MethodNode)this.current).accept(cw);
        cw.visitEnd();
        byte[] b = cw.toByteArray();
        try {
            TestClassLoader loader = new TestClassLoader();
            Class<?> c = loader.defineClass("C", b);
            c.newInstance();
        }
        catch (Throwable t) {
            JSRInlinerAdapterUnitTest.fail((String)t.getMessage());
        }
        this.current = null;
    }

    public void testBasic() {
        Label L0 = new Label();
        Label L1 = new Label();
        Label L2 = new Label();
        Label L3 = new Label();
        Label L4 = new Label();
        this.setCurrent(this.jsr);
        this.ICONST_0();
        this.ISTORE(1);
        this.LABEL(L0);
        this.IINC(1, 1);
        this.GOTO(L1);
        this.LABEL(L2);
        this.ASTORE(3);
        this.JSR(L3);
        this.ALOAD(3);
        this.ATHROW();
        this.LABEL(L3);
        this.ASTORE(2);
        this.IINC(1, -1);
        this.RET(2);
        this.LABEL(L1);
        this.JSR(L3);
        this.LABEL(L4);
        this.RETURN();
        this.TRYCATCH(L0, L2, L2);
        this.TRYCATCH(L1, L4, L2);
        this.END(1, 4);
        L0 = new Label();
        L1 = new Label();
        L2 = new Label();
        Label L3_1a = new Label();
        Label L3_1b = new Label();
        Label L3_2a = new Label();
        Label L3_2b = new Label();
        Label L42 = new Label();
        this.setCurrent(this.exp);
        this.ICONST_0();
        this.ISTORE(1);
        this.LABEL(L0);
        this.IINC(1, 1);
        this.GOTO(L1);
        this.LABEL(L2);
        this.ASTORE(3);
        this.ACONST_NULL();
        this.GOTO(L3_1a);
        this.LABEL(L3_1b);
        this.ALOAD(3);
        this.ATHROW();
        this.LABEL(L1);
        this.ACONST_NULL();
        this.GOTO(L3_2a);
        this.LABEL(L3_2b);
        this.LABEL(L42);
        this.RETURN();
        this.LABEL(L3_1a);
        this.ASTORE(2);
        this.IINC(1, -1);
        this.GOTO(L3_1b);
        this.LABEL(new Label());
        this.LABEL(L3_2a);
        this.ASTORE(2);
        this.IINC(1, -1);
        this.GOTO(L3_2b);
        this.LABEL(new Label());
        this.TRYCATCH(L0, L2, L2);
        this.TRYCATCH(L1, L42, L2);
        this.END(1, 4);
        this.assertEquals(this.exp, this.jsr);
    }

    public void testIfElseInFinally() {
        Label L0 = new Label();
        Label L1 = new Label();
        Label L2 = new Label();
        Label L3 = new Label();
        Label L4 = new Label();
        Label L5 = new Label();
        Label L6 = new Label();
        this.setCurrent(this.jsr);
        this.ICONST_0();
        this.ISTORE(1);
        this.LABEL(L0);
        this.IINC(1, 1);
        this.GOTO(L1);
        this.LABEL(L2);
        this.ASTORE(3);
        this.JSR(L3);
        this.ALOAD(3);
        this.ATHROW();
        this.LABEL(L3);
        this.ASTORE(2);
        this.ILOAD(1);
        this.IFNE(L4);
        this.IINC(1, 2);
        this.GOTO(L5);
        this.LABEL(L4);
        this.IINC(1, 3);
        this.LABEL(L5);
        this.RET(2);
        this.LABEL(L1);
        this.JSR(L3);
        this.LABEL(L6);
        this.RETURN();
        this.TRYCATCH(L0, L2, L2);
        this.TRYCATCH(L1, L6, L2);
        this.END(1, 4);
        L0 = new Label();
        L1 = new Label();
        L2 = new Label();
        Label L3_1a = new Label();
        Label L3_1b = new Label();
        Label L3_2a = new Label();
        Label L3_2b = new Label();
        Label L4_1 = new Label();
        Label L4_2 = new Label();
        Label L5_1 = new Label();
        Label L5_2 = new Label();
        Label L62 = new Label();
        this.setCurrent(this.exp);
        this.ICONST_0();
        this.ISTORE(1);
        this.LABEL(L0);
        this.IINC(1, 1);
        this.GOTO(L1);
        this.LABEL(L2);
        this.ASTORE(3);
        this.ACONST_NULL();
        this.GOTO(L3_1a);
        this.LABEL(L3_1b);
        this.ALOAD(3);
        this.ATHROW();
        this.LABEL(L1);
        this.ACONST_NULL();
        this.GOTO(L3_2a);
        this.LABEL(L3_2b);
        this.LABEL(L62);
        this.RETURN();
        this.LABEL(L3_1a);
        this.ASTORE(2);
        this.ILOAD(1);
        this.IFNE(L4_1);
        this.IINC(1, 2);
        this.GOTO(L5_1);
        this.LABEL(L4_1);
        this.IINC(1, 3);
        this.LABEL(L5_1);
        this.GOTO(L3_1b);
        this.LABEL(new Label());
        this.LABEL(L3_2a);
        this.ASTORE(2);
        this.ILOAD(1);
        this.IFNE(L4_2);
        this.IINC(1, 2);
        this.GOTO(L5_2);
        this.LABEL(L4_2);
        this.IINC(1, 3);
        this.LABEL(L5_2);
        this.GOTO(L3_2b);
        this.LABEL(new Label());
        this.TRYCATCH(L0, L2, L2);
        this.TRYCATCH(L1, L62, L2);
        this.END(1, 4);
        this.assertEquals(this.exp, this.jsr);
    }

    public void testSimpleNestedFinally() {
        Label L0 = new Label();
        Label L1 = new Label();
        Label L2 = new Label();
        Label L3 = new Label();
        Label L4 = new Label();
        Label L5 = new Label();
        this.setCurrent(this.jsr);
        this.ICONST_0();
        this.ISTORE(1);
        this.LABEL(L0);
        this.IINC(1, 1);
        this.JSR(L3);
        this.GOTO(L1);
        this.LABEL(L2);
        this.JSR(L3);
        this.ATHROW();
        this.LABEL(L3);
        this.ASTORE(2);
        this.IINC(1, 2);
        this.JSR(L4);
        this.RET(2);
        this.LABEL(L5);
        this.JSR(L4);
        this.ATHROW();
        this.LABEL(L4);
        this.ASTORE(3);
        this.IINC(1, 3);
        this.RET(3);
        this.LABEL(L1);
        this.RETURN();
        this.TRYCATCH(L0, L2, L2);
        this.TRYCATCH(L3, L5, L5);
        this.END(2, 6);
        L0 = new Label();
        L1 = new Label();
        L2 = new Label();
        Label L3_1a = new Label();
        Label L3_1b = new Label();
        Label L3_2a = new Label();
        Label L3_2b = new Label();
        Label L4_1a = new Label();
        Label L4_1b = new Label();
        Label L4_2a = new Label();
        Label L4_2b = new Label();
        Label L4_3a = new Label();
        Label L4_3b = new Label();
        Label L4_4a = new Label();
        Label L4_4b = new Label();
        Label L5_1 = new Label();
        Label L5_2 = new Label();
        this.setCurrent(this.exp);
        this.ICONST_0();
        this.ISTORE(1);
        this.LABEL(L0);
        this.IINC(1, 1);
        this.ACONST_NULL();
        this.GOTO(L3_1a);
        this.LABEL(L3_1b);
        this.GOTO(L1);
        this.LABEL(L2);
        this.ACONST_NULL();
        this.GOTO(L3_2a);
        this.LABEL(L3_2b);
        this.ATHROW();
        this.LABEL(L1);
        this.RETURN();
        this.LABEL(L3_1a);
        this.ASTORE(2);
        this.IINC(1, 2);
        this.ACONST_NULL();
        this.GOTO(L4_1a);
        this.LABEL(L4_1b);
        this.GOTO(L3_1b);
        this.LABEL(L5_1);
        this.ACONST_NULL();
        this.GOTO(L4_2a);
        this.LABEL(L4_2b);
        this.ATHROW();
        this.LABEL(new Label());
        this.LABEL(L3_2a);
        this.ASTORE(2);
        this.IINC(1, 2);
        this.ACONST_NULL();
        this.GOTO(L4_3a);
        this.LABEL(L4_3b);
        this.GOTO(L3_2b);
        this.LABEL(L5_2);
        this.ACONST_NULL();
        this.GOTO(L4_4a);
        this.LABEL(L4_4b);
        this.ATHROW();
        this.LABEL(new Label());
        this.LABEL(L4_1a);
        this.ASTORE(3);
        this.IINC(1, 3);
        this.GOTO(L4_1b);
        this.LABEL(new Label());
        this.LABEL(L4_2a);
        this.ASTORE(3);
        this.IINC(1, 3);
        this.GOTO(L4_2b);
        this.LABEL(new Label());
        this.LABEL(L4_3a);
        this.ASTORE(3);
        this.IINC(1, 3);
        this.GOTO(L4_3b);
        this.LABEL(new Label());
        this.LABEL(L4_4a);
        this.ASTORE(3);
        this.IINC(1, 3);
        this.GOTO(L4_4b);
        this.LABEL(new Label());
        this.TRYCATCH(L0, L2, L2);
        this.TRYCATCH(L3_1a, L5_1, L5_1);
        this.TRYCATCH(L3_2a, L5_2, L5_2);
        this.END(2, 6);
        this.assertEquals(this.exp, this.jsr);
    }

    public void testSubroutineWithNoRet() {
        Label L0 = new Label();
        Label L1 = new Label();
        Label L2 = new Label();
        Label L3 = new Label();
        Label L4 = new Label();
        this.setCurrent(this.jsr);
        this.ICONST_0();
        this.ISTORE(1);
        this.LABEL(L0);
        this.IINC(1, 1);
        this.JSR(L1);
        this.GOTO(L2);
        this.LABEL(L3);
        this.ASTORE(2);
        this.JSR(L1);
        this.ALOAD(2);
        this.ATHROW();
        this.LABEL(L1);
        this.ASTORE(3);
        this.IINC(1, 2);
        this.GOTO(L4);
        this.LABEL(L2);
        this.GOTO(L0);
        this.LABEL(L4);
        this.RETURN();
        this.TRYCATCH(L0, L3, L3);
        this.END(1, 4);
        L0 = new Label();
        Label L1_1a = new Label();
        Label L1_1b = new Label();
        Label L1_2a = new Label();
        Label L1_2b = new Label();
        Label L22 = new Label();
        Label L32 = new Label();
        Label L4_1 = new Label();
        Label L4_2 = new Label();
        this.setCurrent(this.exp);
        this.ICONST_0();
        this.ISTORE(1);
        this.LABEL(L0);
        this.IINC(1, 1);
        this.ACONST_NULL();
        this.GOTO(L1_1a);
        this.LABEL(L1_1b);
        this.GOTO(L22);
        this.LABEL(L32);
        this.ASTORE(2);
        this.ACONST_NULL();
        this.GOTO(L1_2a);
        this.LABEL(L1_2b);
        this.ALOAD(2);
        this.ATHROW();
        this.LABEL(L22);
        this.GOTO(L0);
        this.LABEL(new Label());
        this.LABEL(L1_1a);
        this.ASTORE(3);
        this.IINC(1, 2);
        this.GOTO(L4_1);
        this.LABEL(L4_1);
        this.RETURN();
        this.LABEL(L1_2a);
        this.ASTORE(3);
        this.IINC(1, 2);
        this.GOTO(L4_2);
        this.LABEL(L4_2);
        this.RETURN();
        this.TRYCATCH(L0, L32, L32);
        this.END(1, 4);
        this.assertEquals(this.exp, this.jsr);
    }

    public void testSubroutineWithNoRet2() {
        Label L0 = new Label();
        this.setCurrent(this.jsr);
        this.JSR(L0);
        this.LABEL(L0);
        this.ASTORE(0);
        this.RETURN();
        this.END(1, 1);
        Label L0_1a = new Label();
        Label L0_1b = new Label();
        this.setCurrent(this.exp);
        this.ACONST_NULL();
        this.GOTO(L0_1a);
        this.LABEL(L0_1b);
        this.LABEL(L0_1a);
        this.ASTORE(0);
        this.RETURN();
        this.LABEL(new Label());
        this.END(1, 1);
        this.assertEquals(this.exp, this.jsr);
    }

    public void testImplicitExit() {
        Label L0 = new Label();
        Label L1 = new Label();
        Label L2 = new Label();
        Label L3 = new Label();
        Label L4 = new Label();
        Label L5 = new Label();
        this.setCurrent(this.jsr);
        this.ICONST_0();
        this.ISTORE(1);
        this.LABEL(L5);
        this.ACONST_NULL();
        this.IFNONNULL(L4);
        this.LABEL(L0);
        this.IINC(1, 1);
        this.JSR(L1);
        this.GOTO(L2);
        this.LABEL(L3);
        this.ASTORE(2);
        this.JSR(L1);
        this.ALOAD(2);
        this.ATHROW();
        this.LABEL(L1);
        this.ASTORE(3);
        this.IINC(1, 2);
        this.GOTO(L4);
        this.LABEL(L2);
        this.GOTO(L0);
        this.LABEL(L4);
        this.RETURN();
        this.TRYCATCH(L0, L3, L3);
        this.END(1, 4);
        L0 = new Label();
        Label L1_1a = new Label();
        Label L1_1b = new Label();
        Label L1_2a = new Label();
        Label L1_2b = new Label();
        Label L22 = new Label();
        Label L32 = new Label();
        Label L42 = new Label();
        Label L52 = new Label();
        this.setCurrent(this.exp);
        this.ICONST_0();
        this.ISTORE(1);
        this.LABEL(L52);
        this.ACONST_NULL();
        this.IFNONNULL(L42);
        this.LABEL(L0);
        this.IINC(1, 1);
        this.ACONST_NULL();
        this.GOTO(L1_1a);
        this.LABEL(L1_1b);
        this.GOTO(L22);
        this.LABEL(L32);
        this.ASTORE(2);
        this.ACONST_NULL();
        this.GOTO(L1_2a);
        this.LABEL(L1_2b);
        this.ALOAD(2);
        this.ATHROW();
        this.LABEL(L22);
        this.GOTO(L0);
        this.LABEL(L42);
        this.RETURN();
        this.LABEL(L1_1a);
        this.ASTORE(3);
        this.IINC(1, 2);
        this.GOTO(L42);
        this.LABEL(new Label());
        this.LABEL(L1_2a);
        this.ASTORE(3);
        this.IINC(1, 2);
        this.GOTO(L42);
        this.LABEL(new Label());
        this.TRYCATCH(L0, L32, L32);
        this.END(1, 4);
        this.assertEquals(this.exp, this.jsr);
    }

    public void testImplicitExitToAnotherSubroutine() {
        Label T1 = new Label();
        Label C1 = new Label();
        Label S1 = new Label();
        Label L = new Label();
        Label C2 = new Label();
        Label S2 = new Label();
        Label W = new Label();
        Label X = new Label();
        int b = 1;
        int e1 = 2;
        int e2 = 3;
        int r1 = 4;
        int r2 = 5;
        this.setCurrent(this.jsr);
        this.ICONST_0();
        this.ISTORE(1);
        this.LABEL(T1);
        this.JSR(S1);
        this.RETURN();
        this.LABEL(C1);
        this.ASTORE(e1);
        this.JSR(S1);
        this.ALOAD(e1);
        this.ATHROW();
        this.LABEL(S1);
        this.ASTORE(r1);
        this.GOTO(W);
        this.LABEL(L);
        this.JSR(S2);
        this.RETURN();
        this.LABEL(C2);
        this.ASTORE(e2);
        this.JSR(S2);
        this.ALOAD(e2);
        this.ATHROW();
        this.LABEL(S2);
        this.ASTORE(r2);
        this.ILOAD(b);
        this.IFNE(X);
        this.RET(r2);
        this.LABEL(W);
        this.ILOAD(b);
        this.IFNE(L);
        this.LABEL(X);
        this.RET(r1);
        this.TRYCATCH(T1, C1, C1);
        this.TRYCATCH(L, C2, C2);
        this.END(1, 6);
        T1 = new Label();
        C1 = new Label();
        Label S1_1a = new Label();
        Label S1_1b = new Label();
        Label S1_2a = new Label();
        Label S1_2b = new Label();
        Label L_1 = new Label();
        Label L_2 = new Label();
        Label C2_1 = new Label();
        Label C2_2 = new Label();
        Label S2_1_1a = new Label();
        Label S2_1_1b = new Label();
        Label S2_1_2a = new Label();
        Label S2_1_2b = new Label();
        Label S2_2_1a = new Label();
        Label S2_2_1b = new Label();
        Label S2_2_2a = new Label();
        Label S2_2_2b = new Label();
        Label W_1 = new Label();
        Label W_2 = new Label();
        Label X_1 = new Label();
        Label X_2 = new Label();
        int b2 = 1;
        int e12 = 2;
        int e22 = 3;
        int r12 = 4;
        int r22 = 5;
        this.setCurrent(this.exp);
        this.ICONST_0();
        this.ISTORE(1);
        this.LABEL(T1);
        this.ACONST_NULL();
        this.GOTO(S1_1a);
        this.LABEL(S1_1b);
        this.RETURN();
        this.LABEL(C1);
        this.ASTORE(e12);
        this.ACONST_NULL();
        this.GOTO(S1_2a);
        this.LABEL(S1_2b);
        this.ALOAD(e12);
        this.ATHROW();
        this.LABEL(new Label());
        this.LABEL(S1_1a);
        this.ASTORE(r12);
        this.GOTO(W_1);
        this.LABEL(L_1);
        this.ACONST_NULL();
        this.GOTO(S2_1_1a);
        this.LABEL(S2_1_1b);
        this.RETURN();
        this.LABEL(C2_1);
        this.ASTORE(e22);
        this.ACONST_NULL();
        this.GOTO(S2_1_2a);
        this.LABEL(S2_1_2b);
        this.ALOAD(e22);
        this.ATHROW();
        this.LABEL(W_1);
        this.ILOAD(b2);
        this.IFNE(L_1);
        this.LABEL(X_1);
        this.GOTO(S1_1b);
        this.LABEL(S1_2a);
        this.ASTORE(r12);
        this.GOTO(W_2);
        this.LABEL(L_2);
        this.ACONST_NULL();
        this.GOTO(S2_2_1a);
        this.LABEL(S2_2_1b);
        this.RETURN();
        this.LABEL(C2_2);
        this.ASTORE(e22);
        this.ACONST_NULL();
        this.GOTO(S2_2_2a);
        this.LABEL(S2_2_2b);
        this.ALOAD(e22);
        this.ATHROW();
        this.LABEL(W_2);
        this.ILOAD(b2);
        this.IFNE(L_2);
        this.LABEL(X_2);
        this.GOTO(S1_2b);
        this.LABEL(S2_1_1a);
        this.ASTORE(r22);
        this.ILOAD(b2);
        this.IFNE(X_1);
        this.GOTO(S2_1_1b);
        this.LABEL(new Label());
        this.LABEL(S2_1_2a);
        this.ASTORE(r22);
        this.ILOAD(b2);
        this.IFNE(X_1);
        this.GOTO(S2_1_2b);
        this.LABEL(new Label());
        this.LABEL(S2_2_1a);
        this.ASTORE(r22);
        this.ILOAD(b2);
        this.IFNE(X_2);
        this.GOTO(S2_2_1b);
        this.LABEL(new Label());
        this.LABEL(S2_2_2a);
        this.ASTORE(r22);
        this.ILOAD(b2);
        this.IFNE(X_2);
        this.GOTO(S2_2_2b);
        this.LABEL(new Label());
        this.TRYCATCH(T1, C1, C1);
        this.TRYCATCH(L_1, C2_1, C2_1);
        this.TRYCATCH(L_2, C2_2, C2_2);
        this.END(1, 6);
        this.assertEquals(this.exp, this.jsr);
    }

    public void testCommonCodeWhichMustBeDuplicated() {
        Label L1 = new Label();
        Label L2 = new Label();
        Label L3 = new Label();
        this.setCurrent(this.jsr);
        this.ICONST_0();
        this.ISTORE(1);
        this.JSR(L1);
        this.JSR(L1);
        this.JSR(L2);
        this.JSR(L2);
        this.RETURN();
        this.LABEL(L1);
        this.IINC(1, 1);
        this.GOTO(L3);
        this.LABEL(L2);
        this.IINC(1, 2);
        this.GOTO(L3);
        this.LABEL(L3);
        this.RETURN();
        this.END(1, 2);
        Label L1_1a = new Label();
        Label L1_1b = new Label();
        Label L1_2a = new Label();
        Label L1_2b = new Label();
        Label L2_1a = new Label();
        Label L2_1b = new Label();
        Label L2_2a = new Label();
        Label L2_2b = new Label();
        Label L3_1 = new Label();
        Label L3_2 = new Label();
        Label L3_3 = new Label();
        Label L3_4 = new Label();
        this.setCurrent(this.exp);
        this.ICONST_0();
        this.ISTORE(1);
        this.ACONST_NULL();
        this.GOTO(L1_1a);
        this.LABEL(L1_1b);
        this.ACONST_NULL();
        this.GOTO(L1_2a);
        this.LABEL(L1_2b);
        this.ACONST_NULL();
        this.GOTO(L2_1a);
        this.LABEL(L2_1b);
        this.ACONST_NULL();
        this.GOTO(L2_2a);
        this.LABEL(L2_2b);
        this.RETURN();
        this.LABEL(new Label());
        this.LABEL(L1_1a);
        this.IINC(1, 1);
        this.GOTO(L3_1);
        this.LABEL(L3_1);
        this.RETURN();
        this.LABEL(L1_2a);
        this.IINC(1, 1);
        this.GOTO(L3_2);
        this.LABEL(L3_2);
        this.RETURN();
        this.LABEL(L2_1a);
        this.IINC(1, 2);
        this.GOTO(L3_3);
        this.LABEL(L3_3);
        this.RETURN();
        this.LABEL(L2_2a);
        this.IINC(1, 2);
        this.GOTO(L3_4);
        this.LABEL(L3_4);
        this.RETURN();
        this.END(1, 2);
        this.assertEquals(this.exp, this.jsr);
    }

    public void testInterleavedCode() {
        Label L1 = new Label();
        Label L2 = new Label();
        Label L3 = new Label();
        Label L4 = new Label();
        this.setCurrent(this.jsr);
        this.ICONST_0();
        this.ISTORE(1);
        this.JSR(L1);
        this.GOTO(L2);
        this.LABEL(L1);
        this.ASTORE(2);
        this.IINC(1, 1);
        this.GOTO(L3);
        this.LABEL(L2);
        this.IINC(1, 2);
        this.GOTO(L4);
        this.LABEL(L3);
        this.IINC(1, 4);
        this.RET(2);
        this.LABEL(L4);
        this.JSR(L1);
        this.RETURN();
        this.END(1, 3);
        Label L1_1a = new Label();
        Label L1_1b = new Label();
        Label L1_2a = new Label();
        Label L1_2b = new Label();
        Label L22 = new Label();
        Label L3_1 = new Label();
        Label L3_2 = new Label();
        Label L42 = new Label();
        this.setCurrent(this.exp);
        this.ICONST_0();
        this.ISTORE(1);
        this.ACONST_NULL();
        this.GOTO(L1_1a);
        this.LABEL(L1_1b);
        this.GOTO(L22);
        this.LABEL(L22);
        this.IINC(1, 2);
        this.GOTO(L42);
        this.LABEL(L42);
        this.ACONST_NULL();
        this.GOTO(L1_2a);
        this.LABEL(L1_2b);
        this.RETURN();
        this.LABEL(L1_1a);
        this.ASTORE(2);
        this.IINC(1, 1);
        this.GOTO(L3_1);
        this.LABEL(L3_1);
        this.IINC(1, 4);
        this.GOTO(L1_1b);
        this.LABEL(new Label());
        this.LABEL(L1_2a);
        this.ASTORE(2);
        this.IINC(1, 1);
        this.GOTO(L3_2);
        this.LABEL(L3_2);
        this.IINC(1, 4);
        this.GOTO(L1_2b);
        this.LABEL(new Label());
        this.END(1, 3);
        this.assertEquals(this.exp, this.jsr);
    }

    public void testImplicitExitInTryCatch() {
        Label T1 = new Label();
        Label C1 = new Label();
        Label S1 = new Label();
        Label L = new Label();
        Label C2 = new Label();
        Label S2 = new Label();
        Label W = new Label();
        Label X = new Label();
        Label OT = new Label();
        Label OC = new Label();
        int b = 1;
        int e1 = 2;
        int e2 = 3;
        int r1 = 4;
        int r2 = 5;
        this.setCurrent(this.jsr);
        this.ICONST_0();
        this.ISTORE(1);
        this.LABEL(OT);
        this.LABEL(T1);
        this.JSR(S1);
        this.RETURN();
        this.LABEL(C1);
        this.ASTORE(e1);
        this.JSR(S1);
        this.ALOAD(e1);
        this.ATHROW();
        this.LABEL(S1);
        this.ASTORE(r1);
        this.GOTO(W);
        this.LABEL(L);
        this.JSR(S2);
        this.RETURN();
        this.LABEL(C2);
        this.ASTORE(e2);
        this.JSR(S2);
        this.ALOAD(e2);
        this.ATHROW();
        this.LABEL(S2);
        this.ASTORE(r2);
        this.ILOAD(b);
        this.IFNE(X);
        this.RET(r2);
        this.LABEL(W);
        this.ILOAD(b);
        this.IFNE(L);
        this.LABEL(X);
        this.RET(r1);
        this.LABEL(OC);
        this.IINC(b, 3);
        this.RETURN();
        this.TRYCATCH(T1, C1, C1);
        this.TRYCATCH(L, C2, C2);
        this.TRYCATCH(OT, OC, OC);
        this.END(1, 6);
        T1 = new Label();
        C1 = new Label();
        Label S1_1a = new Label();
        Label S1_1b = new Label();
        Label S1_2a = new Label();
        Label S1_2b = new Label();
        Label L_1 = new Label();
        Label L_2 = new Label();
        Label C2_1 = new Label();
        Label C2_2 = new Label();
        Label S2_1_1a = new Label();
        Label S2_1_1b = new Label();
        Label S2_1_2a = new Label();
        Label S2_1_2b = new Label();
        Label S2_2_1a = new Label();
        Label S2_2_1b = new Label();
        Label S2_2_2a = new Label();
        Label S2_2_2b = new Label();
        Label W_1 = new Label();
        Label W_2 = new Label();
        Label X_1 = new Label();
        Label X_2 = new Label();
        Label OT_1 = S1_1a;
        Label OT_2 = S1_2a;
        Label OT_1_1 = S2_1_1a;
        Label OT_1_2 = S2_1_2a;
        Label OT_2_1 = S2_2_1a;
        Label OT_2_2 = S2_2_2a;
        Label OC2 = new Label();
        Label OC_1 = new Label();
        Label OC_2 = new Label();
        Label OC_1_1 = new Label();
        Label OC_1_2 = new Label();
        Label OC_2_1 = new Label();
        Label OC_2_2 = new Label();
        int b2 = 1;
        int e12 = 2;
        int e22 = 3;
        int r12 = 4;
        int r22 = 5;
        this.setCurrent(this.exp);
        this.ICONST_0();
        this.ISTORE(1);
        this.LABEL(T1);
        this.ACONST_NULL();
        this.GOTO(S1_1a);
        this.LABEL(S1_1b);
        this.RETURN();
        this.LABEL(C1);
        this.ASTORE(e12);
        this.ACONST_NULL();
        this.GOTO(S1_2a);
        this.LABEL(S1_2b);
        this.ALOAD(e12);
        this.ATHROW();
        this.LABEL(OC2);
        this.IINC(b2, 3);
        this.RETURN();
        this.LABEL(S1_1a);
        this.ASTORE(r12);
        this.GOTO(W_1);
        this.LABEL(L_1);
        this.ACONST_NULL();
        this.GOTO(S2_1_1a);
        this.LABEL(S2_1_1b);
        this.RETURN();
        this.LABEL(C2_1);
        this.ASTORE(e22);
        this.ACONST_NULL();
        this.GOTO(S2_1_2a);
        this.LABEL(S2_1_2b);
        this.ALOAD(e22);
        this.ATHROW();
        this.LABEL(W_1);
        this.ILOAD(b2);
        this.IFNE(L_1);
        this.LABEL(X_1);
        this.GOTO(S1_1b);
        this.LABEL(OC_1);
        this.LABEL(S1_2a);
        this.ASTORE(r12);
        this.GOTO(W_2);
        this.LABEL(L_2);
        this.ACONST_NULL();
        this.GOTO(S2_2_1a);
        this.LABEL(S2_2_1b);
        this.RETURN();
        this.LABEL(C2_2);
        this.ASTORE(e22);
        this.ACONST_NULL();
        this.GOTO(S2_2_2a);
        this.LABEL(S2_2_2b);
        this.ALOAD(e22);
        this.ATHROW();
        this.LABEL(W_2);
        this.ILOAD(b2);
        this.IFNE(L_2);
        this.LABEL(X_2);
        this.GOTO(S1_2b);
        this.LABEL(OC_2);
        this.LABEL(S2_1_1a);
        this.ASTORE(r22);
        this.ILOAD(b2);
        this.IFNE(X_1);
        this.GOTO(S2_1_1b);
        this.LABEL(OC_1_1);
        this.LABEL(S2_1_2a);
        this.ASTORE(r22);
        this.ILOAD(b2);
        this.IFNE(X_1);
        this.GOTO(S2_1_2b);
        this.LABEL(OC_1_2);
        this.LABEL(S2_2_1a);
        this.ASTORE(r22);
        this.ILOAD(b2);
        this.IFNE(X_2);
        this.GOTO(S2_2_1b);
        this.LABEL(OC_2_1);
        this.LABEL(S2_2_2a);
        this.ASTORE(r22);
        this.ILOAD(b2);
        this.IFNE(X_2);
        this.GOTO(S2_2_2b);
        this.LABEL(OC_2_2);
        this.TRYCATCH(T1, C1, C1);
        this.TRYCATCH(T1, OC2, OC2);
        this.TRYCATCH(L_1, C2_1, C2_1);
        this.TRYCATCH(OT_1, OC_1, OC2);
        this.TRYCATCH(L_2, C2_2, C2_2);
        this.TRYCATCH(OT_2, OC_2, OC2);
        this.TRYCATCH(OT_1_1, OC_1_1, OC2);
        this.TRYCATCH(OT_1_2, OC_1_2, OC2);
        this.TRYCATCH(OT_2_1, OC_2_1, OC2);
        this.TRYCATCH(OT_2_2, OC_2_2, OC2);
        this.END(1, 6);
        this.assertEquals(this.exp, this.jsr);
    }

    public void testBasicLineNumberAndLocalVars() {
        Label LM1 = new Label();
        Label L0 = new Label();
        Label L1 = new Label();
        Label L2 = new Label();
        Label L3 = new Label();
        Label L4 = new Label();
        this.setCurrent(this.jsr);
        this.LABEL(LM1);
        this.LINE(1, LM1);
        this.ICONST_0();
        this.ISTORE(1);
        this.LABEL(L0);
        this.LINE(3, L0);
        this.IINC(1, 1);
        this.GOTO(L1);
        this.LABEL(L2);
        this.ASTORE(3);
        this.JSR(L3);
        this.ALOAD(3);
        this.ATHROW();
        this.LABEL(L3);
        this.LINE(5, L3);
        this.ASTORE(2);
        this.IINC(1, -1);
        this.RET(2);
        this.LABEL(L1);
        this.JSR(L3);
        this.LABEL(L4);
        this.RETURN();
        this.TRYCATCH(L0, L2, L2);
        this.TRYCATCH(L1, L4, L2);
        this.LOCALVAR("a", "I", 1, LM1, L4);
        this.END(1, 4);
        LM1 = new Label();
        L0 = new Label();
        L1 = new Label();
        L2 = new Label();
        Label L3_1a = new Label();
        Label L3_1b = new Label();
        Label L3_1c = new Label();
        Label L3_2a = new Label();
        Label L3_2b = new Label();
        Label L3_2c = new Label();
        Label L42 = new Label();
        this.setCurrent(this.exp);
        this.LABEL(LM1);
        this.LINE(1, LM1);
        this.ICONST_0();
        this.ISTORE(1);
        this.LABEL(L0);
        this.LINE(3, L0);
        this.IINC(1, 1);
        this.GOTO(L1);
        this.LABEL(L2);
        this.ASTORE(3);
        this.ACONST_NULL();
        this.GOTO(L3_1a);
        this.LABEL(L3_1b);
        this.ALOAD(3);
        this.ATHROW();
        this.LABEL(L1);
        this.ACONST_NULL();
        this.GOTO(L3_2a);
        this.LABEL(L3_2b);
        this.LABEL(L42);
        this.RETURN();
        this.LABEL(L3_1a);
        this.LINE(5, L3_1a);
        this.ASTORE(2);
        this.IINC(1, -1);
        this.GOTO(L3_1b);
        this.LABEL(L3_1c);
        this.LABEL(L3_2a);
        this.LINE(5, L3_2a);
        this.ASTORE(2);
        this.IINC(1, -1);
        this.GOTO(L3_2b);
        this.LABEL(L3_2c);
        this.TRYCATCH(L0, L2, L2);
        this.TRYCATCH(L1, L42, L2);
        this.LOCALVAR("a", "I", 1, LM1, L42);
        this.LOCALVAR("a", "I", 1, L3_1a, L3_1c);
        this.LOCALVAR("a", "I", 1, L3_2a, L3_2c);
        this.END(1, 4);
        this.assertEquals(this.exp, this.jsr);
    }

    public void assertEquals(MethodNode exp, MethodNode actual) {
        String textexp = this.getText(exp);
        String textact = this.getText(actual);
        System.err.println("Expected=" + textexp);
        System.err.println("Actual=" + textact);
        JSRInlinerAdapterUnitTest.assertEquals((String)textexp, (String)textact);
    }

    private String getText(MethodNode mn) {
        Textifier tv = new Textifier();
        TraceMethodVisitor tmv = new TraceMethodVisitor(tv);
        mn.accept(tmv);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < tv.text.size()) {
            sb.append(tv.text.get(i));
            ++i;
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TestClassLoader
    extends ClassLoader {
        TestClassLoader() {
        }

        public Class<?> defineClass(String name, byte[] b) {
            return this.defineClass(name, b, 0, b.length);
        }
    }
}

