/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.commons;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.objectweb.asm.AbstractTest;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.AdviceAdapter;
import org.objectweb.asm.commons.LocalVariablesSorter;

public class AdviceAdapterTest
extends AbstractTest {
    public static void main(String[] args) throws Exception {
        TestRunner.run((Test)AdviceAdapterTest.suite());
    }

    public static TestSuite suite() throws Exception {
        return new AdviceAdapterTest().getSuite();
    }

    public void test() throws Exception {
        ClassReader cr = new ClassReader(this.is);
        ClassWriter cw1 = new ClassWriter(0);
        ClassWriter cw2 = new ClassWriter(0);
        cr.accept(new ReferenceClassAdapter(cw1), 8);
        cr.accept(new AdviceClassAdapter(cw2), 8);
        this.assertEquals(new ClassReader(cw1.toByteArray()), new ClassReader(cw2.toByteArray()));
    }

    static class AdviceClassAdapter
    extends ClassVisitor {
        public AdviceClassAdapter(ClassVisitor cv) {
            super(327680, cv);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
            if (mv == null || (access & 0x500) > 0) {
                return mv;
            }
            return new AdviceAdapter(327680, mv, access, name, desc){

                protected void onMethodEnter() {
                }

                protected void onMethodExit(int opcode) {
                }
            };
        }
    }

    static class ReferenceClassAdapter
    extends ClassVisitor {
        public ReferenceClassAdapter(ClassVisitor cv) {
            super(327680, cv);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
            if (mv == null || (access & 0x500) > 0) {
                return mv;
            }
            return new LocalVariablesSorter(access, desc, mv);
        }
    }
}

