/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm;

import java.util.Random;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

class MethodDeadCodeInserter
extends MethodVisitor
implements Opcodes {
    private Random r;

    public MethodDeadCodeInserter(int seed, MethodVisitor mv) {
        super(327680, mv);
        this.r = new Random(seed);
    }

    public void visitInsn(int opcode) {
        super.visitInsn(opcode);
        this.insertDeadcode();
    }

    public void visitIntInsn(int opcode, int operand) {
        super.visitIntInsn(opcode, operand);
        this.insertDeadcode();
    }

    public void visitVarInsn(int opcode, int var) {
        super.visitVarInsn(opcode, var);
        this.insertDeadcode();
    }

    public void visitTypeInsn(int opcode, String type) {
        super.visitTypeInsn(opcode, type);
        this.insertDeadcode();
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        super.visitFieldInsn(opcode, owner, name, desc);
        this.insertDeadcode();
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        super.visitMethodInsn(opcode, owner, name, desc, itf);
        this.insertDeadcode();
    }

    public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
        super.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
        this.insertDeadcode();
    }

    public void visitJumpInsn(int opcode, Label label) {
        super.visitJumpInsn(opcode, label);
        this.insertDeadcode();
    }

    public void visitLdcInsn(Object cst) {
        super.visitLdcInsn(cst);
        this.insertDeadcode();
    }

    public void visitIincInsn(int var, int increment) {
        super.visitIincInsn(var, increment);
        this.insertDeadcode();
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        super.visitTableSwitchInsn(min, max, dflt, labels);
        this.insertDeadcode();
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        super.visitLookupSwitchInsn(dflt, keys, labels);
        this.insertDeadcode();
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        super.visitMultiANewArrayInsn(desc, dims);
        this.insertDeadcode();
    }

    private void insertDeadcode() {
        if ((double)this.r.nextFloat() < 0.02) {
            Label end = new Label();
            this.mv.visitJumpInsn(167, end);
            this.mv.visitLdcInsn("DEAD CODE");
            this.mv.visitLabel(end);
        }
    }
}

