/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm;

import alt.jiapi.reflect.InstructionFactory;
import alt.jiapi.reflect.JiapiClass;
import alt.jiapi.reflect.JiapiMethod;
import alt.jiapi.reflect.MethodExistsException;
import alt.jiapi.reflect.Signature;
import com.claritysys.jvm.classfile.CfMethod;
import com.claritysys.jvm.classfile.ConstantPool;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Method;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import jbet.ClassInfo;
import jbet.Descriptor;
import jbet.Snippit;
import jbet.Type;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.MethodGen;
import org.aspectj.apache.bcel.generic.ClassGen;
import org.aspectj.apache.bcel.generic.ConstantPoolGen;
import org.aspectj.apache.bcel.generic.Instruction;
import org.aspectj.apache.bcel.generic.InstructionList;
import org.aspectj.apache.bcel.generic.PUSH;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.TypeDesc;
import org.gjt.jclasslib.bytecode.ImmediateByteInstruction;
import org.gjt.jclasslib.bytecode.ImmediateShortInstruction;
import org.gjt.jclasslib.bytecode.SimpleInstruction;
import org.gjt.jclasslib.io.ByteCodeWriter;
import org.gjt.jclasslib.structures.AttributeInfo;
import org.gjt.jclasslib.structures.CPInfo;
import org.gjt.jclasslib.structures.ConstantPoolUtil;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.attributes.CodeAttribute;
import org.gjt.jclasslib.structures.attributes.SourceFileAttribute;
import org.gjt.jclasslib.structures.constants.ConstantStringInfo;
import org.mozilla.classfile.ClassFileWriter;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

public class GenPerfTest {
    static final int N = 100000;
    static Method objectCtor = gnu.bytecode.Type.pointer_type.getDeclaredMethod("<init>", 0);
    static Field outField = ClassType.make((String)"java.lang.System").getField("out");
    static Method printlnMethod = ClassType.make((String)"java.io.PrintStream").getDeclaredMethod("println", new gnu.bytecode.Type[]{gnu.bytecode.Type.string_type});
    static TypeDesc printStream = TypeDesc.forClass((String)"java.io.PrintStream");
    static Descriptor emptyDesc = new Descriptor("()V");
    static Descriptor mainDesc = new Descriptor("([Ljava/lang/String;)V");
    static Descriptor printlnDesc = new Descriptor("(Ljava/lang/String;)V");
    static Type printStreamType = new Type("Ljava/io/PrintStream;");
    static Signature emptySig = new Signature("()V");
    static Signature mainSig = new Signature("([Ljava/lang/String;)V");
    static Signature printlnSig = new Signature("(Ljava/lang/String;)V");
    static org.apache.bcel.generic.Type printStreamT = org.apache.bcel.generic.Type.getType((String)"Ljava/io/PrintStream;");
    static org.aspectj.apache.bcel.generic.Type printStreamAT = org.aspectj.apache.bcel.generic.Type.getType((String)"Ljava/io/PrintStream;");

    public static void main(String[] args) throws Exception {
        int i = 0;
        while (i < 5) {
            GenPerfTest.asmTest();
            ++i;
        }
        i = 0;
        while (i < 5) {
            GenPerfTest.gnuByteCodeTest();
            ++i;
        }
        i = 0;
        while (i < 5) {
            GenPerfTest.csgBytecodeTest();
            ++i;
        }
        i = 0;
        while (i < 5) {
            GenPerfTest.cojenTest();
            ++i;
        }
        i = 0;
        while (i < 5) {
            GenPerfTest.jbetTest();
            ++i;
        }
        i = 0;
        while (i < 5) {
            GenPerfTest.jClassLibTest();
            ++i;
        }
        i = 0;
        while (i < 5) {
            GenPerfTest.jiapiTest();
            ++i;
        }
        i = 0;
        while (i < 5) {
            GenPerfTest.mozillaClassFileTest();
            ++i;
        }
        i = 0;
        while (i < 5) {
            GenPerfTest.bcelTest();
            ++i;
        }
        i = 0;
        while (i < 5) {
            GenPerfTest.aspectjBcelTest();
            ++i;
        }
    }

    static void asmTest() {
        long t = System.currentTimeMillis();
        int i = 0;
        while (i < 100000) {
            GenPerfTest.asmHelloWorld();
            ++i;
        }
        t = System.currentTimeMillis() - t;
        System.out.println("ASM generation time: " + (float)t / 100000.0f + " ms/class");
    }

    static void gnuByteCodeTest() {
        long t = System.currentTimeMillis();
        int i = 0;
        while (i < 100000) {
            GenPerfTest.gnuByteCodeHelloWorld();
            ++i;
        }
        t = System.currentTimeMillis() - t;
        System.out.println("gnu.bytecode generation time: " + (float)t / 100000.0f + " ms/class");
    }

    static void csgBytecodeTest() {
        long t = System.currentTimeMillis();
        int i = 0;
        while (i < 100000) {
            GenPerfTest.csgBytecodeHelloWorld();
            ++i;
        }
        t = System.currentTimeMillis() - t;
        System.out.println("CSG bytecode generation time: " + (float)t / 100000.0f + " ms/class");
    }

    static void cojenTest() throws IOException {
        long t = System.currentTimeMillis();
        int i = 0;
        while (i < 100000) {
            GenPerfTest.cojenHelloWorld();
            ++i;
        }
        t = System.currentTimeMillis() - t;
        System.out.println("Cojen generation time: " + (float)t / 100000.0f + " ms/class");
    }

    static void jbetTest() throws IOException {
        long t = System.currentTimeMillis();
        int i = 0;
        while (i < 100000) {
            GenPerfTest.jbetHelloWorld();
            ++i;
        }
        t = System.currentTimeMillis() - t;
        System.out.println("JBET generation time: " + (float)t / 100000.0f + " ms/class");
    }

    static void jClassLibTest() throws IOException, InvalidByteCodeException {
        long t = System.currentTimeMillis();
        int i = 0;
        while (i < 100000) {
            GenPerfTest.jClassLibHelloWorld();
            ++i;
        }
        t = System.currentTimeMillis() - t;
        System.out.println("JClassLib generation time: " + (float)t / 100000.0f + " ms/class");
    }

    static void jiapiTest() throws MethodExistsException {
        int N = 1000;
        long t = System.currentTimeMillis();
        int i = 0;
        while (i < N) {
            GenPerfTest.jiapiHelloWorld();
            ++i;
        }
        t = System.currentTimeMillis() - t;
        System.out.println("Jiapi generation time: " + (float)t / (float)N + " ms/class");
    }

    static void mozillaClassFileTest() {
        long t = System.currentTimeMillis();
        int i = 0;
        while (i < 100000) {
            GenPerfTest.mozillaClassFileHelloWorld();
            ++i;
        }
        t = System.currentTimeMillis() - t;
        System.out.println("Mozilla Class File generation time: " + (float)t / 100000.0f + " ms/class");
    }

    static void bcelTest() {
        long t = System.currentTimeMillis();
        int i = 0;
        while (i < 100000) {
            GenPerfTest.bcelHelloWorld();
            ++i;
        }
        t = System.currentTimeMillis() - t;
        System.out.println("BCEL generation time: " + (float)t / 100000.0f + " ms/class");
    }

    static void aspectjBcelTest() {
        long t = System.currentTimeMillis();
        int i = 0;
        while (i < 100000) {
            GenPerfTest.aspectjBcelHelloWorld();
            ++i;
        }
        t = System.currentTimeMillis() - t;
        System.out.println("AspectJ BCEL generation time: " + (float)t / 100000.0f + " ms/class");
    }

    static byte[] asmHelloWorld() {
        ClassWriter cw = new ClassWriter(1);
        cw.visit(196653, 1, "HelloWorld", null, "java/lang/Object", null);
        cw.visitSource("HelloWorld.java", null);
        MethodVisitor mw = cw.visitMethod(1, "<init>", "()V", null, null);
        mw.visitVarInsn(25, 0);
        mw.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mw.visitInsn(177);
        mw.visitMaxs(0, 0);
        mw.visitEnd();
        mw = cw.visitMethod(9, "main", "([Ljava/lang/String;)V", null, null);
        mw.visitFieldInsn(178, "java/lang/System", "out", "Ljava/io/PrintStream;");
        mw.visitLdcInsn("Hello world!");
        mw.visitMethodInsn(182, "java/io/PrintStream", "println", "(Ljava/lang/String;)V", false);
        mw.visitInsn(177);
        mw.visitMaxs(0, 0);
        mw.visitEnd();
        return cw.toByteArray();
    }

    static byte[] gnuByteCodeHelloWorld() {
        ClassType c = new ClassType("HelloWorld");
        c.setSuper("java.lang.Object");
        c.setModifiers(1);
        c.setSourceFile("HelloWorld.java");
        Method m = c.addMethod("<init>", "()V", 1);
        CodeAttr code = m.startCode();
        code.pushScope();
        code.emitPushThis();
        code.emitInvokeSpecial(objectCtor);
        code.emitReturn();
        code.popScope();
        m = c.addMethod("main", "([Ljava/lang/String;)V", 9);
        code = m.startCode();
        code.pushScope();
        code.emitGetStatic(outField);
        code.emitPushString("Hello world!");
        code.emitInvokeVirtual(printlnMethod);
        code.emitReturn();
        code.popScope();
        return c.writeToArray();
    }

    static byte[] csgBytecodeHelloWorld() {
        com.claritysys.jvm.classfile.ClassFile cf = new com.claritysys.jvm.classfile.ClassFile("HelloWorld", "java/lang/Object", "HelloWorld.java");
        ConstantPool cp = cf.getConstantPool();
        CfMethod method = cf.addMethod(1, "<init>", "()V");
        com.claritysys.jvm.builder.CodeBuilder code = new com.claritysys.jvm.builder.CodeBuilder(method);
        code.add((short)42);
        code.add((short)183, cp.addMethodRef(false, "java/lang/Object", "<init>", "()V"));
        code.add((short)177);
        code.flush();
        method = cf.addMethod(9, "main", "([Ljava/lang/String;)V");
        code = new com.claritysys.jvm.builder.CodeBuilder(method);
        code.add((short)178, cp.addFieldRef("java/lang/System", "out", "Ljava/io/PrintStream;"));
        code.add((short)18, "Hello world!");
        code.add((short)182, cp.addMethodRef(false, "java/io/PrintStream", "println", "(Ljava/lang/String;)V"));
        code.add((short)177);
        code.flush();
        return cf.writeToArray();
    }

    static byte[] cojenHelloWorld() throws IOException {
        ClassFile cf = new ClassFile("HelloWorld");
        cf.setSourceFile("HelloWorld.java");
        cf.addDefaultConstructor();
        TypeDesc[] params = new TypeDesc[]{TypeDesc.STRING.toArrayType()};
        MethodInfo mi = cf.addMethod(Modifiers.PUBLIC_STATIC, "main", null, params);
        CodeBuilder b = new CodeBuilder(mi);
        b.loadStaticField("java.lang.System", "out", printStream);
        b.loadConstant("Hello world!");
        b.invokeVirtual(printStream, "println", null, new TypeDesc[]{TypeDesc.STRING});
        b.returnVoid();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        cf.writeTo((OutputStream)bos);
        return bos.toByteArray();
    }

    static byte[] jbetHelloWorld() throws IOException {
        ClassInfo ci = new ClassInfo(null, "HelloWorld");
        ci.sourceFile = "HelloWorld.java";
        jbet.MethodInfo mi = new jbet.MethodInfo("<init>", emptyDesc, 1);
        mi.code = new Snippit();
        mi.code.push(new jbet.Instruction().setAload(0));
        mi.code.push(new jbet.Instruction().setInvokeSpecial("java/lang/Object", "<init>", emptyDesc));
        mi.code.push(new jbet.Instruction().setReturn());
        mi.maxLocals = 1;
        mi.maxStack = 1;
        ci.addMethod(mi);
        mi = new jbet.MethodInfo("main", mainDesc, 9);
        mi.code = new Snippit();
        mi.code.push(new jbet.Instruction().setGetstatic("java/lang/System", "out", printStreamType));
        mi.code.push(new jbet.Instruction().setSpush("Hello world!"));
        mi.code.push(new jbet.Instruction().setInvokeVirtual("java/io/PrintStream", "println", printlnDesc));
        mi.maxLocals = 1;
        mi.maxStack = 2;
        ci.addMethod(mi);
        ci.resolveConstants();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ci.writeFile((OutputStream)bos);
        return bos.toByteArray();
    }

    static byte[] jClassLibHelloWorld() throws InvalidByteCodeException, IOException {
        org.gjt.jclasslib.structures.ClassFile cf = new org.gjt.jclasslib.structures.ClassFile();
        cf.setConstantPool(new CPInfo[0]);
        ConstantPoolUtil.addConstantUTF8Info((org.gjt.jclasslib.structures.ClassFile)cf, (String)"", (int)0);
        cf.setMajorVersion(45);
        cf.setMinorVersion(3);
        cf.setAccessFlags(1);
        cf.setThisClass(ConstantPoolUtil.addConstantClassInfo((org.gjt.jclasslib.structures.ClassFile)cf, (String)"HelloWorld", (int)0));
        cf.setSuperClass(ConstantPoolUtil.addConstantClassInfo((org.gjt.jclasslib.structures.ClassFile)cf, (String)"java/lang/Object", (int)0));
        SourceFileAttribute sa = new SourceFileAttribute();
        sa.setAttributeNameIndex(ConstantPoolUtil.addConstantUTF8Info((org.gjt.jclasslib.structures.ClassFile)cf, (String)"SourceFile", (int)0));
        sa.setSourcefileIndex(ConstantPoolUtil.addConstantUTF8Info((org.gjt.jclasslib.structures.ClassFile)cf, (String)"HelloWorld.java", (int)0));
        org.gjt.jclasslib.structures.MethodInfo mi1 = new org.gjt.jclasslib.structures.MethodInfo();
        mi1.setAccessFlags(1);
        mi1.setNameIndex(ConstantPoolUtil.addConstantUTF8Info((org.gjt.jclasslib.structures.ClassFile)cf, (String)"<init>", (int)0));
        mi1.setDescriptorIndex(ConstantPoolUtil.addConstantUTF8Info((org.gjt.jclasslib.structures.ClassFile)cf, (String)"()V", (int)0));
        CodeAttribute ca1 = new CodeAttribute();
        ca1.setAttributeNameIndex(ConstantPoolUtil.addConstantUTF8Info((org.gjt.jclasslib.structures.ClassFile)cf, (String)"Code", (int)0));
        ca1.setCode(ByteCodeWriter.writeByteCode(Arrays.asList(new SimpleInstruction(42), new ImmediateShortInstruction(183, ConstantPoolUtil.addConstantMethodrefInfo((org.gjt.jclasslib.structures.ClassFile)cf, (String)"java/lang/Object", (String)"<init>", (String)"()V", (int)0)), new SimpleInstruction(177))));
        ca1.setMaxStack(1);
        ca1.setMaxLocals(1);
        mi1.setAttributes(new AttributeInfo[]{ca1});
        ConstantStringInfo s = new ConstantStringInfo();
        s.setStringIndex(ConstantPoolUtil.addConstantUTF8Info((org.gjt.jclasslib.structures.ClassFile)cf, (String)"Hello world!", (int)0));
        org.gjt.jclasslib.structures.MethodInfo mi2 = new org.gjt.jclasslib.structures.MethodInfo();
        mi2.setAccessFlags(9);
        mi2.setNameIndex(ConstantPoolUtil.addConstantUTF8Info((org.gjt.jclasslib.structures.ClassFile)cf, (String)"main", (int)0));
        mi2.setDescriptorIndex(ConstantPoolUtil.addConstantUTF8Info((org.gjt.jclasslib.structures.ClassFile)cf, (String)"([Ljava/lang/String;)V", (int)0));
        CodeAttribute ca2 = new CodeAttribute();
        ca2.setAttributeNameIndex(ConstantPoolUtil.addConstantUTF8Info((org.gjt.jclasslib.structures.ClassFile)cf, (String)"Code", (int)0));
        ca2.setCode(ByteCodeWriter.writeByteCode(Arrays.asList(new ImmediateShortInstruction(178, ConstantPoolUtil.addConstantFieldrefInfo((org.gjt.jclasslib.structures.ClassFile)cf, (String)"java/lang/System", (String)"out", (String)"Ljava/io/PrintStream;", (int)0)), new ImmediateByteInstruction(18, false, ConstantPoolUtil.addConstantPoolEntry((org.gjt.jclasslib.structures.ClassFile)cf, (CPInfo)s, (int)0)), new ImmediateShortInstruction(182, ConstantPoolUtil.addConstantMethodrefInfo((org.gjt.jclasslib.structures.ClassFile)cf, (String)"java/io/PrintStream", (String)"println", (String)"(Ljava/lang/String;)V", (int)0)))));
        ca2.setMaxStack(2);
        ca2.setMaxLocals(1);
        mi2.setAttributes(new AttributeInfo[]{ca2});
        cf.setMethods(new org.gjt.jclasslib.structures.MethodInfo[]{mi1, mi2});
        cf.setAttributes(new AttributeInfo[]{sa});
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        cf.write((DataOutput)dos);
        dos.close();
        return bos.toByteArray();
    }

    static byte[] jiapiHelloWorld() throws MethodExistsException {
        JiapiClass c = JiapiClass.createClass((String)"HelloWorld");
        JiapiMethod method = c.addMethod(1, "<init>", emptySig);
        alt.jiapi.reflect.InstructionList il = method.getInstructionList();
        InstructionFactory iFactory = il.getInstructionFactory();
        il.add(iFactory.aload(0));
        il.add(iFactory.invoke(0, "java/lang/Object", "<init>", emptySig));
        il.add(iFactory.returnMethod(method));
        method = c.addMethod(9, "main", mainSig);
        il = method.getInstructionList();
        iFactory = il.getInstructionFactory();
        il.add(iFactory.getField(8, "java/lang/System", "out", "Ljava/io/PrintStream;"));
        il.add(iFactory.pushConstant("Hello world!"));
        il.add(iFactory.invoke(0, "java/io/PrintStream", "println", printlnSig));
        il.add(iFactory.returnMethod(method));
        return c.getByteCode();
    }

    static byte[] mozillaClassFileHelloWorld() {
        ClassFileWriter c = new ClassFileWriter("HelloWorld", "java/lang/Object", "HelloWorld.java");
        c.startMethod("<init>", "()V", (short)1);
        c.addLoadThis();
        c.addInvoke(183, "java/lang/Object", "<init>", "()V");
        c.add(177);
        c.stopMethod((short)1);
        c.startMethod("main", "()V", (short)9);
        c.add(178, "java/lang/System", "out", "Ljava/io/PrintStream;");
        c.addPush("Hello world!");
        c.addInvoke(182, "java/io/PrintStream", "println", "(Ljava/lang/String;)V");
        c.add(177);
        c.stopMethod((short)1);
        return c.toByteArray();
    }

    static byte[] bcelHelloWorld() {
        org.apache.bcel.generic.ClassGen cg = new org.apache.bcel.generic.ClassGen("HelloWorld", "java/lang/Object", "HelloWorld.java", 1, null);
        cg.addEmptyConstructor(1);
        org.apache.bcel.generic.ConstantPoolGen cp = cg.getConstantPool();
        org.apache.bcel.generic.InstructionList il = new org.apache.bcel.generic.InstructionList();
        org.apache.bcel.generic.InstructionFactory factory = new org.apache.bcel.generic.InstructionFactory(cg);
        MethodGen mg = new MethodGen(9, (org.apache.bcel.generic.Type)org.apache.bcel.generic.Type.VOID, new org.apache.bcel.generic.Type[]{new ArrayType((org.apache.bcel.generic.Type)org.apache.bcel.generic.Type.STRING, 1)}, null, "main", "HelloWorld", il, cp);
        il.append((org.apache.bcel.generic.Instruction)factory.createGetStatic("java/lang/System", "out", printStreamT));
        il.append((CompoundInstruction)new org.apache.bcel.generic.PUSH(cp, "Hello world!"));
        il.append((org.apache.bcel.generic.Instruction)factory.createInvoke("java.io.PrintStream", "println", (org.apache.bcel.generic.Type)org.apache.bcel.generic.Type.VOID, new org.apache.bcel.generic.Type[]{org.apache.bcel.generic.Type.STRING}, (short)183));
        mg.setMaxStack();
        cg.addMethod(mg.getMethod());
        return cg.getJavaClass().getBytes();
    }

    static byte[] aspectjBcelHelloWorld() {
        ClassGen cg = new ClassGen("HelloWorld", "java/lang/Object", "HelloWorld.java", 1, null);
        cg.addEmptyConstructor(1);
        ConstantPoolGen cp = cg.getConstantPool();
        InstructionList il = new InstructionList();
        org.aspectj.apache.bcel.generic.InstructionFactory factory = new org.aspectj.apache.bcel.generic.InstructionFactory(cg);
        org.aspectj.apache.bcel.generic.MethodGen mg = new org.aspectj.apache.bcel.generic.MethodGen(9, (org.aspectj.apache.bcel.generic.Type)org.aspectj.apache.bcel.generic.Type.VOID, new org.aspectj.apache.bcel.generic.Type[]{new org.aspectj.apache.bcel.generic.ArrayType((org.aspectj.apache.bcel.generic.Type)org.aspectj.apache.bcel.generic.Type.STRING, 1)}, null, "main", "HelloWorld", il, cp);
        il.append((Instruction)factory.createGetStatic("java/lang/System", "out", printStreamAT));
        il.append((org.aspectj.apache.bcel.generic.CompoundInstruction)new PUSH(cp, "Hello world!"));
        il.append((Instruction)factory.createInvoke("java.io.PrintStream", "println", (org.aspectj.apache.bcel.generic.Type)org.aspectj.apache.bcel.generic.Type.VOID, new org.aspectj.apache.bcel.generic.Type[]{org.aspectj.apache.bcel.generic.Type.STRING}, (short)183));
        mg.setMaxStack();
        cg.addMethod(mg.getMethod());
        return cg.getJavaClass().getBytes();
    }
}

