/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm;

import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.objectweb.asm.AbstractTest;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ComputeClassWriter;
import org.objectweb.asm.util.TraceClassVisitor;

public class ClassWriterComputeFramesTest
extends AbstractTest {
    public static void premain(final String agentArgs, Instrumentation inst) {
        inst.addTransformer(new ClassFileTransformer(){

            @Override
            public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain domain, byte[] classFileBuffer) throws IllegalClassFormatException {
                String n = className.replace('/', '.');
                if (n.indexOf("junit") != -1 || n.startsWith("invalid.")) {
                    return null;
                }
                if (agentArgs.length() == 0 || n.indexOf(agentArgs) != -1) {
                    return ClassWriterComputeFramesTest.transformClass(n, classFileBuffer);
                }
                return null;
            }
        });
    }

    static byte[] transformClass(String n, byte[] clazz) {
        ClassReader cr = new ClassReader(clazz);
        ComputeClassWriter cw = new ComputeClassWriter(2);
        cr.accept(new ClassVisitor(327680, cw){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                super.visit((version & 0xFFFF) < 51 ? 51 : version, access, name, signature, superName, interfaces);
            }
        }, 4);
        return cw.toByteArray();
    }

    public static TestSuite suite() throws Exception {
        TestSuite suite = new ClassWriterComputeFramesTest().getSuite();
        suite.addTest((Test)new AbstractTest.VerifierTest());
        return suite;
    }

    public void test() throws Exception {
        try {
            Class.forName(this.n, true, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
        }
        catch (ClassFormatError cfe) {
            ClassWriterComputeFramesTest.fail((String)cfe.getMessage());
        }
        catch (VerifyError ve) {
            String s = String.valueOf(this.n.replace('.', '/')) + ".class";
            InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(s);
            ClassReader cr = new ClassReader(is);
            byte[] b = ClassWriterComputeFramesTest.transformClass("", cr.b);
            StringWriter sw1 = new StringWriter();
            StringWriter sw2 = new StringWriter();
            sw2.write(String.valueOf(ve.toString()) + "\n");
            TraceClassVisitor cv1 = new TraceClassVisitor(new PrintWriter(sw1));
            TraceClassVisitor cv2 = new TraceClassVisitor(new PrintWriter(sw2));
            cr.accept(cv1, 0);
            new ClassReader(b).accept(cv2, 0);
            String s1 = sw1.toString();
            String s2 = sw2.toString();
            ClassWriterComputeFramesTest.assertEquals((String)"different data", (String)s1, (String)s2);
        }
    }
}

