/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm;

import java.io.IOException;
import junit.framework.TestCase;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.Opcodes;

public class ClassReaderUnitTest
extends TestCase
implements Opcodes {
    public void testIllegalConstructorArgument() {
        try {
            new ClassReader(null);
            ClassReaderUnitTest.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testGetItem() throws IOException {
        ClassReader cr = new ClassReader(this.getClass().getName());
        int item = cr.getItem(1);
        ClassReaderUnitTest.assertTrue((item >= 10 ? 1 : 0) != 0);
        ClassReaderUnitTest.assertTrue((item < cr.header ? 1 : 0) != 0);
    }

    public void testReadByte() throws IOException {
        ClassReader cr = new ClassReader(this.getClass().getName());
        ClassReaderUnitTest.assertEquals((int)(cr.b[0] & 0xFF), (int)cr.readByte(0));
    }

    public void testGetAccess() throws Exception {
        String name = this.getClass().getName();
        ClassReaderUnitTest.assertEquals((int)33, (int)new ClassReader(name).getAccess());
    }

    public void testGetClassName() throws Exception {
        String name = this.getClass().getName();
        ClassReaderUnitTest.assertEquals((String)name.replace('.', '/'), (String)new ClassReader(name).getClassName());
    }

    public void testGetSuperName() throws Exception {
        ClassReaderUnitTest.assertEquals((String)TestCase.class.getName().replace('.', '/'), (String)new ClassReader(this.getClass().getName()).getSuperName());
        ClassReaderUnitTest.assertEquals(null, (String)new ClassReader(Object.class.getName()).getSuperName());
    }

    public void testGetInterfaces() throws Exception {
        String[] interfaces = new ClassReader(this.getClass().getName()).getInterfaces();
        ClassReaderUnitTest.assertNotNull((Object)interfaces);
        ClassReaderUnitTest.assertEquals((int)1, (int)interfaces.length);
        ClassReaderUnitTest.assertEquals((String)Opcodes.class.getName().replace('.', '/'), (String)interfaces[0]);
        interfaces = new ClassReader(Opcodes.class.getName()).getInterfaces();
        ClassReaderUnitTest.assertNotNull((Object)interfaces);
    }
}

