/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.TraceClassVisitor;

public abstract class AbstractTest
extends TestCase {
    protected String n;
    protected InputStream is;

    public AbstractTest() {
        super("test");
    }

    protected void init(String n, InputStream is) {
        this.n = n;
        this.is = is;
    }

    protected TestSuite getSuite() throws Exception {
        TestSuite suite = new TestSuite(((Object)((Object)this)).getClass().getName());
        String files = String.valueOf(System.getProperty("asm.test")) + ",";
        String clazz = System.getProperty("asm.test.class");
        String partcount = System.getProperty("parts");
        String partid = System.getProperty("part");
        int parts = partcount == null ? 1 : Integer.parseInt(partcount);
        int part = partid == null ? 0 : Integer.parseInt(partid);
        int id = 0;
        while (files.indexOf(44) != -1) {
            String file = files.substring(0, files.indexOf(44));
            files = files.substring(files.indexOf(44) + 1);
            File f = new File(file);
            if (f.isDirectory()) {
                this.scanDirectory("", f, suite, clazz);
                continue;
            }
            ZipFile zip = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry e = entries.nextElement();
                String n = e.getName();
                String p = n.replace('/', '.');
                if (!n.endsWith(".class") || clazz != null && p.indexOf(clazz) == -1) continue;
                n = p.substring(0, p.length() - 6);
                if (id % parts == part) {
                    InputStream is = zip.getInputStream(e);
                    AbstractTest t = (AbstractTest)((Object)((Object)((Object)this)).getClass().newInstance());
                    t.init(n, is);
                    suite.addTest((Test)t);
                }
                ++id;
            }
        }
        return suite;
    }

    private void scanDirectory(String path, File f, TestSuite suite, String clazz) throws Exception {
        File[] fs = f.listFiles();
        int i = 0;
        while (i < fs.length) {
            String qn;
            String n = fs[i].getName();
            String string = qn = path.length() == 0 ? n : String.valueOf(path) + "." + n;
            if (fs[i].isDirectory()) {
                this.scanDirectory(qn, fs[i], suite, clazz);
            } else if (qn.endsWith(".class") && !qn.startsWith("invalid.") && (clazz == null || qn.startsWith("pkg.") || qn.indexOf(clazz) != -1)) {
                qn = qn.substring(0, qn.length() - 6);
                FileInputStream is = new FileInputStream(fs[i]);
                AbstractTest t = (AbstractTest)((Object)((Object)((Object)this)).getClass().newInstance());
                t.init(qn, is);
                suite.addTest((Test)t);
            }
            ++i;
        }
    }

    public abstract void test() throws Exception;

    public void assertEquals(ClassReader cr1, ClassReader cr2) throws Exception {
        this.assertEquals(cr1, cr2, null, null);
    }

    public void assertEquals(ClassReader cr1, ClassReader cr2, ClassVisitor filter1, ClassVisitor filter2) throws Exception {
        if (!Arrays.equals(cr1.b, cr2.b)) {
            StringWriter sw1 = new StringWriter();
            StringWriter sw2 = new StringWriter();
            ClassVisitor cv1 = new TraceClassVisitor(new PrintWriter(sw1));
            ClassVisitor cv2 = new TraceClassVisitor(new PrintWriter(sw2));
            if (filter1 != null) {
                filter1.cv = cv1;
            }
            if (filter2 != null) {
                filter2.cv = cv2;
            }
            cr1.accept(filter1 == null ? cv1 : filter1, 0);
            cr2.accept(filter2 == null ? cv2 : filter2, 0);
            String s1 = sw1.toString();
            String s2 = sw2.toString();
            try {
                AbstractTest.assertEquals((String)"different data", (String)s1, (String)s2);
            }
            catch (Throwable e) {
                sw1 = new StringWriter();
                sw2 = new StringWriter();
                cv1 = new RemoveUnusedLabelsAdapter(new TraceClassVisitor(new PrintWriter(sw1)));
                cv2 = new RemoveUnusedLabelsAdapter(new TraceClassVisitor(new PrintWriter(sw2)));
                if (filter1 != null) {
                    filter1.cv = cv1;
                }
                if (filter2 != null) {
                    filter2.cv = cv2;
                }
                cr1.accept(filter1 == null ? cv1 : filter1, 0);
                cr2.accept(filter2 == null ? cv2 : filter2, 0);
                s1 = sw1.toString();
                s2 = sw2.toString();
                AbstractTest.assertEquals((String)"different data", (String)s1, (String)s2);
            }
        }
    }

    public String getName() {
        return String.valueOf(super.getName()) + ": " + this.n;
    }

    static class RemoveUnusedLabelsAdapter
    extends ClassVisitor {
        public RemoveUnusedLabelsAdapter(ClassVisitor cv) {
            super(327680, cv);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return new MethodNode(327680, access, name, desc, signature, exceptions){
                Set<LabelNode> usedLabels;
                {
                    this.usedLabels = new HashSet<LabelNode>();
                }

                public void visitLabel(Label label) {
                    this.instructions.add(super.getLabelNode(label));
                }

                public void visitEnd() {
                    ListIterator<AbstractInsnNode> i = this.instructions.iterator();
                    while (i.hasNext()) {
                        AbstractInsnNode n = i.next();
                        if (!(n instanceof LabelNode) || this.usedLabels.contains(n)) continue;
                        i.remove();
                    }
                    this.accept(RemoveUnusedLabelsAdapter.this.cv);
                }

                protected LabelNode getLabelNode(Label l) {
                    LabelNode n = super.getLabelNode(l);
                    this.usedLabels.add(n);
                    return n;
                }
            };
        }
    }

    public static class VerifierTest
    extends TestCase {
        public VerifierTest() {
            super("testVerifier");
        }

        public void testVerifier() throws Exception {
            try {
                Class.forName("invalid.Invalid", true, ((Object)((Object)this)).getClass().getClassLoader());
                VerifierTest.fail((String)"The new JDK 7 verifier does not trigger!");
            }
            catch (VerifyError ve) {
                ve.printStackTrace();
            }
        }
    }
}

