/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.verifier.structurals.ModifiedPass3bVerifier;
import org.aspectj.apache.bcel.classfile.Method;
import org.aspectj.apache.bcel.generic.ClassGen;
import org.aspectj.apache.bcel.generic.ConstantPoolGen;
import org.aspectj.apache.bcel.generic.InstructionList;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.commons.LocalVariablesSorter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.SimpleVerifier;
import serp.bytecode.BCClass;
import serp.bytecode.BCMethod;
import serp.bytecode.Code;
import serp.bytecode.Project;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ALLPerfTest {
    static boolean compute;
    static boolean computeFrames;
    static boolean skipDebug;
    static int repeats;
    static List<byte[]> classes;
    static List<String> classNames;
    private static final int MAX_ITERATION_SEC;

    static {
        classes = new ArrayList<byte[]>();
        classNames = new ArrayList<String>();
        MAX_ITERATION_SEC = Integer.getInteger("max.iteration.sec", 10);
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        String clazz = System.getProperty("asm.test.class");
        List<String> jars = ALLPerfTest.findFiles(System.getProperty("java.home"), ".jar");
        jars.addAll(ALLPerfTest.findJars(File.pathSeparatorChar, System.getProperty("java.class.path")));
        repeats = Integer.getInteger("repeats", 3) + 1;
        HashSet<String> classesFound = new HashSet<String>();
        int i = 0;
        while (i < jars.size()) {
            block4: {
                ZipFile zip;
                try {
                    zip = new ZipFile(jars.get(i));
                }
                catch (IOException e) {
                    System.err.println("Error openning " + jars.get(i));
                    e.printStackTrace();
                    break block4;
                }
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry e = entries.nextElement();
                    String s = e.getName();
                    if (!s.endsWith(".class") || !classesFound.add(s = s.substring(0, s.length() - 6).replace('/', '.')) || clazz != null && s.indexOf(clazz) == -1) continue;
                    InputStream is = zip.getInputStream(e);
                    byte[] bytes = new ClassReader((InputStream)is).b;
                    classes.add(bytes);
                    classNames.add(s);
                    is.close();
                    if (classes.size() % 2500 != 0) continue;
                    System.out.println("... searching, found " + classes.size() + " classes.");
                }
                zip.close();
            }
            ++i;
        }
        System.out.println("Found " + classes.size() + " classes.");
        RunTest nullBCELAdapt = new RunTest(){

            public void test(byte[] bytes, int[] errors) throws IOException {
                ALLPerfTest.nullBCELAdapt(bytes);
            }
        };
        RunTest nullAspectjBCELAdapt = new RunTest(){

            public void test(byte[] bytes, int[] errors) throws IOException {
                ALLPerfTest.nullAspectjBCELAdapt(bytes);
            }
        };
        RunTest nullJavassistAdapt = new RunTest(){
            ClassPool pool;

            public void init() {
                this.pool = new ClassPool(null);
            }

            public void test(byte[] bytes, int[] errors) throws Exception {
                ALLPerfTest.nullJavassistAdapt(this.pool, bytes);
            }
        };
        RunTest nullSERPAdapt = new RunTest(){
            Project p;
            BCClass c;

            public void init() {
                this.p = new Project();
                this.c = null;
            }

            public void test(byte[] bytes, int[] errors) throws Exception {
                this.c = ALLPerfTest.nullSERPAdapt(this.p, this.c, bytes);
            }
        };
        ALLPerfTest.runTestAll("get class info", "", new RunTest(){

            public void test(byte[] bytes, int[] errors) {
                ClassReader cr = new ClassReader(bytes);
                cr.getAccess();
                cr.getClassName();
                cr.getSuperName();
                cr.getInterfaces();
            }
        });
        ALLPerfTest.runTestAll("deserialize", "", new RunTest(){

            public void test(byte[] bytes, int[] errors) {
                new ClassReader(bytes).accept(new EmptyVisitor(), 0);
            }
        });
        ALLPerfTest.runTest("deserialize", "tree package", new RunTest(){

            public void test(byte[] bytes, int[] errors) {
                new ClassReader(bytes).accept(new ClassNode(), 0);
            }
        });
        System.out.println();
        ALLPerfTest.runTestAll("deserialize and reserialize", "", new RunTest(){

            public void test(byte[] bytes, int[] errors) {
                ClassReader cr = new ClassReader(bytes);
                ClassWriter cw = new ClassWriter(0);
                cr.accept(cw, 0);
                cw.toByteArray();
            }
        });
        ALLPerfTest.runTestAll("deserialize and reserialize", "copyPool", new RunTest(){

            public void test(byte[] bytes, int[] errors) {
                ClassReader cr = new ClassReader(bytes);
                ClassWriter cw = new ClassWriter(cr, 0);
                cr.accept(cw, 0);
                cw.toByteArray();
            }
        });
        ALLPerfTest.runTest("deserialize and reserialize", "tree package", new RunTest(){

            public void test(byte[] bytes, int[] errors) {
                ClassWriter cw = new ClassWriter(0);
                ClassNode cn = new ClassNode();
                new ClassReader(bytes).accept(cn, 0);
                cn.accept(cw);
                cw.toByteArray();
            }
        });
        compute = false;
        computeFrames = false;
        ALLPerfTest.runTest("deserialize and reserialize", "BCEL", nullBCELAdapt);
        ALLPerfTest.runTest("deserialize and reserialize", "Aspectj BCEL", nullAspectjBCELAdapt);
        ALLPerfTest.runTest("deserialize and reserialize", "Javassist", nullJavassistAdapt);
        ALLPerfTest.runTest("deserialize and reserialize", "SERP", nullSERPAdapt);
        System.out.println();
        ALLPerfTest.runTest("deserialize and reserialize", "computeMaxs", new RunTest(){

            public void test(byte[] bytes, int[] errors) {
                ClassWriter cw = new ClassWriter(1);
                new ClassReader(bytes).accept(cw, 0);
                cw.toByteArray();
            }
        });
        compute = true;
        computeFrames = false;
        ALLPerfTest.runTest("deserialize and reserialize", "BCEL and computeMaxs", nullBCELAdapt);
        ALLPerfTest.runTest("deserialize and reserialize", "Aspectj BCEL and computeMaxs", nullAspectjBCELAdapt);
        ALLPerfTest.runTest("deserialize and reserialize", "LocalVariablesSorter", new RunTest(){

            public void test(byte[] bytes, int[] errors) {
                ClassWriter cw = new ClassWriter(0);
                new ClassReader(bytes).accept(new ClassVisitor(327680, cw){

                    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                        return new LocalVariablesSorter(access, desc, this.cv.visitMethod(access, name, desc, signature, exceptions));
                    }
                }, 8);
                cw.toByteArray();
            }
        });
        ALLPerfTest.runTestSome("analyze", "SimpleVerifier", new RunTest(){

            public void test(byte[] bytes, int[] errors) {
                ClassReader cr = new ClassReader(bytes);
                ClassNode cn = new ClassNode();
                cr.accept(cn, 2);
                List<MethodNode> methods = cn.methods;
                int k = 0;
                while (k < methods.size()) {
                    MethodNode method = methods.get(k);
                    Analyzer<BasicValue> a = new Analyzer<BasicValue>(new SimpleVerifier());
                    try {
                        a.analyze(cn.name, method);
                    }
                    catch (Throwable th) {
                        errors[0] = errors[0] + 1;
                    }
                    ++k;
                }
            }
        });
        System.out.println();
        ALLPerfTest.runTest("deserialize and reserialize", "computeFrames", new RunTest(){

            public void test(byte[] bytes, int[] errors) {
                ClassWriter cw = new ClassWriter(2);
                new ClassReader(bytes).accept(cw, 0);
                cw.toByteArray();
            }
        });
        compute = false;
        computeFrames = true;
        ALLPerfTest.runTest("deserialize and reserialize", "BCEL and computeFrames", nullBCELAdapt);
        ALLPerfTest.runTest("deserialize and reserialize", "Aspectj BCEL and computeFrames", nullAspectjBCELAdapt);
    }

    public static List<String> findFiles(String directory, String suffix) {
        ArrayList<String> matches = new ArrayList<String>();
        ALLPerfTest.findFiles(matches, new File(directory), suffix);
        return matches;
    }

    static void findFiles(List<String> matches, File directory, String suffix) {
        File[] files = directory.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file.isDirectory()) {
                ALLPerfTest.findFiles(matches, file, suffix);
            } else if (file.getName().endsWith(suffix)) {
                matches.add(file.getAbsolutePath());
            }
            ++i;
        }
    }

    static void runTestAll(String testName, String with, RunTest runTest) throws InterruptedException {
        ALLPerfTest.runTest0(1, true, testName, with, runTest);
    }

    static void runTest(String testName, String with, RunTest runTest) throws InterruptedException {
        ALLPerfTest.runTest0(repeats - 1, false, testName, with, runTest);
    }

    static void runTestSome(String testName, String with, RunTest runTest) throws InterruptedException {
        ALLPerfTest.runTest0(repeats - 1, true, testName, with, runTest);
    }

    private static void runTest0(int testSkip, boolean startAtZero, String testName, String with, RunTest runTest) throws InterruptedException {
        if (with.length() > 0) {
            with = " with " + with;
        }
        boolean skipBigClasses = with.contains("BCEL and computeFrames");
        int totalCount = 0;
        long totalSize = 0L;
        long totalTime = 0L;
        System.out.println("\nStarting " + testName + with + " test.");
        int i = 0;
        while (i < repeats) {
            runTest.init();
            long t = System.currentTimeMillis();
            int count = 0;
            long size = 0L;
            int[] errors = new int[1];
            long longest = 0L;
            int longestSize = 0;
            int skipped = 0;
            int j = startAtZero ? 0 : i;
            while (j < classes.size()) {
                ++count;
                byte[] b = classes.get(j);
                if (skipBigClasses && b.length > 16384) {
                    ++skipped;
                } else {
                    size += (long)b.length;
                    try {
                        long start = System.currentTimeMillis();
                        runTest.test(b, errors);
                        long end = System.currentTimeMillis();
                        long time = end - start;
                        if (longest < time) {
                            longest = time;
                            longestSize = b.length;
                        }
                        if (time > (long)(MAX_ITERATION_SEC * 1000 / 10)) {
                            System.out.println("--- time to " + testName + " the class " + classNames.get(j) + with + " took " + time + " ms. bytes=" + b.length);
                        }
                        if (end - t > (long)(MAX_ITERATION_SEC * 1000)) {
                            break;
                        }
                    }
                    catch (Exception ignored) {
                        errors[0] = errors[0] + 1;
                    }
                    catch (Throwable e) {
                        System.err.println(String.valueOf(classNames.get(j)) + ": " + e);
                        errors[0] = errors[0] + 1;
                    }
                }
                j += testSkip;
            }
            t = System.currentTimeMillis() - t;
            String errorStr = errors[0] > 0 ? " (" + errors[0] + " errors)" : "";
            String skippedStr = skipped == 0 ? "" : " (" + skipped + " skipped as BCEL/computeFrames on >16K classes is very slow)";
            String longestStr = "";
            if (longest > 50L) {
                longestStr = " the longest took " + longest + " ms (" + longestSize + " bytes)";
            }
            if (i > 0) {
                System.out.println("- to " + testName + ' ' + count + " classes" + with + " = " + t + " ms" + errorStr + longestStr + skippedStr + '.');
                totalCount += count;
                totalSize += size;
                totalTime += t;
            }
            ++i;
        }
        System.out.println("Time to " + testName + ' ' + totalCount + " classes" + with + " = " + totalTime + " ms.\n" + "Processing rate = " + (long)(totalCount * 1000) / totalTime + " classes per sec (" + totalSize * 1000L / totalTime / 1024L + " kB per sec).");
        System.gc();
        Thread.sleep(2500L);
    }

    private static List<String> findJars(char pathSeparatorChar, String s) {
        ArrayList<String> ret = new ArrayList<String>();
        int start = 0;
        int pos = s.indexOf(pathSeparatorChar);
        while (pos >= 0) {
            String name = s.substring(start, pos);
            if (name.endsWith(".jar")) {
                ret.add(name);
            }
            start = pos + 1;
            pos = s.indexOf(pathSeparatorChar, start);
        }
        return ret;
    }

    static void nullBCELAdapt(byte[] b) throws IOException {
        JavaClass jc = new ClassParser((InputStream)new ByteArrayInputStream(b), "class-name").parse();
        org.apache.bcel.generic.ClassGen cg = new org.apache.bcel.generic.ClassGen(jc);
        org.apache.bcel.generic.ConstantPoolGen cp = cg.getConstantPool();
        org.apache.bcel.classfile.Method[] ms = cg.getMethods();
        int k = 0;
        while (k < ms.length) {
            boolean ln;
            MethodGen mg = new MethodGen(ms[k], cg.getClassName(), cp);
            boolean lv = ms[k].getLocalVariableTable() == null;
            boolean bl = ln = ms[k].getLineNumberTable() == null;
            if (lv) {
                mg.removeLocalVariables();
            }
            if (ln) {
                mg.removeLineNumbers();
            }
            mg.stripAttributes(skipDebug);
            org.apache.bcel.generic.InstructionList il = mg.getInstructionList();
            if (il != null) {
                InstructionHandle ih = il.getStart();
                while (ih != null) {
                    ih = ih.getNext();
                }
                if (compute) {
                    mg.setMaxStack();
                    mg.setMaxLocals();
                }
                if (computeFrames) {
                    ModifiedPass3bVerifier verif = new ModifiedPass3bVerifier(jc, k);
                    verif.do_verify();
                }
            }
            cg.replaceMethod(ms[k], mg.getMethod());
            ++k;
        }
        cg.getJavaClass().getBytes();
    }

    static void nullAspectjBCELAdapt(byte[] b) throws IOException {
        org.aspectj.apache.bcel.classfile.JavaClass jc = new org.aspectj.apache.bcel.classfile.ClassParser((InputStream)new ByteArrayInputStream(b), "class-name").parse();
        ClassGen cg = new ClassGen(jc);
        ConstantPoolGen cp = cg.getConstantPool();
        Method[] ms = cg.getMethods();
        int k = 0;
        while (k < ms.length) {
            boolean ln;
            org.aspectj.apache.bcel.generic.MethodGen mg = new org.aspectj.apache.bcel.generic.MethodGen(ms[k], cg.getClassName(), cp);
            boolean lv = ms[k].getLocalVariableTable() == null;
            boolean bl = ln = ms[k].getLineNumberTable() == null;
            if (lv) {
                mg.removeLocalVariables();
            }
            if (ln) {
                mg.removeLineNumbers();
            }
            mg.stripAttributes(skipDebug);
            InstructionList il = mg.getInstructionList();
            if (il != null) {
                org.aspectj.apache.bcel.generic.InstructionHandle ih = il.getStart();
                while (ih != null) {
                    ih = ih.getNext();
                }
                if (compute) {
                    mg.setMaxStack();
                    mg.setMaxLocals();
                }
                if (computeFrames) {
                    org.aspectj.apache.bcel.verifier.structurals.ModifiedPass3bVerifier verif = new org.aspectj.apache.bcel.verifier.structurals.ModifiedPass3bVerifier(jc, k);
                    verif.do_verify();
                }
            }
            cg.replaceMethod(ms[k], mg.getMethod());
            ++k;
        }
        cg.getJavaClass().getBytes();
    }

    static void nullJavassistAdapt(ClassPool pool, byte[] b) throws Exception {
        CtClass cc = pool.makeClass((InputStream)new ByteArrayInputStream(b));
        CtMethod[] ms = cc.getDeclaredMethods();
        int j = 0;
        while (j < ms.length) {
            ++j;
        }
        cc.toBytecode();
    }

    static BCClass nullSERPAdapt(Project p, BCClass c, byte[] b) throws Exception {
        if (c != null) {
            p.removeClass(c);
        }
        c = p.loadClass((InputStream)new ByteArrayInputStream(b));
        c.getDeclaredFields();
        BCMethod[] methods = c.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            Code code = methods[i].getCode(false);
            if (code != null) {
                while (code.hasNext()) {
                    code.next();
                }
                if (compute) {
                    code.calculateMaxStack();
                    code.calculateMaxLocals();
                }
            }
            ++i;
        }
        c.toByteArray();
        return c;
    }

    static class EmptyVisitor
    extends ClassVisitor {
        AnnotationVisitor av = new AnnotationVisitor(327680){

            public AnnotationVisitor visitAnnotation(String name, String desc) {
                return this;
            }

            public AnnotationVisitor visitArray(String name) {
                return this;
            }
        };

        public EmptyVisitor() {
            super(327680);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return this.av;
        }

        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            return this.av;
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            return new FieldVisitor(327680){

                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    return EmptyVisitor.this.av;
                }

                public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
                    return EmptyVisitor.this.av;
                }
            };
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return new MethodVisitor(327680){

                public AnnotationVisitor visitAnnotationDefault() {
                    return EmptyVisitor.this.av;
                }

                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    return EmptyVisitor.this.av;
                }

                public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
                    return EmptyVisitor.this.av;
                }

                public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
                    return EmptyVisitor.this.av;
                }

                public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
                    return EmptyVisitor.this.av;
                }

                public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
                    return EmptyVisitor.this.av;
                }

                public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String desc, boolean visible) {
                    return EmptyVisitor.this.av;
                }
            };
        }
    }

    static abstract class RunTest {
        RunTest() {
        }

        public void init() {
        }

        public abstract void test(byte[] var1, int[] var2) throws Exception;
    }
}

