/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.PackageStats;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.config.CommandLine;
import edu.umd.cs.findbugs.filter.Filter;
import edu.umd.cs.findbugs.workflow.Filter;
import edu.umd.cs.findbugs.workflow.RecursiveSearchForJavaFiles;
import edu.umd.cs.findbugs.workflow.SourceSearcher;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.DocumentException;

public class SetBugDatabaseInfo {
    private static final String USAGE = "Usage: <cmd>  [options] [<oldData> [<newData>]]";
    static SourceSearcher sourceSearcher;

    public static void main(String[] args) throws IOException, DocumentException {
        long last;
        FindBugs.setNoAnalysis();
        DetectorFactoryCollection.instance();
        SetInfoCommandLine commandLine = new SetInfoCommandLine();
        int argCount = commandLine.parse(args, 0, 2, USAGE);
        SortedBugCollection origCollection = new SortedBugCollection();
        if (argCount < args.length) {
            origCollection.readXML(args[argCount++]);
        } else {
            origCollection.readXML(System.in);
        }
        Project project = origCollection.getProject();
        if (commandLine.revisionName != null) {
            origCollection.setReleaseName(commandLine.revisionName);
        }
        if (commandLine.projectName != null) {
            origCollection.getProject().setProjectName(commandLine.projectName);
        }
        if (commandLine.revisionTimestamp != 0L) {
            origCollection.setTimestamp(commandLine.revisionTimestamp);
        }
        origCollection.setWithMessages(commandLine.withMessages);
        if (commandLine.purgeDesignations) {
            for (Iterator<Object> b : origCollection) {
                ((BugInstance)((Object)b)).setUserDesignation(null);
            }
        }
        if (commandLine.exclusionFilterFile != null) {
            project.setSuppressionFilter(Filter.parseFilter(commandLine.exclusionFilterFile));
        }
        if (commandLine.resetProject) {
            project.getSourceDirList().clear();
            project.getFileList().clear();
            project.getAuxClasspathEntryList().clear();
        }
        boolean reinitializeCloud = false;
        if (commandLine.cloudId != null) {
            project.setCloudId(commandLine.cloudId);
            reinitializeCloud = true;
        }
        for (Map.Entry entry : commandLine.cloudProperties.entrySet()) {
            project.getCloudProperties().setProperty((String)entry.getKey(), (String)entry.getValue());
            reinitializeCloud = true;
        }
        if (commandLine.resetSource) {
            project.getSourceDirList().clear();
        }
        for (String string : commandLine.sourcePaths) {
            project.addSourceDir(string);
        }
        if (commandLine.purgeStats) {
            origCollection.getProjectStats().getPackageStats().clear();
        }
        if (commandLine.purgeClassStats) {
            for (PackageStats packageStats : origCollection.getProjectStats().getPackageStats()) {
                packageStats.getClassStats().clear();
            }
        }
        if (commandLine.purgeMissingClasses) {
            origCollection.clearMissingClasses();
        }
        if (commandLine.lastVersion != null && (last = Filter.FilterCommandLine.getVersionNum(origCollection, commandLine.lastVersion, true)) < origCollection.getSequenceNumber()) {
            String string = origCollection.getAppVersionFromSequenceNumber(last).getReleaseName();
            long timestamp = origCollection.getAppVersionFromSequenceNumber(last).getTimestamp();
            origCollection.setReleaseName(string);
            origCollection.setTimestamp(timestamp);
            origCollection.trimAppVersions(last);
        }
        HashMap missingFiles = new HashMap();
        if (!commandLine.searchSourcePaths.isEmpty()) {
            sourceSearcher = new SourceSearcher(project);
            for (BugInstance bugInstance : origCollection.getCollection()) {
                SourceLineAnnotation src = bugInstance.getPrimarySourceLineAnnotation();
                if (SetBugDatabaseInfo.sourceSearcher.sourceNotFound.contains(src.getClassName()) || sourceSearcher.findSource(src)) continue;
                Set<String> paths = (Set)missingFiles.get(src.getSourceFile());
                if (paths == null) {
                    paths = new HashSet<String>();
                    missingFiles.put(src.getSourceFile(), paths);
                }
                String fullPath = SetBugDatabaseInfo.fullPath(src);
                paths.add(fullPath);
            }
            HashSet<String> hashSet = new HashSet<String>();
            for (String f : commandLine.searchSourcePaths) {
                for (File javaFile : RecursiveSearchForJavaFiles.search(new File(f))) {
                    Set matchingMissingClasses = (Set)missingFiles.get(javaFile.getName());
                    if (matchingMissingClasses == null) continue;
                    for (String sourcePath : matchingMissingClasses) {
                        String path = javaFile.getAbsolutePath();
                        if (!path.endsWith(sourcePath)) continue;
                        String dir = path.substring(0, path.length() - sourcePath.length());
                        hashSet.add(dir);
                    }
                }
            }
            HashSet<String> hashSet2 = new HashSet<String>();
            block8: for (String p1 : hashSet) {
                for (String p2 : hashSet) {
                    if (p1.equals(p2) || !p1.startsWith(p2)) continue;
                    hashSet2.add(p1);
                    continue block8;
                }
            }
            hashSet.removeAll(hashSet2);
            for (String dir : hashSet) {
                project.addSourceDir(dir);
                if (argCount >= args.length) continue;
                System.out.println("Found " + dir);
            }
        }
        if (reinitializeCloud) {
            origCollection.clearCloud();
        }
        if (argCount < args.length) {
            origCollection.writeXML(args[argCount++]);
        } else {
            origCollection.writeXML(System.out);
        }
    }

    static String fullPath(SourceLineAnnotation src) {
        return src.getPackageName().replace('.', File.separatorChar) + File.separatorChar + src.getSourceFile();
    }

    static class SetInfoCommandLine
    extends CommandLine {
        String revisionName;
        String projectName;
        String exclusionFilterFile;
        String lastVersion;
        String cloudId;
        HashMap<String, String> cloudProperties = new HashMap();
        boolean withMessages = false;
        boolean purgeStats = false;
        boolean purgeClassStats = false;
        boolean purgeMissingClasses = false;
        boolean resetSource = false;
        boolean resetProject = false;
        boolean purgeDesignations = false;
        long revisionTimestamp = 0L;
        public List<String> sourcePaths = new LinkedList<String>();
        public List<String> searchSourcePaths = new LinkedList<String>();

        SetInfoCommandLine() {
            this.addOption("-name", "name", "set name for (last) revision");
            this.addOption("-projectName", "name", "set name for project");
            this.addOption("-timestamp", "when", "set timestamp for (last) revision");
            this.addSwitch("-resetSource", "remove all source search paths");
            this.addSwitch("-resetProject", "remove all source search paths, analysis and auxiliary classpath entries");
            this.addOption("-source", "directory", "Add this directory to the source search path");
            this.addSwitch("-purgeStats", "purge/delete information about sizes of analyzed class files");
            this.addSwitch("-uploadDesignations", "upload all designations to cloud");
            this.addSwitch("-purgeDesignations", "purge/delete user designations (e.g., MUST_FIX or NOT_A_BUG");
            this.addSwitch("-purgeClassStats", "purge/delete information about sizes of analyzed class files, but retain class stats");
            this.addSwitch("-purgeMissingClasses", "purge list of missing classes");
            this.addOption("-findSource", "directory", "Find and add all relevant source directions contained within this directory");
            this.addOption("-suppress", "filter file", "Suppress warnings matched by this file (replaces previous suppressions)");
            this.addOption("-lastVersion", "version", "Trim the history to just include just the specified version");
            this.addSwitch("-withMessages", "Add bug descriptions");
            this.addOption("-cloud", "id", "set cloud id");
            this.addOption("-cloudProperty", "key=value", "set cloud property");
        }

        @Override
        protected void handleOption(String option, String optionExtraPart) throws IOException {
            if ("-withMessages".equals(option)) {
                this.withMessages = true;
            } else if ("-resetSource".equals(option)) {
                this.resetSource = true;
            } else if ("-resetProject".equals(option)) {
                this.resetProject = true;
            } else if ("-purgeStats".equals(option)) {
                this.purgeStats = true;
            } else if ("-purgeDesignations".equals(option)) {
                this.purgeDesignations = true;
            } else if ("-purgeClassStats".equals(option)) {
                this.purgeClassStats = true;
            } else if ("-purgeMissingClasses".equals(option)) {
                this.purgeMissingClasses = true;
            } else {
                throw new IllegalArgumentException("no option " + option);
            }
        }

        @Override
        protected void handleOptionWithArgument(String option, String argument) throws IOException {
            if ("-name".equals(option)) {
                this.revisionName = argument;
            } else if ("-cloud".equals(option)) {
                this.cloudId = argument;
            } else if ("-cloudProperty".equals(option)) {
                int e = argument.indexOf(61);
                if (e == -1) {
                    throw new IllegalArgumentException("Bad cloud property: " + argument);
                }
                String key = argument.substring(0, e);
                String value = argument.substring(e + 1);
                this.cloudProperties.put(key, value);
            } else if ("-projectName".equals(option)) {
                this.projectName = argument;
            } else if ("-suppress".equals(option)) {
                this.exclusionFilterFile = argument;
            } else if ("-timestamp".equals(option)) {
                this.revisionTimestamp = Date.parse(argument);
            } else if ("-source".equals(option)) {
                this.sourcePaths.add(argument);
            } else if ("-lastVersion".equals(option)) {
                this.lastVersion = argument;
            } else if ("-findSource".equals(option)) {
                this.searchSourcePaths.add(argument);
            } else {
                throw new IllegalArgumentException("Can't handle option " + option);
            }
        }
    }
}

