/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SlowInputStream
extends FilterInputStream {
    private final long started = System.currentTimeMillis();
    private long length = 0L;
    private final int bytesPerSecond;

    public SlowInputStream(InputStream in, int baudRate) {
        super(in);
        this.bytesPerSecond = baudRate / 10;
    }

    private void delay() {
        try {
            long beenRunning = System.currentTimeMillis() - this.started;
            long time = this.length * 1000L / (long)this.bytesPerSecond - beenRunning;
            if (time > 0L) {
                Thread.sleep((int)time);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public int read() throws IOException {
        int b = this.in.read();
        if (b >= 0) {
            ++this.length;
        }
        this.delay();
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int tmp;
        if (len > this.bytesPerSecond / 10) {
            len = this.bytesPerSecond / 10;
        }
        if ((tmp = this.in.read(b, off, len)) >= 0) {
            this.length += (long)tmp;
            this.delay();
        }
        return tmp;
    }

    @Override
    public long skip(long n) throws IOException {
        if ((n = this.in.skip(n)) >= 0L) {
            this.length += n;
        }
        this.delay();
        return n;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

