/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.filter;

import edu.umd.cs.findbugs.filter.FilterException;
import edu.umd.cs.findbugs.filter.NameMatch;
import edu.umd.cs.findbugs.util.Util;
import javax.annotation.CheckForNull;

public class MemberMatcher {
    protected final NameMatch name;
    @CheckForNull
    protected final String role;
    @CheckForNull
    protected final NameMatch signature;

    public MemberMatcher(String name) {
        this(name, null, null);
    }

    public MemberMatcher(String name, String signature) {
        this(name, signature, null);
    }

    public MemberMatcher(String name, String signature, String role) {
        if (name == null) {
            if (signature == null) {
                throw new FilterException(this.getClass().getName() + " must have either name or signature attributes");
            }
            name = "~.*";
        }
        this.name = new NameMatch(name);
        this.signature = new NameMatch(signature);
        this.role = role;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (!this.name.isUniversal()) {
            buf.append("name=\"");
            buf.append(this.name.getSpec());
            buf.append("\"");
        }
        if (this.signature != null) {
            if (buf.length() > 0) {
                buf.append(" ");
            }
            buf.append("signature=\"");
            buf.append(this.signature);
            buf.append("\"");
        }
        return buf.toString();
    }

    public int hashCode() {
        return this.name.hashCode() + Util.nullSafeHashcode(this.signature);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemberMatcher other = (MemberMatcher)o;
        return this.name.equals(other.name) && Util.nullSafeEquals(this.signature, other.signature);
    }
}

