/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import java.util.Collections;
import java.util.List;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class InefficientToArray
extends BytecodeScanningDetector
implements StatelessDetector {
    private static final boolean DEBUG = SystemProperties.getBoolean("ita.debug");
    private static final List<MethodDescriptor> methods = Collections.singletonList(new MethodDescriptor("", "toArray", "([Ljava/lang/Object;)[Ljava/lang/Object;"));
    static final int SEEN_NOTHING = 0;
    static final int SEEN_ICONST_0 = 1;
    static final int SEEN_ANEWARRAY = 2;
    private static final JavaClass collectionClass;
    private final BugReporter bugReporter;
    private final BugAccumulator bugAccumulator;
    private int state = 0;

    public InefficientToArray(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        if (collectionClass != null && InefficientToArray.hasInterestingMethod(classContext.getJavaClass().getConstantPool(), methods)) {
            classContext.getJavaClass().accept(this);
        }
    }

    @Override
    public void visit(Method obj) {
        if (DEBUG) {
            System.out.println("------------------- Analyzing " + obj.getName() + " ----------------");
        }
        this.state = 0;
        super.visit(obj);
    }

    @Override
    public void visit(Code obj) {
        super.visit(obj);
        this.bugAccumulator.reportAccumulatedBugs();
    }

    @Override
    public void sawOpcode(int seen) {
        if (DEBUG) {
            System.out.println("State: " + this.state + "  Opcode: " + OPCODE_NAMES[seen]);
        }
        switch (this.state) {
            case 0: {
                if (seen != 3) break;
                this.state = 1;
                break;
            }
            case 1: {
                if (seen == 189) {
                    this.state = 2;
                    break;
                }
                this.state = 0;
                break;
            }
            case 2: {
                if ((seen == 182 || seen == 185) && "toArray".equals(this.getNameConstantOperand()) && "([Ljava/lang/Object;)[Ljava/lang/Object;".equals(this.getSigConstantOperand())) {
                    try {
                        String clsName = this.getDottedClassConstantOperand();
                        JavaClass cls = Repository.lookupClass(clsName);
                        if (cls.implementationOf(collectionClass)) {
                            this.bugAccumulator.accumulateBug(new BugInstance(this, "ITA_INEFFICIENT_TO_ARRAY", 3).addClassAndMethod(this), this);
                        }
                    }
                    catch (ClassNotFoundException cnfe) {
                        this.bugReporter.reportMissingClass(cnfe);
                    }
                }
                this.state = 0;
                break;
            }
            default: {
                this.state = 0;
            }
        }
    }

    static {
        JavaClass tmp = null;
        try {
            tmp = AnalysisContext.lookupSystemClass("java.util.Collection");
        }
        catch (ClassNotFoundException cnfe) {
            AnalysisContext.reportMissingClass(cnfe);
        }
        collectionClass = tmp;
    }
}

