/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.cloud;

import edu.umd.cs.findbugs.AppVersion;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugDesignation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.IGuiCallback;
import edu.umd.cs.findbugs.PackageStats;
import edu.umd.cs.findbugs.ProjectStats;
import edu.umd.cs.findbugs.PropertyBundle;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.cloud.Cloud;
import edu.umd.cs.findbugs.cloud.CloudPlugin;
import edu.umd.cs.findbugs.cloud.MutableCloudTask;
import edu.umd.cs.findbugs.cloud.SignInCancelledException;
import edu.umd.cs.findbugs.cloud.username.NameLookup;
import edu.umd.cs.findbugs.util.ClassName;
import edu.umd.cs.findbugs.util.Multiset;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.OverridingMethodsMustInvokeSuper;

public abstract class AbstractCloud
implements Cloud {
    public static long MIN_TIMESTAMP = new Date(96, 0, 23).getTime();
    protected static final boolean THROW_EXCEPTION_IF_CANT_CONNECT = false;
    private static final Cloud.Mode DEFAULT_VOTING_MODE = Cloud.Mode.COMMUNAL;
    private static final Logger LOGGER = Logger.getLogger(AbstractCloud.class.getName());
    private static final String LEADERBOARD_BLACKLIST = SystemProperties.getProperty("findbugs.leaderboard.blacklist");
    private static final Pattern LEADERBOARD_BLACKLIST_PATTERN;
    protected final CloudPlugin plugin;
    protected final BugCollection bugCollection;
    protected final PropertyBundle properties;
    @CheckForNull
    private Pattern sourceFileLinkPattern;
    private String sourceFileLinkFormat;
    private String sourceFileLinkFormatWithLine;
    private String sourceFileLinkToolTip;
    private final CopyOnWriteArraySet<Cloud.CloudListener> listeners = new CopyOnWriteArraySet();
    private final CopyOnWriteArraySet<Cloud.CloudStatusListener> statusListeners = new CopyOnWriteArraySet();
    private Cloud.Mode mode = Cloud.Mode.COMMUNAL;
    private String statusMsg;
    private Cloud.SigninState signinState = Cloud.SigninState.UNAUTHENTICATED;
    private boolean issueDataDownloaded = false;
    boolean abstractCloudInitialized = false;

    protected AbstractCloud(CloudPlugin plugin, BugCollection bugs, Properties properties) {
        this.plugin = plugin;
        this.bugCollection = bugs;
        this.properties = plugin.getProperties().copy();
        if (!properties.isEmpty()) {
            this.properties.loadProperties(properties);
        }
    }

    @Override
    public boolean isInitialized() {
        return this.abstractCloudInitialized;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean initialize() throws IOException {
        this.abstractCloudInitialized = true;
        String modeString = this.getCloudProperty("votingmode");
        Cloud.Mode newMode = DEFAULT_VOTING_MODE;
        if (modeString != null) {
            try {
                newMode = Cloud.Mode.valueOf(modeString.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                LOGGER.log(Level.WARNING, "No such voting mode " + modeString, e);
            }
        }
        this.setMode(newMode);
        String sp = this.properties.getProperty("findbugs.sourcelink.pattern");
        String sf = this.properties.getProperty("findbugs.sourcelink.format");
        String sfwl = this.properties.getProperty("findbugs.sourcelink.formatWithLine");
        String stt = this.properties.getProperty("findbugs.sourcelink.tooltip");
        if (sp != null && sf != null) {
            try {
                this.sourceFileLinkPattern = Pattern.compile(sp);
                this.sourceFileLinkFormat = sf;
                this.sourceFileLinkToolTip = stt;
                this.sourceFileLinkFormatWithLine = sfwl;
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.WARNING, "Could not compile pattern " + sp, e);
            }
        }
        return true;
    }

    @Override
    public Cloud.Mode getMode() {
        return this.mode;
    }

    @Override
    public void setMode(Cloud.Mode mode) {
        this.mode = mode;
    }

    @Override
    public CloudPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public BugCollection getBugCollection() {
        return this.bugCollection;
    }

    @Override
    public boolean supportsBugLinks() {
        return false;
    }

    @Override
    public void setBugLinkOnCloudAndStoreIssueDetails(BugInstance b, String viewUrl, String linkType) throws IOException, SignInCancelledException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBugStatusCache(BugInstance b, String status) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsClaims() {
        return false;
    }

    @Override
    public boolean supportsCloudReports() {
        return true;
    }

    @Override
    public String claimedBy(BugInstance b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean claim(BugInstance b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public URL getBugLink(BugInstance b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getBugLinkType(BugInstance instance) {
        return null;
    }

    @Override
    public URL fileBug(BugInstance bug) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Cloud.BugFilingStatus getBugLinkStatus(BugInstance b) {
        throw new UnsupportedOperationException();
    }

    public boolean canSeeCommentsByOthers(BugInstance bug) {
        switch (this.getMode()) {
            case SECRET: {
                return false;
            }
            case COMMUNAL: {
                return true;
            }
            case VOTING: {
                return this.hasVoted(bug);
            }
        }
        throw new IllegalStateException();
    }

    public boolean hasVoted(BugInstance bug) {
        for (BugDesignation bd : this.getLatestDesignationFromEachUser(bug)) {
            if (!this.getUser().equals(bd.getUser())) continue;
            return true;
        }
        return false;
    }

    public String notInCloudMsg(BugInstance b) {
        if (this.isOnlineCloud()) {
            return "off line cloud";
        }
        if (this.getSigninState().canDownload()) {
            return "disconnected from cloud";
        }
        if (!this.issueDataDownloaded) {
            return "Waiting for issue data...";
        }
        return "Issue not recorded in cloud";
    }

    @Override
    public String getCloudReport(BugInstance b) {
        return this.getSelectiveCloudReport(b, Collections.emptySet());
    }

    @Override
    public String getCloudReportWithoutMe(BugInstance b) {
        String user = this.getUser();
        Set<String> usersToExclude = user == null ? Collections.emptySet() : Collections.singleton(user);
        return this.getSelectiveCloudReport(b, usersToExclude);
    }

    @Override
    public void bugsPopulated() {
        this.issueDataDownloaded = false;
    }

    private String getSelectiveCloudReport(BugInstance b, Set<String> usersToExclude) {
        Cloud.BugFilingStatus bugLinkStatus;
        if (!this.isInCloud(b)) {
            return this.notInCloudMsg(b);
        }
        this.initiateCommunication();
        SimpleDateFormat format = new SimpleDateFormat("MM/dd, yyyy", Locale.ENGLISH);
        StringBuilder builder = new StringBuilder();
        long firstSeen = this.getFirstSeen(b);
        builder.append(String.format("First seen %s%n", format.format(new Date(firstSeen))));
        builder.append("\n");
        I18N i18n = I18N.instance();
        boolean canSeeCommentsByOthers = this.canSeeCommentsByOthers(b);
        if (canSeeCommentsByOthers && this.supportsBugLinks() && (bugLinkStatus = this.getBugLinkStatus(b)) != null && bugLinkStatus.bugIsFiled()) {
            builder.append("\nBug status is ").append(this.getBugStatus(b));
            if (this.getBugIsUnassigned(b)) {
                builder.append("\nBug is unassigned");
            }
            builder.append("\n\n");
        }
        String me = this.getUser();
        for (BugDesignation d : this.getLatestDesignationFromEachUser(b)) {
            if (usersToExclude.contains(d.getUser()) || (me == null || !me.equals(d.getUser())) && !canSeeCommentsByOthers) continue;
            builder.append(String.format("%s@ %s: %s%n", d.getUser() == null ? "" : d.getUser() + " ", format.format(new Date(d.getTimestamp())), i18n.getUserDesignation(d.getDesignationKey())));
            String annotationText = d.getAnnotationText();
            if (annotationText == null || annotationText.length() <= 0) continue;
            builder.append(annotationText);
            builder.append("\n\n");
        }
        return builder.toString();
    }

    protected boolean issueDataHasBeenDownloaded() {
        return false;
    }

    @Override
    public String getBugStatus(BugInstance b) {
        return null;
    }

    protected abstract Iterable<BugDesignation> getLatestDesignationFromEachUser(BugInstance var1);

    @Override
    public Date getUserDate(BugInstance b) {
        return new Date(this.getUserTimestamp(b));
    }

    @Override
    public void addListener(Cloud.CloudListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeListener(Cloud.CloudListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void addStatusListener(Cloud.CloudStatusListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (!this.statusListeners.contains(listener)) {
            this.statusListeners.add(listener);
        }
    }

    @Override
    public void removeStatusListener(Cloud.CloudStatusListener listener) {
        this.statusListeners.remove(listener);
    }

    @Override
    public String getStatusMsg() {
        return this.statusMsg;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public boolean getIWillFix(BugInstance b) {
        return this.getUserDesignation(b) == Cloud.UserDesignation.I_WILL_FIX;
    }

    @Override
    public Cloud.UserDesignation getConsensusDesignation(BugInstance b) {
        if (b == null) {
            throw new NullPointerException("null bug instance");
        }
        Multiset<Object> designations = new Multiset<Object>();
        int count = 0;
        int totalCount = 0;
        double total = 0.0;
        int isAProblem = 0;
        int notAProblem = 0;
        for (BugDesignation designation : this.getLatestDesignationFromEachUser(b)) {
            Object d = Cloud.UserDesignation.valueOf(designation.getDesignationKey());
            if (d == Cloud.UserDesignation.I_WILL_FIX) {
                d = Cloud.UserDesignation.MUST_FIX;
            } else if (d == Cloud.UserDesignation.UNCLASSIFIED) continue;
            switch (d) {
                case I_WILL_FIX: 
                case MUST_FIX: 
                case SHOULD_FIX: {
                    ++isAProblem;
                    break;
                }
                case BAD_ANALYSIS: 
                case NOT_A_BUG: 
                case MOSTLY_HARMLESS: 
                case OBSOLETE_CODE: {
                    ++notAProblem;
                    break;
                }
            }
            designations.add(d);
            ++totalCount;
            if (d.nonVoting()) continue;
            ++count;
            total += (double)d.score();
        }
        if (totalCount == 0) {
            return Cloud.UserDesignation.UNCLASSIFIED;
        }
        Cloud.UserDesignation mostCommonVotingDesignation = null;
        Cloud.UserDesignation mostCommonDesignation = null;
        for (Map.Entry entry : designations.entriesInDecreasingFrequency()) {
            Cloud.UserDesignation d = (Cloud.UserDesignation)((Object)entry.getKey());
            if (mostCommonVotingDesignation == null && !d.nonVoting()) {
                mostCommonVotingDesignation = d;
                if ((Integer)entry.getValue() > count / 2) {
                    return d;
                }
            }
            if (mostCommonDesignation != null || d == Cloud.UserDesignation.UNCLASSIFIED) continue;
            mostCommonDesignation = d;
            if ((Integer)entry.getValue() <= count / 2) continue;
            return d;
        }
        double score = total / (double)count;
        if (score >= (double)Cloud.UserDesignation.SHOULD_FIX.score() || isAProblem > notAProblem) {
            return Cloud.UserDesignation.SHOULD_FIX;
        }
        if (score <= (double)Cloud.UserDesignation.NOT_A_BUG.score()) {
            return Cloud.UserDesignation.NOT_A_BUG;
        }
        if (score <= (double)Cloud.UserDesignation.MOSTLY_HARMLESS.score() || notAProblem > isAProblem) {
            return Cloud.UserDesignation.MOSTLY_HARMLESS;
        }
        return Cloud.UserDesignation.NEEDS_STUDY;
    }

    @Override
    public boolean overallClassificationIsNotAProblem(BugInstance b) {
        Cloud.UserDesignation consensusDesignation = this.getConsensusDesignation(b);
        return consensusDesignation.notAProblem();
    }

    @Override
    public double getClassificationScore(BugInstance b) {
        int count = 0;
        double total = 0.0;
        for (BugDesignation designation : this.getLatestDesignationFromEachUser(b)) {
            Cloud.UserDesignation d = Cloud.UserDesignation.valueOf(designation.getDesignationKey());
            if (d.nonVoting()) continue;
            ++count;
            total += (double)d.score();
        }
        return total / (double)count;
    }

    @Override
    public double getClassificationVariance(BugInstance b) {
        int count = 0;
        double total = 0.0;
        double totalSquares = 0.0;
        for (BugDesignation designation : this.getLatestDesignationFromEachUser(b)) {
            Cloud.UserDesignation d = Cloud.UserDesignation.valueOf(designation.getDesignationKey());
            if (d.nonVoting()) continue;
            ++count;
            total += (double)d.score();
            totalSquares += (double)(d.score() * d.score());
        }
        double average = total / (double)count;
        return totalSquares / (double)count - average * average;
    }

    @Override
    public double getPortionObsoleteClassifications(BugInstance b) {
        int count = 0;
        double total = 0.0;
        for (BugDesignation designation : this.getLatestDesignationFromEachUser(b)) {
            ++count;
            Cloud.UserDesignation d = Cloud.UserDesignation.valueOf(designation.getDesignationKey());
            if (d != Cloud.UserDesignation.OBSOLETE_CODE) continue;
            total += 1.0;
        }
        return total / (double)count;
    }

    @Override
    public int getNumberReviewers(BugInstance b) {
        int count = 0;
        Iterable<BugDesignation> designations = this.getLatestDesignationFromEachUser(b);
        for (BugDesignation designation : designations) {
            ++count;
        }
        return count;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void printCloudSummary(PrintWriter w, Iterable<BugInstance> bugs, String[] packagePrefixes) {
        void var14_18;
        Multiset<String> evaluations = new Multiset<String>();
        Multiset<String> designations = new Multiset<String>();
        Multiset<String> bugStatus = new Multiset<String>();
        int[] issuesWithThisManyReviews = new int[100];
        I18N i18n = I18N.instance();
        int packageCount = 0;
        int classCount = 0;
        int ncss = 0;
        ProjectStats projectStats = this.bugCollection.getProjectStats();
        for (PackageStats packageStats : projectStats.getPackageStats()) {
            int num = packageStats.getNumClasses();
            if (!ClassName.matchedPrefixes(packagePrefixes, packageStats.getPackageName()) || num <= 0) continue;
            ++packageCount;
            ncss += packageStats.size();
            classCount += num;
        }
        if (classCount == 0) {
            w.println("No classes were analyzed");
            return;
        }
        if (packagePrefixes != null && packagePrefixes.length > 0) {
            String lst = Arrays.asList(packagePrefixes).toString();
            w.println("Code analyzed in " + lst.substring(1, lst.length() - 1));
        } else {
            w.println("Code analyzed");
        }
        w.printf("%,7d packages%n%,7d classes%n", packageCount, classCount);
        if (ncss > 0) {
            w.printf("%,7d thousands of lines of non-commenting source statements%n", (ncss + 999) / 1000);
        }
        w.println();
        int count = 0;
        for (BugInstance bd : bugs) {
            int numReviews;
            String status;
            ++count;
            HashSet<String> reviewers = new HashSet<String>();
            String string = status = this.supportsBugLinks() && this.getBugLinkStatus(bd).bugIsFiled() ? this.getBugStatus(bd) : null;
            if (status != null) {
                bugStatus.add(status);
            }
            for (BugDesignation d : this.getLatestDesignationFromEachUser(bd)) {
                if (!reviewers.add(d.getUser())) continue;
                evaluations.add(d.getUser());
                designations.add(i18n.getUserDesignation(d.getDesignationKey()));
            }
            int n = numReviews = Math.min(reviewers.size(), issuesWithThisManyReviews.length - 1);
            issuesWithThisManyReviews[n] = issuesWithThisManyReviews[n] + 1;
        }
        if (count == this.getBugCollection().getCollection().size()) {
            w.printf("Summary for %d issues%n%n", count);
        } else {
            w.printf("Summary for %d issues that are in the current view%n%n", count);
        }
        if (evaluations.numKeys() == 0) {
            w.println("No reviews found");
        } else {
            w.println("People who have performed the most reviews");
            AbstractCloud.printLeaderBoard(w, evaluations, 9, this.getUser(), true, "reviewer");
            w.println();
            w.println("Distribution of reviews");
            AbstractCloud.printLeaderBoard(w, designations, 100, " --- ", false, "designation");
        }
        if (this.supportsBugLinks()) {
            if (bugStatus.numKeys() == 0) {
                w.println();
                w.println("No bugs filed");
            } else {
                w.println();
                w.println("Distribution of bug status");
                AbstractCloud.printLeaderBoard(w, bugStatus, 100, " --- ", false, "status of filed bug");
            }
        }
        w.println();
        w.println("Distribution of number of reviews");
        boolean bl = false;
        while (var14_18 < issuesWithThisManyReviews.length) {
            if (issuesWithThisManyReviews[var14_18] > 0) {
                w.printf("%4d  with %3d review", issuesWithThisManyReviews[var14_18], (int)var14_18);
                if (var14_18 != true) {
                    w.print("s");
                }
                w.println();
            }
            ++var14_18;
        }
    }

    public static void printLeaderBoard2(PrintWriter w, Multiset<String> evaluations, int maxRows, String alwaysPrint, String format, String title) {
        int row = 1;
        int position = 0;
        int previousScore = -1;
        boolean foundAlwaysPrint = false;
        for (Map.Entry<String, Integer> e : evaluations.entriesInDecreasingFrequency()) {
            int num = e.getValue();
            if (num != previousScore) {
                position = row;
                previousScore = num;
            }
            String key = e.getKey();
            if (LEADERBOARD_BLACKLIST_PATTERN != null && LEADERBOARD_BLACKLIST_PATTERN.matcher(key).matches()) continue;
            boolean shouldAlwaysPrint = key.equals(alwaysPrint);
            if (row <= maxRows || shouldAlwaysPrint) {
                w.printf(format, position, num, key);
            }
            if (shouldAlwaysPrint) {
                foundAlwaysPrint = true;
            }
            if (++row < maxRows) continue;
            if (alwaysPrint == null) break;
            if (!foundAlwaysPrint) continue;
            w.printf("Total of %d %ss%n", evaluations.numKeys(), title);
            break;
        }
    }

    @Override
    public boolean supportsCloudSummaries() {
        return true;
    }

    @Override
    public boolean canStoreUserAnnotation(BugInstance bugInstance) {
        return true;
    }

    @Override
    public double getClassificationDisagreement(BugInstance b) {
        return 0.0;
    }

    @Override
    public Cloud.UserDesignation getUserDesignation(BugInstance b) {
        BugDesignation bd = this.getPrimaryDesignation(b);
        if (bd == null) {
            return Cloud.UserDesignation.UNCLASSIFIED;
        }
        return Cloud.UserDesignation.valueOf(bd.getDesignationKey());
    }

    @Override
    public String getUserEvaluation(BugInstance b) {
        BugDesignation bd = this.getPrimaryDesignation(b);
        if (bd == null) {
            return "";
        }
        String result = bd.getAnnotationText();
        if (result == null) {
            return "";
        }
        return result;
    }

    @Override
    public long getUserTimestamp(BugInstance b) {
        BugDesignation bd = this.getPrimaryDesignation(b);
        if (bd == null) {
            return Long.MAX_VALUE;
        }
        return bd.getTimestamp();
    }

    @Override
    public long getFirstSeen(BugInstance b) {
        return this.getLocalFirstSeen(b);
    }

    @Override
    public void addDateSeen(BugInstance b, long when) {
        throw new UnsupportedOperationException();
    }

    protected void updatedStatus() {
        for (Cloud.CloudListener listener : this.listeners) {
            try {
                listener.statusUpdated();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error executing callback " + listener, e);
            }
        }
    }

    public void updatedIssue(BugInstance bug) {
        for (Cloud.CloudListener listener : this.listeners) {
            try {
                listener.issueUpdated(bug);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error executing callback " + listener, e);
            }
        }
    }

    protected void fireIssueDataDownloadedEvent() {
        this.issueDataDownloaded = true;
        for (Cloud.CloudStatusListener statusListener : this.statusListeners) {
            statusListener.handleIssueDataDownloadedEvent();
        }
    }

    @Override
    public Cloud.SigninState getSigninState() {
        return this.signinState;
    }

    public void setSigninState(Cloud.SigninState state) {
        Cloud.SigninState oldState = this.signinState;
        if (oldState == state) {
            return;
        }
        LOGGER.log(Level.FINER, "State " + (Object)((Object)oldState) + " -> " + (Object)((Object)state), new Throwable("Change in login state at:"));
        this.signinState = state;
        for (Cloud.CloudStatusListener statusListener : this.statusListeners) {
            statusListener.handleStateChange(oldState, state);
        }
    }

    public BugInstance getBugByHash(String hash) {
        for (BugInstance instance : this.bugCollection.getCollection()) {
            if (!instance.getInstanceHash().equals(hash)) continue;
            return instance;
        }
        return null;
    }

    protected NameLookup getUsernameLookup() throws IOException {
        NameLookup lookup;
        try {
            lookup = this.plugin.getUsernameClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to obtain username", e);
        }
        if (!lookup.signIn(this.plugin, this.bugCollection)) {
            throw new RuntimeException("Unable to obtain username");
        }
        return lookup;
    }

    public MutableCloudTask createTask(final String name) {
        MutableCloudTask task = new MutableCloudTask(name);
        for (Cloud.CloudListener listener : this.listeners) {
            listener.taskStarted(task);
        }
        task.setDefaultListener(new Cloud.CloudTaskListener(){

            @Override
            public void taskStatusUpdated(String statusLine, double percentCompleted) {
                AbstractCloud.this.setStatusMsg(name + "... " + statusLine);
            }

            @Override
            public void taskFinished() {
                AbstractCloud.this.setStatusMsg("");
            }

            @Override
            public void taskFailed(String message) {
                AbstractCloud.this.setStatusMsg(name + "... FAILED - " + message);
            }
        });
        if (task.isUsingDefaultListener()) {
            this.setStatusMsg(name);
        }
        return task;
    }

    public void setStatusMsg(String newMsg) {
        this.statusMsg = newMsg;
        this.updatedStatus();
    }

    private static void printLeaderBoard(PrintWriter w, Multiset<String> evaluations, int maxRows, String alwaysPrint, boolean listRank, String title) {
        if (listRank) {
            w.printf("%3s %4s %s%n", "rnk", "num", title);
        } else {
            w.printf("%4s %s%n", "num", title);
        }
        AbstractCloud.printLeaderBoard2(w, evaluations, maxRows, alwaysPrint, listRank ? "%3d %4d %s%n" : "%2$4d %3$s%n", title);
    }

    protected String getCloudProperty(String propertyName) {
        return this.properties.getProperty("findbugs.cloud." + propertyName);
    }

    @Override
    public boolean supportsSourceLinks() {
        return this.sourceFileLinkPattern != null;
    }

    @Override
    @CheckForNull
    public URL getSourceLink(BugInstance b) {
        if (this.sourceFileLinkPattern == null) {
            return null;
        }
        SourceLineAnnotation src = b.getPrimarySourceLineAnnotation();
        String fileName = src.getSourcePath();
        int startLine = src.getStartLine();
        int endLine = src.getEndLine();
        Matcher m = this.sourceFileLinkPattern.matcher(fileName);
        boolean isMatch = m.matches();
        if (isMatch) {
            try {
                URL link = startLine > 0 ? new URL(String.format(this.sourceFileLinkFormatWithLine, m.group(1), startLine, startLine - 10, endLine)) : new URL(String.format(this.sourceFileLinkFormat, m.group(1)));
                return link;
            }
            catch (Exception e) {
                AnalysisContext.logError("Error generating source link for " + src, e);
            }
        }
        return null;
    }

    @Override
    public String getSourceLinkToolTip(BugInstance b) {
        return this.sourceFileLinkToolTip;
    }

    @Override
    public boolean getBugIsUnassigned(BugInstance b) {
        return true;
    }

    @Override
    public boolean getWillNotBeFixed(BugInstance b) {
        return false;
    }

    @Override
    public Set<String> getReviewers(BugInstance b) {
        HashSet<String> result = new HashSet<String>();
        for (BugDesignation d : this.getLatestDesignationFromEachUser(b)) {
            result.add(d.getUser());
        }
        return result;
    }

    @Override
    public IGuiCallback getGuiCallback() {
        return this.getBugCollection().getProject().getGuiCallback();
    }

    @Override
    public String getCloudName() {
        return this.getPlugin().getDescription();
    }

    @Override
    public boolean communicationInitiated() {
        return !this.isOnlineCloud();
    }

    public long getLocalFirstSeen(BugInstance b) {
        BugInstance.XmlProps props;
        Date propsFirstSeen;
        long firstVersion = b.getFirstVersion();
        AppVersion v = this.getBugCollection().getAppVersionFromSequenceNumber(firstVersion);
        if (v == null) {
            return this.getBugCollection().getTimestamp();
        }
        long firstSeen = v.getTimestamp();
        if (b.hasXmlProps() && (propsFirstSeen = (props = b.getXmlProps()).getFirstSeen()) != null && firstSeen > propsFirstSeen.getTime()) {
            firstSeen = propsFirstSeen.getTime();
        }
        return firstSeen;
    }

    static {
        Pattern p = null;
        if (LEADERBOARD_BLACKLIST != null) {
            try {
                p = Pattern.compile(LEADERBOARD_BLACKLIST.replace(',', '|'));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Could not load leaderboard blacklist pattern", e);
            }
        }
        LEADERBOARD_BLACKLIST_PATTERN = p;
    }
}

