/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.engine.bcel;

import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.MethodUnprofitableException;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.IMethodAnalysisEngine;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.engine.bcel.FinallyDuplicatesInfoFactory;
import edu.umd.cs.findbugs.graph.AbstractVertex;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantObject;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ARRAYLENGTH;
import org.apache.bcel.generic.CPInstruction;
import org.apache.bcel.generic.ConstantPushInstruction;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.IFNE;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.IfInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.LCMP;
import org.apache.bcel.generic.LoadInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.PushInstruction;
import org.apache.bcel.generic.Type;

public class ValueRangeAnalysisFactory
implements IMethodAnalysisEngine<ValueRangeAnalysis> {
    private static final Map<String, TypeLongRange> typeRanges = new HashMap<String, TypeLongRange>();

    @Override
    public ValueRangeAnalysis analyze(IAnalysisCache analysisCache, MethodDescriptor descriptor) throws CheckedAnalysisException {
        CFG cfg;
        XMethod xMethod = XFactory.createXMethod(descriptor);
        if (xMethod.isNative() || xMethod.isSynthetic() || xMethod.isAbstract()) {
            return null;
        }
        try {
            cfg = analysisCache.getMethodAnalysis(CFG.class, descriptor);
        }
        catch (MethodUnprofitableException e) {
            return null;
        }
        if (cfg == null) {
            return null;
        }
        ClassContext classContext = analysisCache.getClassAnalysis(ClassContext.class, descriptor.getClassDescriptor());
        Method method = analysisCache.getMethodAnalysis(Method.class, descriptor);
        Context context = new Context(cfg.getMethodGen().getConstantPool().getConstantPool(), method.getCode().getLocalVariableTable(), ValueRangeAnalysisFactory.getParameterTypes(descriptor), classContext.getValueNumberDataflow(method));
        HashMap<Iterator<Map.Entry<Edge, Branch>>, VariableData> analyzedArguments = new HashMap<Iterator<Map.Entry<Edge, Branch>>, VariableData>();
        IdentityHashMap<Edge, Branch> allEdges = new IdentityHashMap<Edge, Branch>();
        Iterator edgeIterator = cfg.edgeIterator();
        while (edgeIterator.hasNext()) {
            Iterator source;
            Condition condition;
            Edge edge = (Edge)edgeIterator.next();
            if (edge.getType() != 1 || (condition = context.extractCondition(new BackIterator(cfg, (BasicBlock)((Object)(source = (BasicBlock)edge.getSource()))))) == null) continue;
            Iterator<Map.Entry<Edge, Branch>> valueNumber = condition.value.vn;
            String varName = condition.value.name;
            VariableData data = (VariableData)analyzedArguments.get(valueNumber);
            if (data == null) {
                try {
                    data = new VariableData(condition.value.signature);
                }
                catch (IllegalArgumentException e) {
                    continue;
                }
                analyzedArguments.put(valueNumber, data);
            }
            Number number = condition.number;
            String numberStr = ValueRangeAnalysisFactory.convertNumber(data.splitSet.getSignature(), number);
            Branch branch = null;
            switch (condition.opcode) {
                case 157: 
                case 163: {
                    branch = new Branch(varName, "> " + numberStr, "<= " + numberStr, data.splitSet.gt(number.longValue()), number);
                    break;
                }
                case 158: 
                case 164: {
                    branch = new Branch(varName, "<= " + numberStr, "> " + numberStr, data.splitSet.le(number.longValue()), number);
                    break;
                }
                case 156: 
                case 162: {
                    branch = new Branch(varName, ">= " + numberStr, "< " + numberStr, data.splitSet.ge(number.longValue()), number);
                    break;
                }
                case 155: 
                case 161: {
                    branch = new Branch(varName, "< " + numberStr, ">= " + numberStr, data.splitSet.lt(number.longValue()), number);
                    break;
                }
                case 153: 
                case 159: {
                    branch = new Branch(varName, "== " + numberStr, "!= " + numberStr, data.splitSet.eq(number.longValue()), number);
                    break;
                }
                case 154: 
                case 160: {
                    branch = new Branch(varName, "!= " + numberStr, "== " + numberStr, data.splitSet.ne(number.longValue()), number);
                    break;
                }
            }
            if (branch == null) continue;
            data.addBranch(edge, branch);
            allEdges.put(edge, branch);
        }
        FinallyDuplicatesInfoFactory.FinallyDuplicatesInfo fi = null;
        ArrayList<RedundantCondition> redundantConditions = new ArrayList<RedundantCondition>();
        for (VariableData data : analyzedArguments.values()) {
            for (LongRangeSet subRange : data.splitSet) {
                BitSet reachedBlocks = new BitSet();
                ValueRangeAnalysisFactory.walkCFG(cfg, subRange, data.edges, reachedBlocks);
                data.reachableBlocks.or(reachedBlocks);
            }
        }
        for (VariableData data : analyzedArguments.values()) {
            for (Map.Entry<Edge, Branch> entry : data.edges.entrySet()) {
                BasicBlock aliveTarget;
                BasicBlock deadTarget;
                String condition;
                List<Edge> duplicates;
                Branch branch = entry.getValue();
                Edge edge = entry.getKey();
                if (!(branch.trueReachedSet.isEmpty() ^ branch.falseReachedSet.isEmpty())) continue;
                if (fi == null) {
                    fi = analysisCache.getMethodAnalysis(FinallyDuplicatesInfoFactory.FinallyDuplicatesInfo.class, descriptor);
                }
                if (!(duplicates = fi.getDuplicates(cfg, edge)).isEmpty()) {
                    boolean trueValue = !branch.trueReachedSet.isEmpty();
                    boolean falseValue = !branch.falseReachedSet.isEmpty();
                    for (Edge dup : duplicates) {
                        Branch dupBranch = (Branch)allEdges.get(dup);
                        if (dupBranch == null) continue;
                        trueValue |= !dupBranch.trueReachedSet.isEmpty();
                        falseValue |= !dupBranch.falseReachedSet.isEmpty();
                    }
                    if (trueValue && falseValue) continue;
                }
                BasicBlock trueTarget = (BasicBlock)edge.getTarget();
                BasicBlock falseTarget = cfg.getSuccessorWithEdgeType((BasicBlock)edge.getSource(), 0);
                if (branch.trueReachedSet.isEmpty()) {
                    condition = branch.varName + " " + branch.falseCondition;
                    deadTarget = trueTarget;
                    aliveTarget = falseTarget;
                } else {
                    condition = branch.varName + " " + branch.trueCondition;
                    deadTarget = falseTarget;
                    aliveTarget = trueTarget;
                }
                redundantConditions.add(new RedundantCondition(Location.getLastLocation((BasicBlock)edge.getSource()), condition, !data.reachableBlocks.get(deadTarget.getLabel()), ValueRangeAnalysisFactory.getLocation(deadTarget), ValueRangeAnalysisFactory.getLocation(aliveTarget), branch.trueSet.getSignature(), branch.trueSet.isEmpty() || branch.trueSet.isFull(), branch.number, branch.numbers.contains(branch.number.longValue())));
            }
        }
        if (!redundantConditions.isEmpty()) {
            BitSet assertionBlocks = new BitSet();
            MethodGen methodGen = cfg.getMethodGen();
            for (InstructionHandle ih : methodGen.getInstructionList()) {
                GETSTATIC getStatic;
                Instruction next;
                if (!(ih.getInstruction() instanceof GETSTATIC) || !((next = ih.getNext().getInstruction()) instanceof IFNE) || !"$assertionsDisabled".equals((getStatic = (GETSTATIC)ih.getInstruction()).getFieldName(methodGen.getConstantPool())) || !"Z".equals(getStatic.getSignature(methodGen.getConstantPool()))) continue;
                int end = ((IFNE)next).getTarget().getPosition();
                assertionBlocks.set(ih.getNext().getPosition(), end);
            }
            if (!assertionBlocks.isEmpty()) {
                ArrayList<RedundantCondition> filtered = new ArrayList<RedundantCondition>();
                for (RedundantCondition condition : redundantConditions) {
                    if (assertionBlocks.get(condition.getLocation().getHandle().getPosition())) continue;
                    filtered.add(condition);
                }
                redundantConditions = filtered;
            }
            Collections.sort(redundantConditions, new Comparator<RedundantCondition>(){

                @Override
                public int compare(RedundantCondition o1, RedundantCondition o2) {
                    return o1.location.compareTo(o2.location);
                }
            });
            return new ValueRangeAnalysis(redundantConditions);
        }
        return null;
    }

    private static Location getLocation(BasicBlock block) {
        InstructionHandle handle = block.getFirstInstruction();
        if (handle == null) {
            handle = block.getExceptionThrower();
        }
        return handle == null ? null : new Location(handle, block);
    }

    private static String convertNumber(String signature, Number number) {
        long val = number.longValue();
        switch (signature) {
            case "Z": {
                if (val == 0L) {
                    return "false";
                }
                return "true";
            }
            case "C": {
                if (val == 10L) {
                    return "'\\n'";
                }
                if (val == 13L) {
                    return "'\\r'";
                }
                if (val == 8L) {
                    return "'\\b'";
                }
                if (val == 9L) {
                    return "'\\t'";
                }
                if (val == 39L) {
                    return "'\\''";
                }
                if (val == 92L) {
                    return "'\\\\'";
                }
                if (val >= 32L && val < 128L) {
                    return "'" + (char)val + "'";
                }
                return ValueRangeAnalysisFactory.convertNumber(val);
            }
            case "I": {
                if (val >= 32L && val < 128L) {
                    return val + " ('" + (char)val + "')";
                }
                return ValueRangeAnalysisFactory.convertNumber(val);
            }
        }
        return ValueRangeAnalysisFactory.convertNumber(val);
    }

    private static String convertNumber(long val) {
        if (val == Long.MIN_VALUE) {
            return "Long.MIN_VALUE";
        }
        if (val == Long.MAX_VALUE) {
            return "Long.MAX_VALUE";
        }
        String suffix = "";
        if (val > Integer.MAX_VALUE || val < Integer.MIN_VALUE) {
            suffix = "L";
        }
        if (val > 128L) {
            return val + suffix + " (0x" + Long.toHexString(val) + suffix + ")";
        }
        return val + suffix;
    }

    private static Map<Integer, Value> getParameterTypes(MethodDescriptor descriptor) {
        Type[] argumentTypes = Type.getArgumentTypes(descriptor.getSignature());
        int j = 0;
        HashMap<Integer, Value> result = new HashMap<Integer, Value>();
        if (!descriptor.isStatic()) {
            result.put(j++, new Value("this", null, "L" + descriptor.getSlashedClassName() + ";"));
        }
        for (int i = 0; i < argumentTypes.length; ++i) {
            result.put(j, new Value("arg" + i, null, argumentTypes[i].getSignature()));
            j += argumentTypes[i].getSize();
        }
        return result;
    }

    private static void walkCFG(CFG cfg, LongRangeSet subRange, Map<Edge, Branch> edges, BitSet reachedBlocks) {
        ArrayDeque<WalkState> walkStates = new ArrayDeque<WalkState>();
        class WalkState {
            Set<Long> numbers;
            BasicBlock target;
            final /* synthetic */ BitSet val$reachedBlocks;

            WalkState(Set<Long> target, BasicBlock basicBlock) {
                this.val$reachedBlocks = basicBlock;
                this.val$reachedBlocks.set(((AbstractVertex)((Object)target)).getLabel());
                this.target = target;
                this.numbers = numbers;
            }
        }
        walkStates.push(new WalkState(new HashSet(), cfg.getEntry(), reachedBlocks));
        block0: while (!walkStates.isEmpty()) {
            WalkState walkState = (WalkState)walkStates.removeLast();
            Set<Long> numbers = walkState.numbers;
            Iterator iterator = cfg.outgoingEdgeIterator(walkState.target);
            while (iterator.hasNext()) {
                BasicBlock target;
                Edge edge = (Edge)iterator.next();
                Branch branch = edges.get(edge);
                if (branch != null) {
                    branch.numbers.addAll(numbers);
                    numbers = new HashSet<Long>(numbers);
                    numbers.add(branch.number.longValue());
                    if (branch.trueSet.intersects(subRange)) {
                        branch.trueReachedSet.add(subRange);
                    } else {
                        branch.falseReachedSet.add(subRange);
                        continue;
                    }
                }
                if (!reachedBlocks.get((target = (BasicBlock)edge.getTarget()).getLabel())) {
                    walkStates.push(new WalkState(numbers, target, reachedBlocks));
                }
                if (branch == null) continue;
                continue block0;
            }
        }
    }

    @Override
    public void registerWith(IAnalysisCache analysisCache) {
        analysisCache.registerMethodAnalysisEngine(ValueRangeAnalysis.class, this);
    }

    static {
        typeRanges.put("Z", new TypeLongRange(0L, 1L, "Z"));
        typeRanges.put("B", new TypeLongRange(-128L, 127L, "B"));
        typeRanges.put("S", new TypeLongRange(-32768L, 32767L, "S"));
        typeRanges.put("I", new TypeLongRange(Integer.MIN_VALUE, Integer.MAX_VALUE, "I"));
        typeRanges.put("J", new TypeLongRange(Long.MIN_VALUE, Long.MAX_VALUE, "J"));
        typeRanges.put("C", new TypeLongRange(0L, 65535L, "C"));
    }

    private static class BackIterator
    implements Iterator<InstructionHandle> {
        private BasicBlock block;
        private InstructionHandle next;
        private final CFG cfg;

        public BackIterator(CFG cfg, BasicBlock block) {
            this.block = block;
            this.cfg = cfg;
            this.next = block.getLastInstruction();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public InstructionHandle next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            InstructionHandle result = this.next;
            if (result == this.block.getFirstInstruction()) {
                Iterator edgeIterator;
                while ((edgeIterator = this.cfg.incomingEdgeIterator(this.block)).hasNext()) {
                    Edge edge = (Edge)edgeIterator.next();
                    if (edgeIterator.hasNext() || edge.getType() != 0) break;
                    this.block = (BasicBlock)edge.getSource();
                    if (this.block.isExceptionThrower()) continue;
                }
            }
            this.next = this.block.isExceptionThrower() || result == this.block.getFirstInstruction() ? null : this.next.getPrev();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class ValueRangeAnalysis {
        private List<RedundantCondition> redundantConditions = new ArrayList<RedundantCondition>();

        public ValueRangeAnalysis(List<RedundantCondition> redundantConditions) {
            this.redundantConditions = redundantConditions;
        }

        public RedundantCondition[] getRedundantConditions() {
            return this.redundantConditions.toArray(new RedundantCondition[this.redundantConditions.size()]);
        }
    }

    public static class RedundantCondition {
        private final Location location;
        private final String trueCondition;
        private final String signature;
        private final boolean byType;
        private final boolean hasDeadCode;
        private final boolean border;
        private final Location deadCodeLocation;
        private final Location liveCodeLocation;
        private final Number number;

        public RedundantCondition(Location location, String trueCondition, boolean hasDeadCode, Location deadCodeLocation, Location liveCodeLocation, String signature, boolean byType, Number number, boolean border) {
            this.location = location;
            this.trueCondition = trueCondition;
            this.hasDeadCode = hasDeadCode;
            this.deadCodeLocation = deadCodeLocation;
            this.liveCodeLocation = liveCodeLocation;
            this.signature = signature;
            this.byType = byType;
            this.number = number;
            this.border = border;
        }

        public boolean isBorder() {
            return this.border;
        }

        public Location getLocation() {
            return this.location;
        }

        public String getTrueCondition() {
            return this.trueCondition;
        }

        public boolean isDeadCodeUnreachable() {
            return this.hasDeadCode;
        }

        public String getSignature() {
            return this.signature;
        }

        public boolean isByType() {
            return this.byType;
        }

        public Location getLiveCodeLocation() {
            return this.liveCodeLocation;
        }

        public Location getDeadCodeLocation() {
            return this.deadCodeLocation;
        }

        public Number getNumber() {
            return this.number;
        }
    }

    private static class VariableData {
        final LongRangeSet splitSet;
        final Map<Edge, Branch> edges = new IdentityHashMap<Edge, Branch>();
        final BitSet reachableBlocks = new BitSet();

        public VariableData(String type) {
            this.splitSet = new LongRangeSet(type);
        }

        public void addBranch(Edge edge, Branch branch) {
            this.edges.put(edge, branch);
        }
    }

    private static class Context {
        final ConstantPool cp;
        final LocalVariableTable lvTable;
        final Map<Integer, Value> types;
        final ValueNumberDataflow vnaDataflow;

        public Context(ConstantPool cp, LocalVariableTable lvTable, Map<Integer, Value> types, ValueNumberDataflow vnaDataflow) {
            this.cp = cp;
            this.lvTable = lvTable;
            this.types = types;
            this.vnaDataflow = vnaDataflow;
        }

        public Condition extractCondition(BackIterator iterator) throws DataflowAnalysisException {
            Instruction comparisonInstruction = iterator.next().getInstruction();
            if (!(comparisonInstruction instanceof IfInstruction)) {
                return null;
            }
            short cmpOpcode = comparisonInstruction.getOpcode();
            int nargs = ((IfInstruction)comparisonInstruction).consumeStack(null);
            if (nargs == 2) {
                return this.extractTwoArgCondition(iterator, cmpOpcode, "I");
            }
            if (nargs == 1) {
                Object val = this.extractValue(iterator, "I");
                if (val instanceof Value) {
                    return new Condition(cmpOpcode, (Value)val, 0);
                }
                if (val instanceof LCMP) {
                    return this.extractTwoArgCondition(iterator, cmpOpcode, "J");
                }
            }
            return null;
        }

        private Object extractValue(BackIterator iterator, String defSignature) throws DataflowAnalysisException {
            if (!iterator.hasNext()) {
                return null;
            }
            BasicBlock block = iterator.block;
            InstructionHandle ih = iterator.next();
            Instruction inst = ih.getInstruction();
            if (inst instanceof ConstantPushInstruction) {
                return ((ConstantPushInstruction)((Object)inst)).getValue();
            }
            if (inst instanceof CPInstruction && inst instanceof PushInstruction) {
                Object value;
                Constant constant = this.cp.getConstant(((CPInstruction)inst).getIndex());
                if (constant instanceof ConstantObject && (value = ((ConstantObject)((Object)constant)).getConstantValue(this.cp)) instanceof Number) {
                    return value;
                }
                return inst;
            }
            if (inst instanceof ARRAYLENGTH) {
                Object valueObj = this.extractValue(iterator, defSignature);
                if (valueObj instanceof Value) {
                    Value value = (Value)valueObj;
                    return new Value(value.name + ".length", value.vn, "I");
                }
                return null;
            }
            if (inst instanceof GETFIELD) {
                Object valueObj = this.extractValue(iterator, defSignature);
                if (valueObj instanceof Value) {
                    Value value = (Value)valueObj;
                    ConstantCP desc = (ConstantCP)this.cp.getConstant(((GETFIELD)inst).getIndex());
                    ConstantNameAndType nameAndType = (ConstantNameAndType)this.cp.getConstant(desc.getNameAndTypeIndex());
                    String name = ((ConstantUtf8)this.cp.getConstant(nameAndType.getNameIndex())).getBytes();
                    String signature = ((ConstantUtf8)this.cp.getConstant(nameAndType.getSignatureIndex())).getBytes();
                    return new Value(value.name + "." + name, (ValueNumber)((ValueNumberFrame)this.vnaDataflow.getFactAfterLocation(new Location(ih, block))).getStackValue(0), signature);
                }
                return null;
            }
            if (inst instanceof INVOKEVIRTUAL) {
                Object valueObj;
                ConstantCP desc = (ConstantCP)this.cp.getConstant(((INVOKEVIRTUAL)inst).getIndex());
                ConstantNameAndType nameAndType = (ConstantNameAndType)this.cp.getConstant(desc.getNameAndTypeIndex());
                String className = this.cp.getConstantString(desc.getClassIndex(), (byte)7);
                String name = ((ConstantUtf8)this.cp.getConstant(nameAndType.getNameIndex())).getBytes();
                String signature = ((ConstantUtf8)this.cp.getConstant(nameAndType.getSignatureIndex())).getBytes();
                if ((className.equals("java/lang/Integer") && name.equals("intValue") && signature.equals("()I") || className.equals("java/lang/Long") && name.equals("longValue") && signature.equals("()J") || className.equals("java/lang/Short") && name.equals("shortValue") && signature.equals("()S") || className.equals("java/lang/Byte") && name.equals("byteValue") && signature.equals("()B") || className.equals("java/lang/Boolean") && name.equals("booleanValue") && signature.equals("()Z") || className.equals("java/lang/Character") && name.equals("charValue") && signature.equals("()C")) && (valueObj = this.extractValue(iterator, defSignature)) instanceof Value) {
                    Value value = (Value)valueObj;
                    return new Value(value.name, value.vn, String.valueOf(signature.charAt(signature.length() - 1)));
                }
                if (className.equals("java/lang/String") && name.equals("length") && signature.equals("()I") && (valueObj = this.extractValue(iterator, defSignature)) instanceof Value) {
                    Value value = (Value)valueObj;
                    return new Value(value.name + ".length()", value.vn, "I");
                }
                return null;
            }
            if (inst instanceof LoadInstruction) {
                String signature;
                String name;
                LocalVariable lv;
                int index = ((LoadInstruction)inst).getIndex();
                LocalVariable localVariable = lv = this.lvTable == null ? null : this.lvTable.getLocalVariable(index, ih.getPosition());
                if (lv == null) {
                    name = "local$" + index;
                    if (this.types.containsKey(index)) {
                        signature = this.types.get((Object)Integer.valueOf((int)index)).signature;
                        name = this.types.get((Object)Integer.valueOf((int)index)).name;
                    } else {
                        signature = defSignature;
                    }
                } else {
                    name = lv.getName();
                    signature = lv.getSignature();
                }
                return new Value(name, (ValueNumber)((ValueNumberFrame)this.vnaDataflow.getFactAfterLocation(new Location(ih, block))).getStackValue(0), signature);
            }
            return inst;
        }

        private static short revertOpcode(short opcode) {
            switch (opcode) {
                case 162: {
                    return 164;
                }
                case 163: {
                    return 161;
                }
                case 164: {
                    return 162;
                }
                case 161: {
                    return 163;
                }
                case 158: {
                    return 156;
                }
                case 156: {
                    return 158;
                }
                case 157: {
                    return 155;
                }
                case 155: {
                    return 157;
                }
            }
            return opcode;
        }

        private Condition extractTwoArgCondition(BackIterator iterator, short cmpOpcode, String signature) throws DataflowAnalysisException {
            Object val2 = this.extractValue(iterator, signature);
            if (val2 instanceof Instruction) {
                return null;
            }
            Object val1 = this.extractValue(iterator, signature);
            if (val1 instanceof Instruction) {
                return null;
            }
            if (!(val1 instanceof Value) && !(val2 instanceof Value)) {
                return null;
            }
            if (!(val1 instanceof Value)) {
                Object tmp = val1;
                val1 = val2;
                val2 = tmp;
                cmpOpcode = Context.revertOpcode(cmpOpcode);
            }
            if (!(val2 instanceof Number)) {
                return null;
            }
            return new Condition(cmpOpcode, (Value)val1, (Number)val2);
        }
    }

    private static class Condition {
        short opcode;
        Value value;
        Number number;

        public Condition(short opcode, Value value, Number number) {
            this.opcode = opcode;
            this.value = value;
            this.number = number;
        }
    }

    private static class Value {
        final String name;
        final ValueNumber vn;
        final String signature;

        public Value(String name, @Nullable ValueNumber vn, String signature) {
            this.name = name;
            this.vn = vn;
            this.signature = signature;
        }
    }

    private static class Branch {
        final LongRangeSet trueSet;
        final LongRangeSet trueReachedSet;
        final LongRangeSet falseReachedSet;
        final String trueCondition;
        final String falseCondition;
        final Number number;
        final Set<Long> numbers = new HashSet<Long>();
        final String varName;

        public Branch(String varName, String trueCondition, String falseCondition, LongRangeSet trueSet, Number number) {
            this.trueSet = trueSet;
            this.trueCondition = this.fixCondition(trueCondition);
            this.falseCondition = this.fixCondition(falseCondition);
            this.trueReachedSet = trueSet.empty();
            this.falseReachedSet = trueSet.empty();
            trueSet.addBordersTo(this.numbers);
            this.number = number;
            this.varName = varName;
        }

        private String fixCondition(String condition) {
            if (condition.equals("!= true")) {
                return "== false";
            }
            if (condition.equals("!= false")) {
                return "== true";
            }
            return condition;
        }
    }

    public static class LongRangeSet
    implements Iterable<LongRangeSet> {
        private final SortedMap<Long, Long> map = new TreeMap<Long, Long>();
        private final TypeLongRange range;

        public LongRangeSet(String type) {
            TypeLongRange range = (TypeLongRange)typeRanges.get(type);
            if (range == null) {
                throw new IllegalArgumentException("Type is not supported: " + type);
            }
            this.map.put(range.min, range.max);
            this.range = range;
        }

        private LongRangeSet(TypeLongRange range, long from, long to) {
            this.range = range;
            if (from < range.min) {
                from = range.min;
            }
            if (to > range.max) {
                to = range.max;
            }
            if (from <= to) {
                this.map.put(from, to);
            }
        }

        private LongRangeSet(TypeLongRange range) {
            this.range = range;
        }

        public LongRangeSet gt(long value) {
            this.splitGreater(value);
            if (value == Long.MAX_VALUE) {
                return new LongRangeSet(this.range);
            }
            return new LongRangeSet(this.range, value + 1L, this.range.max);
        }

        public LongRangeSet ge(long value) {
            this.splitGreater(value - 1L);
            return new LongRangeSet(this.range, value, this.range.max);
        }

        public LongRangeSet lt(long value) {
            this.splitGreater(value - 1L);
            if (value == Long.MIN_VALUE) {
                return new LongRangeSet(this.range);
            }
            return new LongRangeSet(this.range, this.range.min, value - 1L);
        }

        public LongRangeSet le(long value) {
            this.splitGreater(value);
            return new LongRangeSet(this.range, this.range.min, value);
        }

        public LongRangeSet eq(long value) {
            this.splitGreater(value);
            this.splitGreater(value - 1L);
            return new LongRangeSet(this.range, value, value);
        }

        public LongRangeSet ne(long value) {
            this.splitGreater(value);
            this.splitGreater(value - 1L);
            LongRangeSet rangeSet = this.lt(value);
            if (value < this.range.max) {
                rangeSet.map.put(value + 1L, this.range.max);
            }
            return rangeSet;
        }

        public void addBordersTo(Set<Long> borders) {
            this.range.addBordersTo(borders);
        }

        public LongRangeSet empty() {
            return new LongRangeSet(this.range);
        }

        public boolean intersects(LongRangeSet other) {
            for (Map.Entry<Long, Long> entry : this.map.entrySet()) {
                SortedMap<Long, Long> subMap;
                SortedMap<Long, Long> sortedMap = subMap = entry.getValue() == Long.MAX_VALUE ? other.map.tailMap(entry.getKey()) : other.map.subMap(entry.getKey(), entry.getValue() + 1L);
                if (!subMap.isEmpty()) {
                    return true;
                }
                SortedMap<Long, Long> headMap = other.map.headMap(entry.getKey());
                if (headMap.isEmpty() || (Long)headMap.get(headMap.lastKey()) < entry.getKey()) continue;
                return true;
            }
            return false;
        }

        public void splitGreater(long number) {
            Long lNumber = number;
            if (number == Long.MAX_VALUE) {
                return;
            }
            Long nextNumber = number + 1L;
            SortedMap<Long, Long> headMap = this.map.headMap(nextNumber);
            if (headMap.isEmpty()) {
                return;
            }
            Long lastKey = headMap.lastKey();
            Long lastValue = (Long)headMap.get(lastKey);
            if (number >= lastValue) {
                return;
            }
            this.map.put(lastKey, lNumber);
            this.map.put(nextNumber, lastValue);
        }

        public String getSignature() {
            return this.range.signature;
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public boolean isFull() {
            if (this.map.size() != 1) {
                return false;
            }
            Long min = this.map.firstKey();
            Long max = (Long)this.map.get(min);
            return min <= this.range.min && max >= this.range.max;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<Long, Long> entry : this.map.entrySet()) {
                if (sb.length() > 0) {
                    sb.append("+");
                }
                if (entry.getKey().equals(entry.getValue())) {
                    sb.append("{").append(entry.getKey()).append("}");
                    continue;
                }
                sb.append("[").append(entry.getKey()).append(", ").append(entry.getValue()).append("]");
            }
            return sb.toString();
        }

        @Override
        public Iterator<LongRangeSet> iterator() {
            final Iterator<Map.Entry<Long, Long>> iterator = this.map.entrySet().iterator();
            return new Iterator<LongRangeSet>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public LongRangeSet next() {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    return new LongRangeSet(range, (Long)entry.getKey(), (Long)entry.getValue());
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        private void add(Long start, Long end) {
            Long headStart;
            Long headEnd;
            SortedMap<Long, Long> headMap;
            if (end < Long.MAX_VALUE) {
                headMap = this.map.headMap(end + 1L);
                Long tailEnd = (Long)this.map.remove(end + 1L);
                if (tailEnd != null) {
                    end = tailEnd;
                }
                if (!headMap.isEmpty() && (tailEnd = (Long)headMap.get(headMap.lastKey())) > end) {
                    end = tailEnd;
                }
            }
            if (!(headMap = this.map.headMap(start)).isEmpty() && (headEnd = (Long)this.map.get(headStart = headMap.lastKey())) >= start - 1L) {
                this.map.remove(headStart);
                start = headStart;
            }
            this.map.subMap(start, end).clear();
            this.map.remove(end);
            this.map.put(start, end);
        }

        public LongRangeSet add(LongRangeSet rangeSet) {
            for (Map.Entry<Long, Long> entry : rangeSet.map.entrySet()) {
                this.add(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public boolean same(LongRangeSet rangeSet) {
            return this.map.equals(rangeSet.map);
        }
    }

    private static class TypeLongRange {
        long min;
        long max;
        String signature;

        public TypeLongRange(long min, long max, String signature) {
            this.min = min;
            this.max = max;
            this.signature = signature;
        }

        public void addBordersTo(Set<Long> borders) {
            borders.add(this.min);
            if (this.min > Long.MIN_VALUE) {
                borders.add(this.min - 1L);
            }
            borders.add(this.max);
            if (this.max < Long.MAX_VALUE) {
                borders.add(this.max + 1L);
            }
        }
    }
}

