/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile;

import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.IClassAnalysisEngine;
import edu.umd.cs.findbugs.classfile.IClassPath;
import edu.umd.cs.findbugs.classfile.IDatabaseFactory;
import edu.umd.cs.findbugs.classfile.IErrorLogger;
import edu.umd.cs.findbugs.classfile.IMethodAnalysisEngine;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.log.Profiler;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public interface IAnalysisCache {
    public <E> void registerClassAnalysisEngine(Class<E> var1, IClassAnalysisEngine<E> var2);

    public <E> void registerMethodAnalysisEngine(Class<E> var1, IMethodAnalysisEngine<E> var2);

    public <E> E getClassAnalysis(Class<E> var1, @Nonnull ClassDescriptor var2) throws CheckedAnalysisException;

    public <E> E probeClassAnalysis(Class<E> var1, @Nonnull ClassDescriptor var2);

    public <E> E getMethodAnalysis(Class<E> var1, @Nonnull MethodDescriptor var2) throws CheckedAnalysisException;

    public <E> void eagerlyPutMethodAnalysis(Class<E> var1, @Nonnull MethodDescriptor var2, E var3);

    public void purgeMethodAnalyses(@Nonnull MethodDescriptor var1);

    public void purgeAllMethodAnalysis();

    public void purgeClassAnalysis(Class<?> var1);

    public <E> void registerDatabaseFactory(Class<E> var1, IDatabaseFactory<E> var2);

    public <E> E getDatabase(Class<E> var1);

    @CheckForNull
    public <E> E getOptionalDatabase(Class<E> var1);

    public <E> void eagerlyPutDatabase(Class<E> var1, E var2);

    public IClassPath getClassPath();

    public IErrorLogger getErrorLogger();

    public Map<?, ?> getAnalysisLocals();

    public Profiler getProfiler();
}

