/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.jsr305;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.MissingClassException;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.jsr305.ValidationSecurityManager;
import edu.umd.cs.findbugs.ba.jsr305.ValidatorClassLoader;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.analysis.ClassData;
import edu.umd.cs.findbugs.log.Profiler;
import edu.umd.cs.findbugs.util.DualKeyHashMap;
import edu.umd.cs.findbugs.util.Util;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.meta.Exclusive;
import javax.annotation.meta.Exhaustive;
import javax.annotation.meta.TypeQualifierValidator;
import javax.annotation.meta.When;

public class TypeQualifierValue<A extends Annotation> {
    public static final boolean DEBUG = SystemProperties.getBoolean("tqv.debug");
    public static final boolean DEBUG_CLASSLOADING = SystemProperties.getBoolean("tqv.debug.classloading");
    private static final ClassDescriptor EXCLUSIVE_ANNOTATION = DescriptorFactory.instance().getClassDescriptor(Exclusive.class);
    private static final ClassDescriptor EXHAUSTIVE_ANNOTATION = DescriptorFactory.instance().getClassDescriptor(Exhaustive.class);
    public final ClassDescriptor typeQualifier;
    public final Class<A> typeQualifierClass;
    public final A proxy;
    @CheckForNull
    public final Object value;
    private final boolean isStrict;
    private final boolean isExclusive;
    private final boolean isExhaustive;
    @CheckForNull
    private final TypeQualifierValidator<A> validator;
    private static ThreadLocal<Data> instance = new ThreadLocal<Data>(){

        @Override
        protected Data initialValue() {
            return new Data();
        }
    };

    private TypeQualifierValue(ClassDescriptor typeQualifier, @CheckForNull Object value) {
        this.typeQualifier = typeQualifier;
        this.value = value;
        boolean isStrict1 = false;
        boolean isExclusive1 = false;
        boolean isExhaustive1 = false;
        TypeQualifierValidator<A> validator1 = null;
        Class<A> qualifierClass = null;
        XClass xclass = null;
        Annotation proxy1 = null;
        try {
            xclass = Global.getAnalysisCache().getClassAnalysis(XClass.class, typeQualifier);
            XMethod whenMethod = xclass.findMethod("when", "()Ljavax/annotation/meta/When;", false);
            if (whenMethod == null) {
                isStrict1 = true;
            }
            for (XMethod xMethod : xclass.getXMethods()) {
                if (!"value".equals(xMethod.getName()) || !xMethod.getSignature().startsWith("()")) continue;
                boolean bl = isExhaustive1 = xMethod.getAnnotation(EXHAUSTIVE_ANNOTATION) != null;
                isExclusive1 = isExhaustive1 ? true : xMethod.getAnnotation(EXCLUSIVE_ANNOTATION) != null;
                break;
            }
        }
        catch (MissingClassException e) {
            AnalysisContext.currentAnalysisContext().getLookupFailureCallback().reportMissingClass(e.getClassNotFoundException());
        }
        catch (CheckedAnalysisException e) {
            AnalysisContext.logError("Error looking up annotation class " + typeQualifier.toDottedClassName(), e);
        }
        this.isStrict = isStrict1;
        this.isExclusive = isExclusive1;
        this.isExhaustive = isExhaustive1;
        if (xclass != null) {
            SecurityManager m;
            ClassDescriptor checkerName = DescriptorFactory.createClassDescriptor(typeQualifier.getClassName() + "$Checker");
            if (!SystemProperties.RUNNING_IN_ECLIPSE) {
                try {
                    Class<?> clazz;
                    Global.getAnalysisCache().getClassAnalysis(ClassData.class, checkerName);
                    SecurityManager m2 = System.getSecurityManager();
                    if (m2 == null) {
                        if (DEBUG_CLASSLOADING) {
                            System.out.println("Setting ValidationSecurityManager");
                        }
                        System.setSecurityManager(ValidationSecurityManager.INSTANCE);
                    }
                    if (TypeQualifierValidator.class.isAssignableFrom(clazz = ValidatorClassLoader.INSTANCE.loadClass(checkerName.getDottedClassName()))) {
                        Class<TypeQualifierValidator> validatorClass = clazz.asSubclass(TypeQualifierValidator.class);
                        validator1 = TypeQualifierValue.getValidator(validatorClass);
                        qualifierClass = TypeQualifierValue.getQualifierClass(typeQualifier);
                        InvocationHandler handler = new InvocationHandler(){

                            @Override
                            public Object invoke(Object arg0, Method arg1, Object[] arg2) throws Throwable {
                                if ("value".equals(arg1.getName())) {
                                    return TypeQualifierValue.this.value;
                                }
                                throw new UnsupportedOperationException("Can't handle " + arg1);
                            }
                        };
                        proxy1 = (Annotation)qualifierClass.cast(Proxy.newProxyInstance(ValidatorClassLoader.INSTANCE, new Class[]{qualifierClass}, handler));
                    }
                }
                catch (ClassNotFoundException m2) {
                }
                catch (CheckedAnalysisException m2) {
                }
                catch (Exception e) {
                    AnalysisContext.logError("Unable to construct type qualifier checker " + checkerName, e);
                }
                catch (Throwable e) {
                    AnalysisContext.logError("Unable to construct type qualifier checker " + checkerName + " due to " + e.getClass().getSimpleName() + ":" + e.getMessage());
                }
            } else if (DEBUG_CLASSLOADING && (m = System.getSecurityManager()) == null) {
                if (DEBUG_CLASSLOADING) {
                    System.out.println("Setting ValidationSecurityManager");
                }
                System.setSecurityManager(ValidationSecurityManager.INSTANCE);
            }
        }
        this.validator = validator1;
        this.typeQualifierClass = qualifierClass;
        this.proxy = proxy1;
    }

    private static <A extends Annotation> TypeQualifierValidator<A> getValidator(Class<? extends TypeQualifierValidator<A>> checkerClass) throws InstantiationException, IllegalAccessException {
        return checkerClass.newInstance();
    }

    private static <A> Class<A> getQualifierClass(ClassDescriptor typeQualifier) throws ClassNotFoundException {
        String className = typeQualifier.getDottedClassName();
        if (DEBUG_CLASSLOADING) {
            System.out.println("Getting qualifier class for " + className);
        }
        if (className.startsWith("javax.annotation")) {
            return Class.forName(className);
        }
        try {
            Global.getAnalysisCache().getClassAnalysis(ClassData.class, typeQualifier);
        }
        catch (CheckedAnalysisException e) {
            throw new ClassNotFoundException("No class data found for " + className);
        }
        ValidatorClassLoader validatorLoader = ValidatorClassLoader.INSTANCE;
        return validatorLoader.loadClass(typeQualifier.getDottedClassName());
    }

    static byte[] loadClassData(String name) throws CheckedAnalysisException {
        ClassDescriptor d = DescriptorFactory.createClassDescriptorFromDottedClassName(name);
        ClassData data = Global.getAnalysisCache().getClassAnalysis(ClassData.class, d);
        return data.getData();
    }

    public static void clearInstance() {
        instance.remove();
    }

    public boolean canValidate(@CheckForNull Object constantValue) {
        return this.validator != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public When validate(@CheckForNull Object constantValue) {
        if (this.validator == null) {
            throw new IllegalStateException("No validator");
        }
        IAnalysisCache analysisCache = Global.getAnalysisCache();
        Profiler profiler = analysisCache.getProfiler();
        profiler.start(this.validator.getClass());
        try {
            When when = ValidationSecurityManager.sandboxedValidation(this.proxy, this.validator, constantValue);
            return when;
        }
        catch (Exception e) {
            AnalysisContext.logError("Error executing custom validator for " + this.typeQualifier + " " + constantValue, e);
            When when = When.UNKNOWN;
            return when;
        }
        finally {
            profiler.end(this.validator.getClass());
        }
    }

    @Nonnull
    public static TypeQualifierValue<?> getValue(ClassDescriptor desc, @CheckForNull Object value) {
        DualKeyHashMap<ClassDescriptor, Object, TypeQualifierValue<?>> map = TypeQualifierValue.instance.get().typeQualifierMap;
        TypeQualifierValue<Object> result = map.get(desc, value);
        if (result != null) {
            return result;
        }
        result = new TypeQualifierValue(desc, value);
        map.put(desc, value, result);
        TypeQualifierValue.instance.get().allKnownTypeQualifiers.add(result);
        return result;
    }

    @Nonnull
    public static <A extends Annotation> TypeQualifierValue<A> getValue(Class<A> clazz, @CheckForNull Object value) {
        return TypeQualifierValue.getValue(DescriptorFactory.createClassDescriptor(clazz), value);
    }

    public static Collection<TypeQualifierValue<?>> getAllKnownTypeQualifiers() {
        return Collections.unmodifiableSet(TypeQualifierValue.instance.get().allKnownTypeQualifiers);
    }

    public static Collection<TypeQualifierValue<?>> getComplementaryExclusiveTypeQualifierValue(TypeQualifierValue<?> tqv) {
        assert (tqv.isExclusiveQualifier());
        LinkedList result = new LinkedList();
        for (TypeQualifierValue<?> t : TypeQualifierValue.instance.get().allKnownTypeQualifiers) {
            if (!t.typeQualifier.equals(tqv.typeQualifier) || Util.nullSafeEquals(t.value, tqv.value)) continue;
            result.add(t);
        }
        return result;
    }

    public static boolean hasMultipleVariants(TypeQualifierValue<?> tqv) {
        int count = 0;
        for (TypeQualifierValue<?> t : TypeQualifierValue.instance.get().allKnownTypeQualifiers) {
            if (!t.typeQualifier.equals(tqv.typeQualifier)) continue;
            ++count;
        }
        return count > 1;
    }

    public ClassDescriptor getTypeQualifierClassDescriptor() {
        return this.typeQualifier;
    }

    public boolean isStrictQualifier() {
        return this.isStrict;
    }

    public boolean isExclusiveQualifier() {
        return this.isExclusive;
    }

    public boolean isExhaustiveQualifier() {
        return this.isExhaustive;
    }

    public int hashCode() {
        int result = this.typeQualifier.hashCode();
        if (this.value != null) {
            result += 37 * this.value.hashCode();
        }
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TypeQualifierValue)) {
            return false;
        }
        TypeQualifierValue other = (TypeQualifierValue)o;
        return this.typeQualifier.equals(other.typeQualifier) && Util.nullSafeEquals(this.value, other.value);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.typeQualifier.toString());
        if (this.value != null) {
            buf.append(':');
            buf.append(this.value.toString());
        }
        return buf.toString();
    }

    static class Data {
        DualKeyHashMap<ClassDescriptor, Object, TypeQualifierValue<?>> typeQualifierMap = new DualKeyHashMap();
        Set<TypeQualifierValue<?>> allKnownTypeQualifiers = new HashSet();

        Data() {
        }
    }
}

