/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Frame;
import edu.umd.cs.findbugs.ba.InvalidBytecodeException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.bcel.generic.NONNULL2Z;
import edu.umd.cs.findbugs.bcel.generic.NULL2Z;
import org.apache.bcel.generic.AALOAD;
import org.apache.bcel.generic.AASTORE;
import org.apache.bcel.generic.ACONST_NULL;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.ARETURN;
import org.apache.bcel.generic.ARRAYLENGTH;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.ATHROW;
import org.apache.bcel.generic.AllocationInstruction;
import org.apache.bcel.generic.ArithmeticInstruction;
import org.apache.bcel.generic.ArrayInstruction;
import org.apache.bcel.generic.BALOAD;
import org.apache.bcel.generic.BASTORE;
import org.apache.bcel.generic.BIPUSH;
import org.apache.bcel.generic.BREAKPOINT;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.CALOAD;
import org.apache.bcel.generic.CASTORE;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.CPInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ConstantPushInstruction;
import org.apache.bcel.generic.ConversionInstruction;
import org.apache.bcel.generic.D2F;
import org.apache.bcel.generic.D2I;
import org.apache.bcel.generic.D2L;
import org.apache.bcel.generic.DADD;
import org.apache.bcel.generic.DALOAD;
import org.apache.bcel.generic.DASTORE;
import org.apache.bcel.generic.DCMPG;
import org.apache.bcel.generic.DCMPL;
import org.apache.bcel.generic.DCONST;
import org.apache.bcel.generic.DDIV;
import org.apache.bcel.generic.DLOAD;
import org.apache.bcel.generic.DMUL;
import org.apache.bcel.generic.DNEG;
import org.apache.bcel.generic.DREM;
import org.apache.bcel.generic.DRETURN;
import org.apache.bcel.generic.DSTORE;
import org.apache.bcel.generic.DSUB;
import org.apache.bcel.generic.DUP;
import org.apache.bcel.generic.DUP2;
import org.apache.bcel.generic.DUP2_X1;
import org.apache.bcel.generic.DUP2_X2;
import org.apache.bcel.generic.DUP_X1;
import org.apache.bcel.generic.DUP_X2;
import org.apache.bcel.generic.ExceptionThrower;
import org.apache.bcel.generic.F2D;
import org.apache.bcel.generic.F2I;
import org.apache.bcel.generic.F2L;
import org.apache.bcel.generic.FADD;
import org.apache.bcel.generic.FALOAD;
import org.apache.bcel.generic.FASTORE;
import org.apache.bcel.generic.FCMPG;
import org.apache.bcel.generic.FCMPL;
import org.apache.bcel.generic.FCONST;
import org.apache.bcel.generic.FDIV;
import org.apache.bcel.generic.FLOAD;
import org.apache.bcel.generic.FMUL;
import org.apache.bcel.generic.FNEG;
import org.apache.bcel.generic.FREM;
import org.apache.bcel.generic.FRETURN;
import org.apache.bcel.generic.FSTORE;
import org.apache.bcel.generic.FSUB;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.FieldOrMethod;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.GOTO_W;
import org.apache.bcel.generic.GotoInstruction;
import org.apache.bcel.generic.I2B;
import org.apache.bcel.generic.I2C;
import org.apache.bcel.generic.I2D;
import org.apache.bcel.generic.I2F;
import org.apache.bcel.generic.I2L;
import org.apache.bcel.generic.I2S;
import org.apache.bcel.generic.IADD;
import org.apache.bcel.generic.IALOAD;
import org.apache.bcel.generic.IAND;
import org.apache.bcel.generic.IASTORE;
import org.apache.bcel.generic.ICONST;
import org.apache.bcel.generic.IDIV;
import org.apache.bcel.generic.IFEQ;
import org.apache.bcel.generic.IFGE;
import org.apache.bcel.generic.IFGT;
import org.apache.bcel.generic.IFLE;
import org.apache.bcel.generic.IFLT;
import org.apache.bcel.generic.IFNE;
import org.apache.bcel.generic.IFNONNULL;
import org.apache.bcel.generic.IFNULL;
import org.apache.bcel.generic.IF_ACMPEQ;
import org.apache.bcel.generic.IF_ACMPNE;
import org.apache.bcel.generic.IF_ICMPEQ;
import org.apache.bcel.generic.IF_ICMPGE;
import org.apache.bcel.generic.IF_ICMPGT;
import org.apache.bcel.generic.IF_ICMPLE;
import org.apache.bcel.generic.IF_ICMPLT;
import org.apache.bcel.generic.IF_ICMPNE;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.ILOAD;
import org.apache.bcel.generic.IMPDEP1;
import org.apache.bcel.generic.IMPDEP2;
import org.apache.bcel.generic.IMUL;
import org.apache.bcel.generic.INEG;
import org.apache.bcel.generic.INSTANCEOF;
import org.apache.bcel.generic.INVOKEDYNAMIC;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.IOR;
import org.apache.bcel.generic.IREM;
import org.apache.bcel.generic.IRETURN;
import org.apache.bcel.generic.ISHL;
import org.apache.bcel.generic.ISHR;
import org.apache.bcel.generic.ISTORE;
import org.apache.bcel.generic.ISUB;
import org.apache.bcel.generic.IUSHR;
import org.apache.bcel.generic.IXOR;
import org.apache.bcel.generic.IfInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.JSR;
import org.apache.bcel.generic.JSR_W;
import org.apache.bcel.generic.JsrInstruction;
import org.apache.bcel.generic.L2D;
import org.apache.bcel.generic.L2F;
import org.apache.bcel.generic.L2I;
import org.apache.bcel.generic.LADD;
import org.apache.bcel.generic.LALOAD;
import org.apache.bcel.generic.LAND;
import org.apache.bcel.generic.LASTORE;
import org.apache.bcel.generic.LCMP;
import org.apache.bcel.generic.LCONST;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LDC2_W;
import org.apache.bcel.generic.LDIV;
import org.apache.bcel.generic.LLOAD;
import org.apache.bcel.generic.LMUL;
import org.apache.bcel.generic.LNEG;
import org.apache.bcel.generic.LOOKUPSWITCH;
import org.apache.bcel.generic.LOR;
import org.apache.bcel.generic.LREM;
import org.apache.bcel.generic.LRETURN;
import org.apache.bcel.generic.LSHL;
import org.apache.bcel.generic.LSHR;
import org.apache.bcel.generic.LSTORE;
import org.apache.bcel.generic.LSUB;
import org.apache.bcel.generic.LUSHR;
import org.apache.bcel.generic.LXOR;
import org.apache.bcel.generic.LoadClass;
import org.apache.bcel.generic.LoadInstruction;
import org.apache.bcel.generic.LocalVariableInstruction;
import org.apache.bcel.generic.MONITORENTER;
import org.apache.bcel.generic.MONITOREXIT;
import org.apache.bcel.generic.MULTIANEWARRAY;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.NEWARRAY;
import org.apache.bcel.generic.NOP;
import org.apache.bcel.generic.POP;
import org.apache.bcel.generic.POP2;
import org.apache.bcel.generic.PUTFIELD;
import org.apache.bcel.generic.PUTSTATIC;
import org.apache.bcel.generic.PopInstruction;
import org.apache.bcel.generic.PushInstruction;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.RETURN;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.SALOAD;
import org.apache.bcel.generic.SASTORE;
import org.apache.bcel.generic.SIPUSH;
import org.apache.bcel.generic.SWAP;
import org.apache.bcel.generic.Select;
import org.apache.bcel.generic.StackConsumer;
import org.apache.bcel.generic.StackInstruction;
import org.apache.bcel.generic.StackProducer;
import org.apache.bcel.generic.StoreInstruction;
import org.apache.bcel.generic.TABLESWITCH;
import org.apache.bcel.generic.TypedInstruction;
import org.apache.bcel.generic.UnconditionalBranch;
import org.apache.bcel.generic.VariableLengthInstruction;
import org.apache.bcel.generic.Visitor;

public abstract class AbstractFrameModelingVisitor<Value, FrameType extends Frame<Value>>
implements Visitor {
    private FrameType frame = null;
    private Location location;
    protected ConstantPoolGen cpg;

    public AbstractFrameModelingVisitor(ConstantPoolGen cpg) {
        this.cpg = cpg;
    }

    public void analyzeInstruction(Instruction ins) throws DataflowAnalysisException {
        if (((Frame)this.frame).isValid()) {
            try {
                ins.accept(this);
            }
            catch (InvalidBytecodeException e) {
                String message = "Invalid bytecode: could not analyze instr. " + ins + " at frame " + this.frame;
                throw new DataflowAnalysisException(message, e);
            }
        }
    }

    public ConstantPoolGen getCPG() {
        return this.cpg;
    }

    public void setFrameAndLocation(FrameType frame, Location location) {
        this.frame = frame;
        this.location = location;
    }

    public FrameType getFrame() {
        return this.frame;
    }

    public Location getLocation() {
        return this.location;
    }

    public abstract Value getDefaultValue();

    public int getNumWordsConsumed(Instruction ins) {
        int numWordsConsumed = ins.consumeStack(this.cpg);
        if (numWordsConsumed == -2) {
            throw new InvalidBytecodeException("Unpredictable stack consumption");
        }
        return numWordsConsumed;
    }

    public int getNumWordsProduced(Instruction ins) {
        int numWordsProduced = ins.produceStack(this.cpg);
        if (numWordsProduced == -2) {
            throw new InvalidBytecodeException("Unpredictable stack productions");
        }
        return numWordsProduced;
    }

    private void illegalBytecode(Instruction ins) {
        throw new InvalidBytecodeException("Illegal bytecode: " + ins);
    }

    @Override
    public void visitStackInstruction(StackInstruction obj) {
    }

    @Override
    public void visitLocalVariableInstruction(LocalVariableInstruction obj) {
    }

    @Override
    public void visitBranchInstruction(BranchInstruction obj) {
    }

    @Override
    public void visitLoadClass(LoadClass obj) {
    }

    @Override
    public void visitFieldInstruction(FieldInstruction obj) {
    }

    @Override
    public void visitIfInstruction(IfInstruction obj) {
    }

    @Override
    public final void visitConversionInstruction(ConversionInstruction obj) {
        this.visitConversionInstruction2(obj);
        if (obj instanceof NULL2Z) {
            this.visitNULL2Z((NULL2Z)obj);
        } else if (obj instanceof NONNULL2Z) {
            this.visitNONNULL2Z((NONNULL2Z)obj);
        }
    }

    public final void visitConversionInstruction2(ConversionInstruction obj) {
    }

    @Override
    public void visitPopInstruction(PopInstruction obj) {
    }

    @Override
    public void visitJsrInstruction(JsrInstruction obj) {
    }

    @Override
    public void visitGotoInstruction(GotoInstruction obj) {
    }

    @Override
    public void visitStoreInstruction(StoreInstruction obj) {
    }

    @Override
    public void visitTypedInstruction(TypedInstruction obj) {
    }

    @Override
    public void visitSelect(Select obj) {
    }

    @Override
    public void visitUnconditionalBranch(UnconditionalBranch obj) {
    }

    @Override
    public void visitPushInstruction(PushInstruction obj) {
    }

    @Override
    public void visitArithmeticInstruction(ArithmeticInstruction obj) {
    }

    @Override
    public void visitCPInstruction(CPInstruction obj) {
    }

    @Override
    public void visitInvokeInstruction(InvokeInstruction obj) {
    }

    @Override
    public void visitArrayInstruction(ArrayInstruction obj) {
    }

    @Override
    public void visitAllocationInstruction(AllocationInstruction obj) {
    }

    @Override
    public void visitReturnInstruction(ReturnInstruction obj) {
    }

    @Override
    public void visitFieldOrMethod(FieldOrMethod obj) {
    }

    @Override
    public void visitConstantPushInstruction(ConstantPushInstruction obj) {
    }

    @Override
    public void visitExceptionThrower(ExceptionThrower obj) {
    }

    @Override
    public void visitLoadInstruction(LoadInstruction obj) {
    }

    @Override
    public void visitVariableLengthInstruction(VariableLengthInstruction obj) {
    }

    @Override
    public void visitStackProducer(StackProducer obj) {
    }

    @Override
    public void visitStackConsumer(StackConsumer obj) {
    }

    public void handleStoreInstruction(StoreInstruction obj) {
        try {
            int numConsumed = obj.consumeStack(this.cpg);
            if (numConsumed == -2) {
                throw new InvalidBytecodeException("Unpredictable stack consumption");
            }
            int index = obj.getIndex();
            while (numConsumed-- > 0) {
                Object value = ((Frame)this.frame).popValue();
                ((Frame)this.frame).setValue(index++, value);
            }
        }
        catch (DataflowAnalysisException e) {
            throw new InvalidBytecodeException(e.toString());
        }
    }

    public void handleLoadInstruction(LoadInstruction obj) {
        int numProduced = obj.produceStack(this.cpg);
        if (numProduced == -2) {
            throw new InvalidBytecodeException("Unpredictable stack production");
        }
        int index = obj.getIndex() + numProduced;
        while (numProduced-- > 0) {
            Object value = ((Frame)this.frame).getValue(--index);
            ((Frame)this.frame).pushValue(value);
        }
    }

    public void handleNormalInstruction(Instruction ins) {
        this.modelNormalInstruction(ins, this.getNumWordsConsumed(ins), this.getNumWordsProduced(ins));
    }

    public void modelNormalInstruction(Instruction ins, int numWordsConsumed, int numWordsProduced) {
        this.modelInstruction(ins, numWordsConsumed, numWordsProduced, this.getDefaultValue());
    }

    public void modelInstruction(Instruction ins, int numWordsConsumed, int numWordsProduced, Value pushValue) {
        if (((Frame)this.frame).getStackDepth() < numWordsConsumed) {
            try {
                throw new IllegalArgumentException(" asked to pop " + numWordsConsumed + " stack elements but only " + ((Frame)this.frame).getStackDepth() + " elements remain in " + this.frame + " while processing " + ins);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(" asked to pop " + numWordsConsumed + " stack elements but only " + ((Frame)this.frame).getStackDepth() + " elements remain while processing " + ins);
            }
        }
        try {
            while (numWordsConsumed-- > 0) {
                ((Frame)this.frame).popValue();
            }
        }
        catch (DataflowAnalysisException e) {
            throw new InvalidBytecodeException("Not enough values on the stack", e);
        }
        while (numWordsProduced-- > 0) {
            ((Frame)this.frame).pushValue(pushValue);
        }
    }

    @Override
    public void visitASTORE(ASTORE obj) {
        this.handleStoreInstruction(obj);
    }

    @Override
    public void visitDSTORE(DSTORE obj) {
        this.handleStoreInstruction(obj);
    }

    @Override
    public void visitFSTORE(FSTORE obj) {
        this.handleStoreInstruction(obj);
    }

    @Override
    public void visitISTORE(ISTORE obj) {
        this.handleStoreInstruction(obj);
    }

    @Override
    public void visitLSTORE(LSTORE obj) {
        this.handleStoreInstruction(obj);
    }

    @Override
    public void visitALOAD(ALOAD obj) {
        this.handleLoadInstruction(obj);
    }

    @Override
    public void visitDLOAD(DLOAD obj) {
        this.handleLoadInstruction(obj);
    }

    @Override
    public void visitFLOAD(FLOAD obj) {
        this.handleLoadInstruction(obj);
    }

    @Override
    public void visitILOAD(ILOAD obj) {
        this.handleLoadInstruction(obj);
    }

    @Override
    public void visitLLOAD(LLOAD obj) {
        this.handleLoadInstruction(obj);
    }

    @Override
    public void visitPOP(POP obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitPOP2(POP2 obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitDUP(DUP obj) {
        try {
            Object value = ((Frame)this.frame).popValue();
            ((Frame)this.frame).pushValue(value);
            ((Frame)this.frame).pushValue(value);
        }
        catch (DataflowAnalysisException e) {
            throw new InvalidBytecodeException(e.toString());
        }
    }

    @Override
    public void visitDUP_X1(DUP_X1 obj) {
        try {
            Object value1 = ((Frame)this.frame).popValue();
            Object value2 = ((Frame)this.frame).popValue();
            ((Frame)this.frame).pushValue(value1);
            ((Frame)this.frame).pushValue(value2);
            ((Frame)this.frame).pushValue(value1);
        }
        catch (DataflowAnalysisException e) {
            throw new InvalidBytecodeException(e.toString());
        }
    }

    @Override
    public void visitDUP_X2(DUP_X2 obj) {
        try {
            Object value1 = ((Frame)this.frame).popValue();
            Object value2 = ((Frame)this.frame).popValue();
            Object value3 = ((Frame)this.frame).popValue();
            ((Frame)this.frame).pushValue(value1);
            ((Frame)this.frame).pushValue(value3);
            ((Frame)this.frame).pushValue(value2);
            ((Frame)this.frame).pushValue(value1);
        }
        catch (DataflowAnalysisException e) {
            throw new InvalidBytecodeException(e.toString());
        }
    }

    @Override
    public void visitDUP2(DUP2 obj) {
        try {
            Object value1 = ((Frame)this.frame).popValue();
            Object value2 = ((Frame)this.frame).popValue();
            ((Frame)this.frame).pushValue(value2);
            ((Frame)this.frame).pushValue(value1);
            ((Frame)this.frame).pushValue(value2);
            ((Frame)this.frame).pushValue(value1);
        }
        catch (DataflowAnalysisException e) {
            throw new InvalidBytecodeException(e.toString());
        }
    }

    @Override
    public void visitDUP2_X1(DUP2_X1 obj) {
        try {
            Object value1 = ((Frame)this.frame).popValue();
            Object value2 = ((Frame)this.frame).popValue();
            Object value3 = ((Frame)this.frame).popValue();
            ((Frame)this.frame).pushValue(value2);
            ((Frame)this.frame).pushValue(value1);
            ((Frame)this.frame).pushValue(value3);
            ((Frame)this.frame).pushValue(value2);
            ((Frame)this.frame).pushValue(value1);
        }
        catch (DataflowAnalysisException e) {
            throw new InvalidBytecodeException(e.toString());
        }
    }

    @Override
    public void visitDUP2_X2(DUP2_X2 obj) {
        try {
            Object value1 = ((Frame)this.frame).popValue();
            Object value2 = ((Frame)this.frame).popValue();
            Object value3 = ((Frame)this.frame).popValue();
            Object value4 = ((Frame)this.frame).popValue();
            ((Frame)this.frame).pushValue(value2);
            ((Frame)this.frame).pushValue(value1);
            ((Frame)this.frame).pushValue(value4);
            ((Frame)this.frame).pushValue(value3);
            ((Frame)this.frame).pushValue(value2);
            ((Frame)this.frame).pushValue(value1);
        }
        catch (DataflowAnalysisException e) {
            throw new InvalidBytecodeException(e.toString());
        }
    }

    @Override
    public void visitSWAP(SWAP obj) {
        try {
            Object value1 = ((Frame)this.frame).popValue();
            Object value2 = ((Frame)this.frame).popValue();
            ((Frame)this.frame).pushValue(value1);
            ((Frame)this.frame).pushValue(value2);
        }
        catch (DataflowAnalysisException e) {
            throw new InvalidBytecodeException(e.toString());
        }
    }

    @Override
    public void visitIMPDEP1(IMPDEP1 obj) {
        this.illegalBytecode(obj);
    }

    @Override
    public void visitIMPDEP2(IMPDEP2 obj) {
        this.illegalBytecode(obj);
    }

    @Override
    public void visitBREAKPOINT(BREAKPOINT obj) {
        this.illegalBytecode(obj);
    }

    @Override
    public void visitACONST_NULL(ACONST_NULL obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitGETSTATIC(GETSTATIC obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitIF_ICMPLT(IF_ICMPLT obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitMONITOREXIT(MONITOREXIT obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitIFLT(IFLT obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitBASTORE(BASTORE obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitCHECKCAST(CHECKCAST obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitFCMPG(FCMPG obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitI2F(I2F obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitATHROW(ATHROW obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitDCMPL(DCMPL obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitARRAYLENGTH(ARRAYLENGTH obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitINVOKESTATIC(INVOKESTATIC obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitLCONST(LCONST obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitDREM(DREM obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitIFGE(IFGE obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitCALOAD(CALOAD obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitLASTORE(LASTORE obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitI2D(I2D obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitDADD(DADD obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitINVOKESPECIAL(INVOKESPECIAL obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitIAND(IAND obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitPUTFIELD(PUTFIELD obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitDCONST(DCONST obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitNEW(NEW obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitIFNULL(IFNULL obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitLSUB(LSUB obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitL2I(L2I obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitISHR(ISHR obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitTABLESWITCH(TABLESWITCH obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitIINC(IINC obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitDRETURN(DRETURN obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitDASTORE(DASTORE obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitIALOAD(IALOAD obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitDDIV(DDIV obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitIF_ICMPGE(IF_ICMPGE obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitLAND(LAND obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitIDIV(IDIV obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitLOR(LOR obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitCASTORE(CASTORE obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitFREM(FREM obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitLDC(LDC obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitBIPUSH(BIPUSH obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitF2L(F2L obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitFMUL(FMUL obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitJSR(JSR obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitFSUB(FSUB obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitSASTORE(SASTORE obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitRETURN(RETURN obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitDALOAD(DALOAD obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitSIPUSH(SIPUSH obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitDSUB(DSUB obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitL2F(L2F obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitIF_ICMPGT(IF_ICMPGT obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitF2D(F2D obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitI2L(I2L obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitIF_ACMPNE(IF_ACMPNE obj) {
        this.handleNormalInstruction(obj);
    }

    public void visitNULL2Z(NULL2Z obj) {
        this.handleNormalInstruction(obj);
    }

    public void visitNONNULL2Z(NONNULL2Z obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitI2S(I2S obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitIFEQ(IFEQ obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitIOR(IOR obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitIREM(IREM obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitIASTORE(IASTORE obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitNEWARRAY(NEWARRAY obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitINVOKEINTERFACE(INVOKEINTERFACE obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitINEG(INEG obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitLCMP(LCMP obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitJSR_W(JSR_W obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitMULTIANEWARRAY(MULTIANEWARRAY obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitSALOAD(SALOAD obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitIFNONNULL(IFNONNULL obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitDMUL(DMUL obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitIFNE(IFNE obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitIF_ICMPLE(IF_ICMPLE obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitLDC2_W(LDC2_W obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitGETFIELD(GETFIELD obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitLADD(LADD obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitNOP(NOP obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitFALOAD(FALOAD obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitINSTANCEOF(INSTANCEOF obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitIFLE(IFLE obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitLXOR(LXOR obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitLRETURN(LRETURN obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitFCONST(FCONST obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitIUSHR(IUSHR obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitBALOAD(BALOAD obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitIF_ACMPEQ(IF_ACMPEQ obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitMONITORENTER(MONITORENTER obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitLSHL(LSHL obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitDCMPG(DCMPG obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitD2L(D2L obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitL2D(L2D obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitRET(RET obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitIFGT(IFGT obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitIXOR(IXOR obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitINVOKEDYNAMIC(INVOKEDYNAMIC obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitINVOKEVIRTUAL(INVOKEVIRTUAL obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitFASTORE(FASTORE obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitIRETURN(IRETURN obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitIF_ICMPNE(IF_ICMPNE obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitLDIV(LDIV obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitPUTSTATIC(PUTSTATIC obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitAALOAD(AALOAD obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitD2I(D2I obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitIF_ICMPEQ(IF_ICMPEQ obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitAASTORE(AASTORE obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitARETURN(ARETURN obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitFNEG(FNEG obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitGOTO_W(GOTO_W obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitD2F(D2F obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitGOTO(GOTO obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitISUB(ISUB obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitF2I(F2I obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitDNEG(DNEG obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitICONST(ICONST obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitFDIV(FDIV obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitI2B(I2B obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitLNEG(LNEG obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitLREM(LREM obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitIMUL(IMUL obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitIADD(IADD obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitLSHR(LSHR obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitLOOKUPSWITCH(LOOKUPSWITCH obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitFCMPL(FCMPL obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitI2C(I2C obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitLMUL(LMUL obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitLUSHR(LUSHR obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitISHL(ISHL obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitLALOAD(LALOAD obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitANEWARRAY(ANEWARRAY obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitFRETURN(FRETURN obj) {
        this.handleNormalInstruction(obj);
    }

    @Override
    public void visitFADD(FADD obj) {
        this.handleNormalInstruction(obj);
    }
}

