/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Point2D;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.MapMarkerDot;
import org.openstreetmap.gui.jmapviewer.MemoryTileCache;
import org.openstreetmap.gui.jmapviewer.OsmFileCacheTileLoader;
import org.openstreetmap.gui.jmapviewer.OsmMercator;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.OsmTileSource;
import org.openstreetmap.gui.jmapviewer.interfaces.MapMarker;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.tools.I18n;

public class SlippyMapChooser
extends JMapViewer
implements DownloadSelection,
ComponentListener {
    private DownloadDialog iGui;
    Point iSelectionRectStart;
    Point iSelectionRectEnd;
    private SizeButton iSizeButton = new SizeButton();
    private SourceButton iSourceButton = new SourceButton();
    private Dimension iDownloadDialogDimension;
    private Dimension iScreenSize;
    private TileSource[] sources = new TileSource[]{new OsmTileSource.Mapnik(), new OsmTileSource.TilesAtHome()};
    TileLoader cachedLoader = new OsmFileCacheTileLoader(this);
    TileLoader uncachedLoader = new OsmTileLoader(this);
    JPanel slipyyMapTabPanel;
    boolean firstShown = true;

    public SlippyMapChooser() {
        this.setZoomContolsVisible(false);
        this.setMapMarkerVisible(false);
        this.setMinimumSize(new Dimension(350, 175));
        this.setFileCacheEnabled(SlippyMapChooserPlugin.ENABLE_FILE_CACHE);
        this.setMaxTilesInmemory(SlippyMapChooserPlugin.MAX_TILES_IN_MEMORY);
        this.addComponentListener(this);
    }

    public void setMaxTilesInmemory(int tiles) {
        ((MemoryTileCache)this.getTileCache()).setCacheSize(tiles);
    }

    public void setFileCacheEnabled(boolean enabled) {
        if (enabled) {
            this.setTileLoader(this.cachedLoader);
        } else {
            this.setTileLoader(this.uncachedLoader);
        }
    }

    public void addGui(DownloadDialog gui) {
        this.iGui = gui;
        this.slipyyMapTabPanel = new JPanel();
        this.slipyyMapTabPanel.setLayout(new BorderLayout());
        this.slipyyMapTabPanel.add((Component)this, "Center");
        this.slipyyMapTabPanel.add((Component)new JLabel(I18n.tr((String)"Zoom: Mousewheel or double click.   Move map: Hold right mousebutton and move mouse.   Select: Click.")), "South");
        this.iGui.tabpane.add((Component)this.slipyyMapTabPanel, I18n.tr((String)"Slippy map"));
        this.iGui.tabpane.addComponentListener(this);
        new OsmMapControl(this, this.slipyyMapTabPanel, this.iSizeButton, this.iSourceButton);
    }

    protected Point getTopLeftCoordinates() {
        return new Point(this.center.x - this.getWidth() / 2, this.center.y - this.getHeight() / 2);
    }

    public void paint(Graphics g) {
        try {
            super.paint(g);
            if (this.iSelectionRectStart != null && this.iSelectionRectEnd != null) {
                int zoomDiff = 18 - this.zoom;
                Point tlc = this.getTopLeftCoordinates();
                int x_min = (this.iSelectionRectStart.x >> zoomDiff) - tlc.x;
                int y_min = (this.iSelectionRectStart.y >> zoomDiff) - tlc.y;
                int x_max = (this.iSelectionRectEnd.x >> zoomDiff) - tlc.x;
                int y_max = (this.iSelectionRectEnd.y >> zoomDiff) - tlc.y;
                int w = x_max - x_min;
                int h = y_max - y_min;
                g.setColor(new Color(0.9f, 0.7f, 0.7f, 0.6f));
                g.fillRect(x_min, y_min, w, h);
                g.setColor(Color.BLACK);
                g.drawRect(x_min, y_min, w, h);
            }
            this.iSizeButton.paint(g);
            this.iSourceButton.paint(g);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void boundingBoxChanged(DownloadDialog gui) {
        if (gui.minlat == 0.0 && gui.minlon == 0.0 && gui.maxlat == 0.0 && gui.maxlon == 0.0) {
            return;
        }
        int y1 = OsmMercator.LatToY(gui.minlat, 18);
        int y2 = OsmMercator.LatToY(gui.maxlat, 18);
        int x1 = OsmMercator.LonToX(gui.minlon, 18);
        int x2 = OsmMercator.LonToX(gui.maxlon, 18);
        this.iSelectionRectStart = new Point(Math.min(x1, x2), Math.min(y1, y2));
        this.iSelectionRectEnd = new Point(Math.max(x1, x2), Math.max(y1, y2));
        MapMarkerDot xmin_ymin = new MapMarkerDot(gui.minlat, gui.minlon);
        MapMarkerDot xmax_ymax = new MapMarkerDot(gui.maxlat, gui.maxlon);
        Vector<MapMarker> marker = new Vector<MapMarker>(2);
        marker.add(xmin_ymin);
        marker.add(xmax_ymax);
        this.setMapMarkerList(marker);
        this.setDisplayToFitMapMarkers();
        this.zoomOut();
    }

    public void setSelection(Point aStart, Point aEnd) {
        if (aStart == null || aEnd == null) {
            return;
        }
        Point p_max = new Point(Math.max(aEnd.x, aStart.x), Math.max(aEnd.y, aStart.y));
        Point p_min = new Point(Math.min(aEnd.x, aStart.x), Math.min(aEnd.y, aStart.y));
        Point tlc = this.getTopLeftCoordinates();
        int zoomDiff = 18 - this.zoom;
        Point pEnd = new Point(p_max.x + tlc.x, p_max.y + tlc.y);
        Point pStart = new Point(p_min.x + tlc.x, p_min.y + tlc.y);
        pEnd.x <<= zoomDiff;
        pEnd.y <<= zoomDiff;
        pStart.x <<= zoomDiff;
        pStart.y <<= zoomDiff;
        this.iSelectionRectStart = pStart;
        this.iSelectionRectEnd = pEnd;
        Point2D.Double l1 = this.getPosition(p_max);
        Point2D.Double l2 = this.getPosition(p_min);
        this.iGui.minlat = Math.min(l2.x, l1.x);
        this.iGui.minlon = Math.min(l1.y, l2.y);
        this.iGui.maxlat = Math.max(l2.x, l1.x);
        this.iGui.maxlon = Math.max(l1.y, l2.y);
        this.iGui.boundingBoxChanged((DownloadSelection)this);
        this.repaint();
    }

    public void resizeSlippyMap() {
        Container co;
        Dimension currentDimension;
        if (this.iScreenSize == null) {
            Container c = this.iGui.getParent().getParent().getParent().getParent().getParent().getParent().getParent().getParent().getParent();
            this.iDownloadDialogDimension = c.getSize();
            this.iScreenSize = Toolkit.getDefaultToolkit().getScreenSize();
        }
        if ((currentDimension = (co = this.iGui.getParent().getParent().getParent().getParent().getParent().getParent().getParent().getParent().getParent()).getSize()).equals(this.iDownloadDialogDimension)) {
            int w = this.iScreenSize.width * 90 / 100;
            int h = this.iScreenSize.height * 90 / 100;
            co.setBounds((this.iScreenSize.width - w) / 2, (this.iScreenSize.height - h) / 2, w, h);
        } else {
            int w = this.iDownloadDialogDimension.width;
            int h = this.iDownloadDialogDimension.height;
            co.setBounds((this.iScreenSize.width - w) / 2, (this.iScreenSize.height - h) / 2, w, h);
        }
        this.repaint();
    }

    public void toggleMapSource(int mapSource) {
        this.tileCache = new MemoryTileCache();
        if (mapSource == 2) {
            this.setTileSource(this.sources[0]);
        } else {
            this.setTileSource(this.sources[1]);
        }
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        if (!this.equals(e.getSource()) || this.getHeight() == 0 || this.getWidth() == 0) {
            return;
        }
        this.firstShown = false;
        this.boundingBoxChanged(this.iGui);
    }
}

