/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.scaffold.inline;

import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.MethodDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.matcher.ElementMatcher;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.matcher.ElementMatchers;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.matcher.LatentMatcher;

public class InliningImplementationMatcher
implements LatentMatcher<MethodDescription> {
    private final LatentMatcher<? super MethodDescription> ignoredMethods;
    private final ElementMatcher<? super MethodDescription> predefinedMethodSignatures;

    protected InliningImplementationMatcher(LatentMatcher<? super MethodDescription> ignoredMethods, ElementMatcher<? super MethodDescription> predefinedMethodSignatures) {
        this.ignoredMethods = ignoredMethods;
        this.predefinedMethodSignatures = predefinedMethodSignatures;
    }

    protected static LatentMatcher<MethodDescription> of(LatentMatcher<? super MethodDescription> ignoredMethods, TypeDescription originalType) {
        ElementMatcher.Junction predefinedMethodSignatures = ElementMatchers.none();
        for (MethodDescription methodDescription : originalType.getDeclaredMethods()) {
            ElementMatcher.Junction signature = methodDescription.isConstructor() ? ElementMatchers.isConstructor() : ElementMatchers.named(methodDescription.getName());
            signature = signature.and(ElementMatchers.returns(methodDescription.getReturnType().asErasure()));
            signature = signature.and(ElementMatchers.takesArguments(methodDescription.getParameters().asTypeList().asErasures()));
            predefinedMethodSignatures = predefinedMethodSignatures.or(signature);
        }
        return new InliningImplementationMatcher(ignoredMethods, predefinedMethodSignatures);
    }

    @Override
    public ElementMatcher<? super MethodDescription> resolve(TypeDescription typeDescription) {
        return ElementMatchers.not(this.ignoredMethods.resolve(typeDescription)).and(ElementMatchers.isVirtual().and(ElementMatchers.not(ElementMatchers.isFinal())).or(ElementMatchers.isDeclaredBy(typeDescription))).or(ElementMatchers.isDeclaredBy(typeDescription).and(ElementMatchers.not(this.predefinedMethodSignatures)));
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.ignoredMethods.equals(((InliningImplementationMatcher)other).ignoredMethods) && this.predefinedMethodSignatures.equals(((InliningImplementationMatcher)other).predefinedMethodSignatures);
    }

    public int hashCode() {
        return 31 * this.ignoredMethods.hashCode() + this.predefinedMethodSignatures.hashCode();
    }

    public String toString() {
        return "InliningImplementationMatcher{ignoredMethods=" + this.ignoredMethods + ", predefinedMethodSignatures=" + this.predefinedMethodSignatures + '}';
    }
}

