/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.loading;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.loading.PackageDefinitionStrategy;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.utility.RandomString;

public interface ClassInjector {
    public static final ProtectionDomain DEFAULT_PROTECTION_DOMAIN = null;
    public static final boolean DEFAULT_FORBID_EXISTING = false;

    public Map<TypeDescription, Class<?>> inject(Map<? extends TypeDescription, byte[]> var1);

    public static class UsingInstrumentation
    implements ClassInjector {
        private static final String PREFIX = "jar";
        private static final String CLASS_FILE_EXTENSION = ".class";
        private final Instrumentation instrumentation;
        private final Target target;
        private final File folder;
        private final RandomString randomString;

        public static ClassInjector of(File folder, Target target, Instrumentation instrumentation) {
            return new UsingInstrumentation(folder, target, instrumentation, new RandomString());
        }

        protected UsingInstrumentation(File folder, Target target, Instrumentation instrumentation, RandomString randomString) {
            this.folder = folder;
            this.target = target;
            this.instrumentation = instrumentation;
            this.randomString = randomString;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<TypeDescription, Class<?>> inject(Map<? extends TypeDescription, byte[]> types) {
            File jarFile = new File(this.folder, String.format("%s%s.jar", PREFIX, this.randomString.nextString()));
            try {
                if (!jarFile.createNewFile()) {
                    throw new IllegalStateException("Cannot create file " + jarFile);
                }
                JarOutputStream jarOutputStream = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(jarFile)));
                try {
                    for (Map.Entry<? extends TypeDescription, byte[]> entry : types.entrySet()) {
                        jarOutputStream.putNextEntry(new JarEntry(entry.getKey().getInternalName() + CLASS_FILE_EXTENSION));
                        jarOutputStream.write(entry.getValue());
                    }
                }
                finally {
                    jarOutputStream.close();
                }
                this.target.inject(this.instrumentation, new JarFile(jarFile));
                HashMap loaded = new HashMap();
                ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                for (TypeDescription typeDescription : types.keySet()) {
                    loaded.put(typeDescription, classLoader.loadClass(typeDescription.getName()));
                }
                return loaded;
            }
            catch (IOException exception) {
                throw new IllegalStateException("Cannot write jar file to disk", exception);
            }
            catch (ClassNotFoundException exception) {
                throw new IllegalStateException("Cannot load injected class", exception);
            }
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            UsingInstrumentation that = (UsingInstrumentation)other;
            return this.folder.equals(that.folder) && this.instrumentation.equals(that.instrumentation) && this.target == that.target && this.randomString.equals(that.randomString);
        }

        public int hashCode() {
            int result = this.instrumentation.hashCode();
            result = 31 * result + this.target.hashCode();
            result = 31 * result + this.folder.hashCode();
            result = 31 * result + this.randomString.hashCode();
            return result;
        }

        public String toString() {
            return "ClassInjector.UsingInstrumentation{instrumentation=" + this.instrumentation + ", target=" + (Object)((Object)this.target) + ", folder=" + this.folder + ", randomString=" + this.randomString + '}';
        }

        public static enum Target {
            BOOTSTRAP{

                @Override
                protected void inject(Instrumentation instrumentation, JarFile jarFile) {
                    instrumentation.appendToBootstrapClassLoaderSearch(jarFile);
                }
            }
            ,
            SYSTEM{

                @Override
                protected void inject(Instrumentation instrumentation, JarFile jarFile) {
                    instrumentation.appendToSystemClassLoaderSearch(jarFile);
                }
            };


            protected abstract void inject(Instrumentation var1, JarFile var2);

            public String toString() {
                return "ClassInjector.UsingInstrumentation.Target." + this.name();
            }
        }
    }

    public static class UsingReflection
    implements ClassInjector {
        private static final int FROM_BEGINNING = 0;
        private static final Dispatcher.Initializable DISPATCHER;
        private final ClassLoader classLoader;
        private final ProtectionDomain protectionDomain;
        private final AccessControlContext accessControlContext;
        private final PackageDefinitionStrategy packageDefinitionStrategy;
        private final boolean forbidExisting;

        public UsingReflection(ClassLoader classLoader) {
            this(classLoader, DEFAULT_PROTECTION_DOMAIN, AccessController.getContext());
        }

        public UsingReflection(ClassLoader classLoader, ProtectionDomain protectionDomain, AccessControlContext accessControlContext) {
            this(classLoader, protectionDomain, accessControlContext, PackageDefinitionStrategy.Trivial.INSTANCE, false);
        }

        public UsingReflection(ClassLoader classLoader, ProtectionDomain protectionDomain, AccessControlContext accessControlContext, PackageDefinitionStrategy packageDefinitionStrategy, boolean forbidExisting) {
            if (classLoader == null) {
                throw new IllegalArgumentException("Cannot inject classes into the bootstrap class loader");
            }
            this.classLoader = classLoader;
            this.protectionDomain = protectionDomain;
            this.packageDefinitionStrategy = packageDefinitionStrategy;
            this.accessControlContext = accessControlContext;
            this.forbidExisting = forbidExisting;
        }

        public static ClassInjector ofSystemClassLoader() {
            return new UsingReflection(ClassLoader.getSystemClassLoader());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<TypeDescription, Class<?>> inject(Map<? extends TypeDescription, byte[]> types) {
            ClassLoader classLoader = this.classLoader;
            synchronized (classLoader) {
                HashMap loadedTypes = new HashMap();
                for (Map.Entry<? extends TypeDescription, byte[]> entry : types.entrySet()) {
                    String typeName = entry.getKey().getName();
                    Dispatcher dispatcher = DISPATCHER.initialize(this.accessControlContext);
                    Class<?> type = dispatcher.findClass(this.classLoader, typeName);
                    if (type == null) {
                        String packageName;
                        PackageDefinitionStrategy.Definition definition;
                        int packageIndex = typeName.lastIndexOf(46);
                        if (packageIndex != -1 && (definition = this.packageDefinitionStrategy.define(this.classLoader, packageName = typeName.substring(0, packageIndex), typeName)).isDefined()) {
                            Package definedPackage = dispatcher.getPackage(this.classLoader, packageName);
                            if (definedPackage == null) {
                                dispatcher.definePackage(this.classLoader, packageName, definition.getSpecificationTitle(), definition.getSpecificationVersion(), definition.getSpecificationVendor(), definition.getImplementationTitle(), definition.getImplementationVersion(), definition.getImplementationVendor(), definition.getSealBase());
                            } else if (!definition.isCompatibleTo(definedPackage)) {
                                throw new SecurityException("Sealing violation for package " + packageName);
                            }
                        }
                        byte[] binaryRepresentation = entry.getValue();
                        type = dispatcher.loadClass(this.classLoader, typeName, binaryRepresentation, 0, binaryRepresentation.length, this.protectionDomain);
                    } else if (this.forbidExisting) {
                        throw new IllegalStateException("Cannot inject already loaded type: " + type);
                    }
                    loadedTypes.put(entry.getKey(), type);
                }
                return loadedTypes;
            }
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            UsingReflection that = (UsingReflection)other;
            return this.accessControlContext.equals(that.accessControlContext) && this.classLoader.equals(that.classLoader) && this.forbidExisting == that.forbidExisting && this.packageDefinitionStrategy.equals(that.packageDefinitionStrategy) && !(this.protectionDomain == null ? that.protectionDomain != null : !this.protectionDomain.equals(that.protectionDomain));
        }

        public int hashCode() {
            int result = this.classLoader.hashCode();
            result = 31 * result + (this.protectionDomain != null ? this.protectionDomain.hashCode() : 0);
            result = 31 * result + (this.forbidExisting ? 1 : 0);
            result = 31 * result + this.packageDefinitionStrategy.hashCode();
            result = 31 * result + this.accessControlContext.hashCode();
            return result;
        }

        public String toString() {
            return "ClassInjector.UsingReflection{classLoader=" + this.classLoader + ", protectionDomain=" + this.protectionDomain + ", packageDefinitionStrategy=" + this.packageDefinitionStrategy + ", accessControlContext=" + this.accessControlContext + ", forbidExisting=" + this.forbidExisting + '}';
        }

        static {
            Dispatcher.Initializable dispatcher;
            try {
                dispatcher = new Dispatcher.Resolved(ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class), ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class), ClassLoader.class.getDeclaredMethod("getPackage", String.class), ClassLoader.class.getDeclaredMethod("definePackage", String.class, String.class, String.class, String.class, String.class, String.class, String.class, URL.class));
            }
            catch (RuntimeException exception) {
                throw exception;
            }
            catch (Exception exception) {
                dispatcher = new Dispatcher.Faulty(exception);
            }
            DISPATCHER = dispatcher;
        }

        protected static interface Dispatcher {
            public Class<?> findClass(ClassLoader var1, String var2);

            public Class<?> loadClass(ClassLoader var1, String var2, byte[] var3, int var4, int var5, ProtectionDomain var6);

            public Package getPackage(ClassLoader var1, String var2);

            public Package definePackage(ClassLoader var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, URL var9);

            public static class Faulty
            implements Initializable {
                private final Exception exception;

                protected Faulty(Exception exception) {
                    this.exception = exception;
                }

                @Override
                public Dispatcher initialize(AccessControlContext accessControlContext) {
                    throw new IllegalStateException("Error locating class loader API", this.exception);
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.exception.equals(((Faulty)other).exception);
                }

                public int hashCode() {
                    return this.exception.hashCode();
                }

                public String toString() {
                    return "ClassInjector.UsingReflection.Dispatcher.Faulty{exception=" + this.exception + '}';
                }
            }

            public static class Resolved
            implements Dispatcher,
            Initializable,
            PrivilegedAction<Dispatcher> {
                private final Method findLoadedClass;
                private final Method loadClass;
                private final Method getPackage;
                private final Method definePackage;

                protected Resolved(Method findLoadedClass, Method loadClass, Method getPackage, Method definePackage) {
                    this.findLoadedClass = findLoadedClass;
                    this.loadClass = loadClass;
                    this.getPackage = getPackage;
                    this.definePackage = definePackage;
                }

                @Override
                public Class<?> findClass(ClassLoader classLoader, String name) {
                    try {
                        return (Class)this.findLoadedClass.invoke((Object)classLoader, name);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Could not access java.lang.ClassLoader#findClass", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.ClassLoader#findClass", exception.getCause());
                    }
                }

                @Override
                public Class<?> loadClass(ClassLoader classLoader, String name, byte[] binaryRepresentation, int startIndex, int endIndex, ProtectionDomain protectionDomain) {
                    try {
                        return (Class)this.loadClass.invoke((Object)classLoader, name, binaryRepresentation, startIndex, endIndex, protectionDomain);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Could not access java.lang.ClassLoader#findClass", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.ClassLoader#findClass", exception.getCause());
                    }
                }

                @Override
                public Package getPackage(ClassLoader classLoader, String name) {
                    try {
                        return (Package)this.getPackage.invoke((Object)classLoader, name);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Could not access java.lang.ClassLoader#findClass", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.ClassLoader#findClass", exception.getCause());
                    }
                }

                @Override
                public Package definePackage(ClassLoader classLoader, String packageName, String specificationTitle, String specificationVersion, String specificationVendor, String implementationTitle, String implementationVersion, String implementationVendor, URL sealBase) {
                    try {
                        return (Package)this.definePackage.invoke((Object)classLoader, packageName, specificationTitle, specificationVersion, specificationVendor, implementationTitle, implementationVersion, implementationVendor, sealBase);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Could not access java.lang.ClassLoader#findClass", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.ClassLoader#findClass", exception.getCause());
                    }
                }

                @Override
                public Dispatcher initialize(AccessControlContext accessControlContext) {
                    return AccessController.doPrivileged(this, accessControlContext);
                }

                @Override
                public Dispatcher run() {
                    this.findLoadedClass.setAccessible(true);
                    this.loadClass.setAccessible(true);
                    this.getPackage.setAccessible(true);
                    this.definePackage.setAccessible(true);
                    return this;
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    Resolved resolved = (Resolved)other;
                    return this.findLoadedClass.equals(resolved.findLoadedClass) && this.loadClass.equals(resolved.loadClass) && this.getPackage.equals(resolved.getPackage) && this.definePackage.equals(resolved.definePackage);
                }

                public int hashCode() {
                    int result = this.findLoadedClass.hashCode();
                    result = 31 * result + this.loadClass.hashCode();
                    result = 31 * result + this.getPackage.hashCode();
                    result = 31 * result + this.definePackage.hashCode();
                    return result;
                }

                public String toString() {
                    return "ClassInjector.UsingReflection.Dispatcher.Resolved{findLoadedClass=" + this.findLoadedClass + ", loadClass=" + this.loadClass + ", getPackage=" + this.getPackage + ", definePackage=" + this.definePackage + '}';
                }
            }

            public static interface Initializable {
                public Dispatcher initialize(AccessControlContext var1);
            }
        }
    }
}

