/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.bytebuddy.asm;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.asm.AsmVisitorWrapper;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.annotation.AnnotationDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.MethodDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.MethodList;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.ParameterDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.ParameterList;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.ClassFileLocator;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.StackSize;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.AnnotationVisitor;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.Attribute;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.ClassReader;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.ClassVisitor;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.Label;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.MethodVisitor;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.TypePath;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.matcher.ElementMatchers;

public class Advice
implements AsmVisitorWrapper.ForDeclaredMethods.MethodVisitorWrapper {
    private final Dispatcher.Resolved.ForMethodEnter methodEnter;
    private final Dispatcher.Resolved.ForMethodExit methodExit;
    private final byte[] binaryRepresentation;

    protected Advice(Dispatcher.Resolved.ForMethodEnter methodEnter, Dispatcher.Resolved.ForMethodExit methodExit, byte[] binaryRepresentation) {
        this.methodEnter = methodEnter;
        this.methodExit = methodExit;
        this.binaryRepresentation = binaryRepresentation;
    }

    public static AsmVisitorWrapper.ForDeclaredMethods.MethodVisitorWrapper to(Class<?> type) {
        return Advice.to(type, ClassFileLocator.ForClassLoader.of(type.getClassLoader()));
    }

    public static AsmVisitorWrapper.ForDeclaredMethods.MethodVisitorWrapper to(Class<?> type, ClassFileLocator classFileLocator) {
        return Advice.to(new TypeDescription.ForLoadedType(type), classFileLocator);
    }

    public static AsmVisitorWrapper.ForDeclaredMethods.MethodVisitorWrapper to(TypeDescription typeDescription, ClassFileLocator classFileLocator) {
        try {
            Dispatcher methodEnter = Dispatcher.Inactive.INSTANCE;
            Dispatcher methodExit = Dispatcher.Inactive.INSTANCE;
            for (MethodDescription.InDefinedShape methodDescription : typeDescription.getDeclaredMethods()) {
                methodEnter = Advice.resolve(OnMethodEnter.class, methodEnter, methodDescription);
                methodExit = Advice.resolve(OnMethodExit.class, methodExit, methodDescription);
            }
            if (!methodEnter.isAlive() && !methodExit.isAlive()) {
                throw new IllegalArgumentException("No advice defined by " + typeDescription);
            }
            Dispatcher.Resolved.ForMethodEnter resolved = methodEnter.asMethodEnter();
            return new Advice(methodEnter.asMethodEnter(), methodExit.asMethodExitTo(resolved), classFileLocator.locate(typeDescription.getName()).resolve());
        }
        catch (IOException exception) {
            throw new IllegalStateException("Error reading class file of " + typeDescription, exception);
        }
    }

    private static Dispatcher resolve(Class<? extends Annotation> annotation, Dispatcher dispatcher, MethodDescription.InDefinedShape methodDescription) {
        if (methodDescription.getDeclaredAnnotations().isAnnotationPresent(annotation)) {
            if (dispatcher.isAlive()) {
                throw new IllegalStateException("Duplicate advice for " + dispatcher + " and " + methodDescription);
            }
            if (!methodDescription.isStatic()) {
                throw new IllegalStateException("Advice for " + methodDescription + " is not static");
            }
            return new Dispatcher.Active(methodDescription);
        }
        return dispatcher;
    }

    @Override
    public MethodVisitor wrap(TypeDescription instrumentedType, MethodDescription.InDefinedShape methodDescription, MethodVisitor methodVisitor) {
        if (methodDescription.isAbstract() || methodDescription.isNative()) {
            throw new IllegalStateException("Cannot advice abstract or native method " + methodDescription);
        }
        return this.methodExit.isSkipThrowable() ? new AdviceVisitor.WithoutExceptionHandling(methodVisitor, methodDescription, this.methodEnter, this.methodExit, this.binaryRepresentation) : new AdviceVisitor.WithExceptionHandling(methodVisitor, methodDescription, this.methodEnter, this.methodExit, this.binaryRepresentation);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Advice advice = (Advice)other;
        return this.methodEnter.equals(advice.methodEnter) && this.methodExit.equals(advice.methodExit) && Arrays.equals(this.binaryRepresentation, advice.binaryRepresentation);
    }

    public int hashCode() {
        int result = this.methodEnter.hashCode();
        result = 31 * result + this.methodExit.hashCode();
        result = 31 * result + Arrays.hashCode(this.binaryRepresentation);
        return result;
    }

    public String toString() {
        return "Advice{methodEnter=" + this.methodEnter + ", methodExit=" + this.methodExit + ", binaryRepresentation=<" + this.binaryRepresentation.length + " bytes>" + '}';
    }

    private static class NoSuppression
    extends Throwable {
        private NoSuppression() {
            throw new UnsupportedOperationException("This marker class is not supposed to be instantiated");
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Thrown {
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Return {
        public boolean readOnly() default true;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Enter {
        public boolean readOnly() default true;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface This {
        public boolean readOnly() default true;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Argument {
        public int value();

        public boolean readOnly() default true;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface OnMethodExit {
        public boolean onThrowable() default true;

        public Class<? extends Throwable> suppress() default NoSuppression.class;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface OnMethodEnter {
        public Class<? extends Throwable> suppress() default NoSuppression.class;
    }

    protected static interface Dispatcher {
        public static final MethodVisitor IGNORE_METHOD = null;

        public boolean isAlive();

        public Resolved.ForMethodEnter asMethodEnter();

        public Resolved.ForMethodExit asMethodExitTo(Resolved.ForMethodEnter var1);

        public static class Active
        implements Dispatcher {
            protected final MethodDescription.InDefinedShape adviseMethod;

            protected Active(MethodDescription.InDefinedShape adviseMethod) {
                this.adviseMethod = adviseMethod;
            }

            @Override
            public boolean isAlive() {
                return true;
            }

            @Override
            public nl.jqno.equalsverifier.internal.lib.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodEnter asMethodEnter() {
                return new Resolved.ForMethodEnter(this.adviseMethod);
            }

            @Override
            public nl.jqno.equalsverifier.internal.lib.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodExit asMethodExitTo(nl.jqno.equalsverifier.internal.lib.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodEnter dispatcher) {
                return new Resolved.ForMethodExit(this.adviseMethod, dispatcher.getEnterType());
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.adviseMethod.equals(((Active)other).adviseMethod);
            }

            public int hashCode() {
                return this.adviseMethod.hashCode();
            }

            public String toString() {
                return "Advice.Dispatcher.Active{adviseMethod=" + this.adviseMethod + '}';
            }

            protected static abstract class CodeTranslationVisitor
            extends MethodVisitor
            implements ReturnValueProducer {
                private static final AnnotationVisitor IGNORE_ANNOTATION = null;
                protected final MethodDescription.InDefinedShape instrumentedMethod;
                protected final MethodDescription.InDefinedShape adviseMethod;
                private final Map<Integer, Resolved.OffsetMapping.Target> offsetMappings;
                private final SuppressionHandler suppressionHandler;
                protected final Label endOfMethod;

                protected CodeTranslationVisitor(MethodVisitor methodVisitor, MethodDescription.InDefinedShape instrumentedMethod, MethodDescription.InDefinedShape adviseMethod, Map<Integer, Resolved.OffsetMapping.Target> offsetMappings, TypeDescription throwableType) {
                    super(327680, methodVisitor);
                    this.instrumentedMethod = instrumentedMethod;
                    this.adviseMethod = adviseMethod;
                    this.offsetMappings = offsetMappings;
                    this.suppressionHandler = throwableType.represents((Type)((Object)NoSuppression.class)) ? SuppressionHandler.NoOp.INSTANCE : new SuppressionHandler.Suppressing(throwableType);
                    this.endOfMethod = new Label();
                }

                @Override
                public void visitParameter(String name, int modifiers) {
                }

                @Override
                public AnnotationVisitor visitAnnotationDefault() {
                    return IGNORE_ANNOTATION;
                }

                @Override
                public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                    return IGNORE_ANNOTATION;
                }

                @Override
                public AnnotationVisitor visitTypeAnnotation(int typeReference, TypePath typePath, String descriptor, boolean visible) {
                    return IGNORE_ANNOTATION;
                }

                @Override
                public AnnotationVisitor visitParameterAnnotation(int index, String descriptor, boolean visible) {
                    return IGNORE_ANNOTATION;
                }

                @Override
                public void visitAttribute(Attribute attr) {
                }

                @Override
                public void visitCode() {
                    this.suppressionHandler.onStart(this.mv, this.endOfMethod);
                }

                @Override
                public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
                }

                @Override
                public void visitLineNumber(int line, Label start) {
                }

                @Override
                public void visitEnd() {
                    this.mv.visitLabel(this.endOfMethod);
                    this.suppressionHandler.onEnd(this.mv, this);
                }

                @Override
                public void visitMaxs(int maxStack, int maxLocals) {
                }

                @Override
                public void visitVarInsn(int opcode, int offset) {
                    Resolved.OffsetMapping.Target target = this.offsetMappings.get(offset);
                    if (target != null) {
                        if (!target.supports(opcode)) {
                            throw new IllegalStateException("Cannot write to read-only variable " + target);
                        }
                        offset = target.getOffset();
                    } else {
                        offset = this.adjust(offset + this.instrumentedMethod.getStackSize() - this.adviseMethod.getStackSize());
                    }
                    super.visitVarInsn(opcode, offset);
                }

                protected abstract int adjust(int var1);

                @Override
                public abstract void visitInsn(int var1);

                protected static class ReturnValueDiscarding
                extends CodeTranslationVisitor {
                    private static final int EXCEPTION_SIZE = 1;
                    private final StackSize additionalVariableSize;

                    protected ReturnValueDiscarding(MethodVisitor methodVisitor, MethodDescription.InDefinedShape instrumentedMethod, MethodDescription.InDefinedShape adviseMethod, Map<Integer, Resolved.OffsetMapping.Target> offsetMappings, TypeDescription throwableType, StackSize additionalVariableSize) {
                        super(methodVisitor, instrumentedMethod, adviseMethod, offsetMappings, throwableType);
                        this.additionalVariableSize = additionalVariableSize;
                    }

                    @Override
                    public void visitInsn(int opcode) {
                        switch (opcode) {
                            case 177: {
                                break;
                            }
                            case 172: 
                            case 174: 
                            case 176: {
                                this.mv.visitInsn(87);
                                break;
                            }
                            case 173: 
                            case 175: {
                                this.mv.visitInsn(88);
                                break;
                            }
                            default: {
                                this.mv.visitInsn(opcode);
                                return;
                            }
                        }
                        this.mv.visitJumpInsn(167, this.endOfMethod);
                    }

                    @Override
                    protected int adjust(int offset) {
                        return offset + this.instrumentedMethod.getReturnType().getStackSize().getSize() + this.additionalVariableSize.getSize() + 1;
                    }

                    @Override
                    public void makeDefault(MethodVisitor methodVisitor) {
                    }

                    public String toString() {
                        return "Advice.Dispatcher.Active.CodeTranslationVisitor.ReturnValueDiscarding{instrumentedMethod=" + this.instrumentedMethod + ", adviseMethod=" + this.adviseMethod + ", additionalVariableSize=" + (Object)((Object)this.additionalVariableSize) + '}';
                    }
                }

                protected static class ReturnValueRetaining
                extends CodeTranslationVisitor {
                    protected ReturnValueRetaining(MethodVisitor methodVisitor, MethodDescription.InDefinedShape instrumentedMethod, MethodDescription.InDefinedShape adviseMethod, Map<Integer, Resolved.OffsetMapping.Target> offsetMappings, TypeDescription throwableType) {
                        super(methodVisitor, instrumentedMethod, adviseMethod, offsetMappings, throwableType);
                    }

                    @Override
                    public void visitInsn(int opcode) {
                        switch (opcode) {
                            case 177: {
                                break;
                            }
                            case 172: {
                                this.mv.visitVarInsn(54, this.instrumentedMethod.getStackSize());
                                break;
                            }
                            case 173: {
                                this.mv.visitVarInsn(55, this.instrumentedMethod.getStackSize());
                                break;
                            }
                            case 176: {
                                this.mv.visitVarInsn(58, this.instrumentedMethod.getStackSize());
                                break;
                            }
                            case 174: {
                                this.mv.visitVarInsn(56, this.instrumentedMethod.getStackSize());
                                break;
                            }
                            case 175: {
                                this.mv.visitVarInsn(57, this.instrumentedMethod.getStackSize());
                                break;
                            }
                            default: {
                                this.mv.visitInsn(opcode);
                                return;
                            }
                        }
                        this.mv.visitJumpInsn(167, this.endOfMethod);
                    }

                    @Override
                    protected int adjust(int offset) {
                        return offset;
                    }

                    @Override
                    public void makeDefault(MethodVisitor methodVisitor) {
                        if (this.adviseMethod.getReturnType().represents(Boolean.TYPE) || this.adviseMethod.getReturnType().represents(Byte.TYPE) || this.adviseMethod.getReturnType().represents(Short.TYPE) || this.adviseMethod.getReturnType().represents(Character.TYPE) || this.adviseMethod.getReturnType().represents(Integer.TYPE)) {
                            methodVisitor.visitInsn(3);
                            methodVisitor.visitVarInsn(54, this.instrumentedMethod.getStackSize());
                        } else if (this.adviseMethod.getReturnType().represents(Long.TYPE)) {
                            methodVisitor.visitInsn(9);
                            methodVisitor.visitVarInsn(55, this.instrumentedMethod.getStackSize());
                        } else if (this.adviseMethod.getReturnType().represents(Float.TYPE)) {
                            methodVisitor.visitInsn(11);
                            methodVisitor.visitVarInsn(56, this.instrumentedMethod.getStackSize());
                        } else if (this.adviseMethod.getReturnType().represents(Double.TYPE)) {
                            methodVisitor.visitInsn(14);
                            methodVisitor.visitVarInsn(57, this.instrumentedMethod.getStackSize());
                        } else if (!this.adviseMethod.getReturnType().represents(Void.TYPE)) {
                            methodVisitor.visitInsn(1);
                            methodVisitor.visitVarInsn(58, this.instrumentedMethod.getStackSize());
                        }
                    }

                    public String toString() {
                        return "Advice.Dispatcher.Active.CodeTranslationVisitor.ReturnValueRetaining{instrumentedMethod=" + this.instrumentedMethod + ", adviseMethod=" + this.adviseMethod + '}';
                    }
                }

                protected static interface SuppressionHandler {
                    public void onStart(MethodVisitor var1, Label var2);

                    public void onEnd(MethodVisitor var1, ReturnValueProducer var2);

                    public static class Suppressing
                    implements SuppressionHandler {
                        private final TypeDescription throwableType;
                        private final Label startOfMethod;
                        private final Label handler;

                        protected Suppressing(TypeDescription throwableType) {
                            this.throwableType = throwableType;
                            this.startOfMethod = new Label();
                            this.handler = new Label();
                        }

                        @Override
                        public void onStart(MethodVisitor methodVisitor, Label endOfMethod) {
                            methodVisitor.visitTryCatchBlock(this.startOfMethod, endOfMethod, this.handler, this.throwableType.getInternalName());
                            methodVisitor.visitLabel(this.startOfMethod);
                        }

                        @Override
                        public void onEnd(MethodVisitor methodVisitor, ReturnValueProducer returnValueProducer) {
                            Label endOfHandler = new Label();
                            methodVisitor.visitJumpInsn(167, endOfHandler);
                            methodVisitor.visitLabel(this.handler);
                            methodVisitor.visitInsn(87);
                            returnValueProducer.makeDefault(methodVisitor);
                            methodVisitor.visitLabel(endOfHandler);
                        }

                        public boolean equals(Object object) {
                            if (this == object) {
                                return true;
                            }
                            if (object == null || this.getClass() != object.getClass()) {
                                return false;
                            }
                            Suppressing that = (Suppressing)object;
                            return this.throwableType.equals(that.throwableType);
                        }

                        public int hashCode() {
                            return this.throwableType.hashCode();
                        }

                        public String toString() {
                            return "Advice.Dispatcher.Active.CodeTranslationVisitor.SuppressionHandler.Suppressing{throwableType=" + this.throwableType + ", startOfMethod=" + this.startOfMethod + ", handler=" + this.handler + '}';
                        }
                    }

                    public static enum NoOp implements SuppressionHandler
                    {
                        INSTANCE;


                        @Override
                        public void onStart(MethodVisitor methodVisitor, Label endOfMethod) {
                        }

                        @Override
                        public void onEnd(MethodVisitor methodVisitor, ReturnValueProducer returnValueProducer) {
                        }

                        public String toString() {
                            return "Advice.Dispatcher.Active.CodeTranslationVisitor.SuppressionHandler.NoOp." + this.name();
                        }
                    }
                }
            }

            static interface ReturnValueProducer {
                public void makeDefault(MethodVisitor var1);
            }

            protected static abstract class Resolved
            implements nl.jqno.equalsverifier.internal.lib.bytebuddy.asm.Advice$Dispatcher$Resolved {
                private static final boolean READ_ONLY = true;
                protected final MethodDescription.InDefinedShape adviseMethod;
                protected final Map<Integer, OffsetMapping> offsetMappings;

                protected Resolved(MethodDescription.InDefinedShape adviseMethod, OffsetMapping.Factory ... factory) {
                    this.adviseMethod = adviseMethod;
                    this.offsetMappings = new HashMap<Integer, OffsetMapping>();
                    for (ParameterDescription.InDefinedShape parameterDescription : adviseMethod.getParameters()) {
                        OffsetMapping offsetMapping = OffsetMapping.Factory.UNDEFINED;
                        for (OffsetMapping.Factory aFactory : factory) {
                            OffsetMapping possible = aFactory.make(parameterDescription);
                            if (possible == null) continue;
                            if (offsetMapping == null) {
                                offsetMapping = possible;
                                continue;
                            }
                            throw new IllegalStateException(parameterDescription + " is bound to both " + possible + " and " + offsetMapping);
                        }
                        this.offsetMappings.put(parameterDescription.getOffset(), offsetMapping == null ? new OffsetMapping.ForParameter(parameterDescription.getIndex(), true, parameterDescription.getType().asErasure()) : offsetMapping);
                    }
                }

                @Override
                public MethodVisitor apply(String internalName, String descriptor, MethodVisitor methodVisitor, MethodDescription.InDefinedShape instrumentedMethod) {
                    return this.adviseMethod.getInternalName().equals(internalName) && this.adviseMethod.getDescriptor().equals(descriptor) ? this.apply(methodVisitor, instrumentedMethod) : IGNORE_METHOD;
                }

                protected abstract MethodVisitor apply(MethodVisitor var1, MethodDescription.InDefinedShape var2);

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    Resolved resolved = (Resolved)other;
                    return this.adviseMethod.equals(resolved.adviseMethod) && this.offsetMappings.equals(resolved.offsetMappings);
                }

                public int hashCode() {
                    int result = this.adviseMethod.hashCode();
                    result = 31 * result + this.offsetMappings.hashCode();
                    return result;
                }

                protected static class ForMethodExit
                extends Resolved
                implements nl.jqno.equalsverifier.internal.lib.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodExit {
                    private static final MethodDescription.InDefinedShape SUPPRESS = (MethodDescription.InDefinedShape)((MethodList)new TypeDescription.ForLoadedType(OnMethodExit.class).getDeclaredMethods().filter(ElementMatchers.named("suppress"))).getOnly();
                    private final StackSize additionalSize;

                    protected ForMethodExit(MethodDescription.InDefinedShape adviseMethod, TypeDescription enterType) {
                        super(adviseMethod, OffsetMapping.ForParameter.Factory.INSTANCE, OffsetMapping.ForThisReference.Factory.INSTANCE, new OffsetMapping.ForEnterValue.Factory(enterType), OffsetMapping.ForReturnValue.Factory.INSTANCE, adviseMethod.getDeclaredAnnotations().ofType(OnMethodExit.class).loadSilent().onThrowable() ? OffsetMapping.ForThrowable.INSTANCE : new OffsetMapping.Illegal(Thrown.class));
                        this.additionalSize = enterType.getStackSize();
                    }

                    @Override
                    public boolean isSkipThrowable() {
                        return !this.adviseMethod.getDeclaredAnnotations().ofType(OnMethodExit.class).loadSilent().onThrowable();
                    }

                    @Override
                    protected MethodVisitor apply(MethodVisitor methodVisitor, MethodDescription.InDefinedShape instrumentedMethod) {
                        HashMap<Integer, OffsetMapping.Target> offsetMappings = new HashMap<Integer, OffsetMapping.Target>();
                        for (Map.Entry entry : this.offsetMappings.entrySet()) {
                            offsetMappings.put((Integer)entry.getKey(), ((OffsetMapping)entry.getValue()).resolve(instrumentedMethod, this.additionalSize));
                        }
                        return new CodeTranslationVisitor.ReturnValueDiscarding(methodVisitor, instrumentedMethod, this.adviseMethod, offsetMappings, this.adviseMethod.getDeclaredAnnotations().ofType(OnMethodExit.class).getValue(SUPPRESS, TypeDescription.class), this.additionalSize);
                    }

                    @Override
                    public boolean equals(Object other) {
                        return this == other || other != null && this.getClass() == other.getClass() && super.equals(other) && this.additionalSize == ((ForMethodExit)other).additionalSize;
                    }

                    @Override
                    public int hashCode() {
                        int result = super.hashCode();
                        result = 31 * result + this.additionalSize.hashCode();
                        return result;
                    }

                    public String toString() {
                        return "Advice.Dispatcher.Active.Resolved.ForMethodExit{adviseMethod=" + this.adviseMethod + ", offsetMappings=" + this.offsetMappings + ", additionalSize=" + (Object)((Object)this.additionalSize) + '}';
                    }
                }

                protected static class ForMethodEnter
                extends Resolved
                implements nl.jqno.equalsverifier.internal.lib.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodEnter {
                    private static final MethodDescription.InDefinedShape SUPPRESS = (MethodDescription.InDefinedShape)((MethodList)new TypeDescription.ForLoadedType(OnMethodEnter.class).getDeclaredMethods().filter(ElementMatchers.named("suppress"))).getOnly();

                    protected ForMethodEnter(MethodDescription.InDefinedShape adviseMethod) {
                        super(adviseMethod, OffsetMapping.ForParameter.Factory.INSTANCE, OffsetMapping.ForThisReference.Factory.INSTANCE, new OffsetMapping.Illegal(Thrown.class, Enter.class, Return.class));
                    }

                    @Override
                    public TypeDescription getEnterType() {
                        return this.adviseMethod.getReturnType().asErasure();
                    }

                    @Override
                    protected MethodVisitor apply(MethodVisitor methodVisitor, MethodDescription.InDefinedShape instrumentedMethod) {
                        HashMap<Integer, OffsetMapping.Target> offsetMappings = new HashMap<Integer, OffsetMapping.Target>();
                        for (Map.Entry entry : this.offsetMappings.entrySet()) {
                            offsetMappings.put((Integer)entry.getKey(), ((OffsetMapping)entry.getValue()).resolve(instrumentedMethod, StackSize.ZERO));
                        }
                        return new CodeTranslationVisitor.ReturnValueRetaining(methodVisitor, instrumentedMethod, this.adviseMethod, offsetMappings, this.adviseMethod.getDeclaredAnnotations().ofType(OnMethodEnter.class).getValue(SUPPRESS, TypeDescription.class));
                    }

                    public String toString() {
                        return "Advice.Dispatcher.Active.Resolved.ForMethodEnter{adviseMethod=" + this.adviseMethod + ", offsetMappings=" + this.offsetMappings + '}';
                    }
                }

                static interface OffsetMapping {
                    public Target resolve(MethodDescription.InDefinedShape var1, StackSize var2);

                    public static class Illegal
                    implements Factory {
                        private final List<? extends Class<? extends Annotation>> annotations;

                        protected Illegal(Class<? extends Annotation> ... annotation) {
                            this(Arrays.asList(annotation));
                        }

                        protected Illegal(List<? extends Class<? extends Annotation>> annotations) {
                            this.annotations = annotations;
                        }

                        @Override
                        public OffsetMapping make(ParameterDescription.InDefinedShape parameterDescription) {
                            for (Class<? extends Annotation> clazz : this.annotations) {
                                if (!parameterDescription.getDeclaredAnnotations().isAnnotationPresent(clazz)) continue;
                                throw new IllegalStateException("Illegal annotation " + clazz + " for " + parameterDescription);
                            }
                            return UNDEFINED;
                        }

                        public boolean equals(Object other) {
                            if (this == other) {
                                return true;
                            }
                            if (other == null || this.getClass() != other.getClass()) {
                                return false;
                            }
                            Illegal illegal = (Illegal)other;
                            return this.annotations.equals(illegal.annotations);
                        }

                        public int hashCode() {
                            return this.annotations.hashCode();
                        }

                        public String toString() {
                            return "Advice.Dispatcher.Active.Resolved.OffsetMapping.Illegal{annotations=" + this.annotations + '}';
                        }
                    }

                    public static enum ForThrowable implements OffsetMapping,
                    Factory
                    {
                        INSTANCE;


                        @Override
                        public OffsetMapping make(ParameterDescription.InDefinedShape parameterDescription) {
                            if (parameterDescription.getDeclaredAnnotations().isAnnotationPresent(Thrown.class)) {
                                if (!parameterDescription.getType().represents((Type)((Object)Throwable.class))) {
                                    throw new IllegalStateException("Parameter must be of type Throwable for " + parameterDescription);
                                }
                                return this;
                            }
                            return UNDEFINED;
                        }

                        @Override
                        public Target resolve(MethodDescription.InDefinedShape instrumentedMethod, StackSize additionalSize) {
                            return new Target.ReadWrite(instrumentedMethod.getStackSize() + additionalSize.getSize() + instrumentedMethod.getReturnType().getStackSize().getSize());
                        }

                        public String toString() {
                            return "Advice.Dispatcher.Active.Resolved.OffsetMapping.ForThrowable." + this.name();
                        }
                    }

                    public static class ForReturnValue
                    implements OffsetMapping {
                        private final boolean readOnly;
                        private final TypeDescription targetType;

                        protected ForReturnValue(boolean readOnly, TypeDescription targetType) {
                            this.readOnly = readOnly;
                            this.targetType = targetType;
                        }

                        @Override
                        public Target resolve(MethodDescription.InDefinedShape instrumentedMethod, StackSize additionalSize) {
                            if (!this.readOnly && !instrumentedMethod.getReturnType().asErasure().equals(this.targetType)) {
                                throw new IllegalStateException("read-only return type of " + instrumentedMethod + " is not equal to " + this.targetType);
                            }
                            if (this.readOnly && !instrumentedMethod.getReturnType().asErasure().isAssignableTo(this.targetType)) {
                                throw new IllegalStateException("Cannot assign return type of " + instrumentedMethod + " to " + this.targetType);
                            }
                            return this.readOnly ? new Target.ReadOnly(instrumentedMethod.getStackSize() + additionalSize.getSize()) : new Target.ReadWrite(instrumentedMethod.getStackSize() + additionalSize.getSize());
                        }

                        public boolean equals(Object other) {
                            if (this == other) {
                                return true;
                            }
                            if (other == null || this.getClass() != other.getClass()) {
                                return false;
                            }
                            ForReturnValue that = (ForReturnValue)other;
                            return this.readOnly == that.readOnly && this.targetType.equals(that.targetType);
                        }

                        public int hashCode() {
                            return (this.readOnly ? 1 : 0) + 31 * this.targetType.hashCode();
                        }

                        public String toString() {
                            return "Advice.Dispatcher.Active.Resolved.OffsetMapping.ForReturnValue{readOnly=" + this.readOnly + ", targetType=" + this.targetType + '}';
                        }

                        protected static enum Factory implements nl.jqno.equalsverifier.internal.lib.bytebuddy.asm.Advice$Dispatcher$Active$Resolved$OffsetMapping$Factory
                        {
                            INSTANCE;


                            @Override
                            public OffsetMapping make(ParameterDescription.InDefinedShape parameterDescription) {
                                AnnotationDescription.Loadable<Return> annotation = parameterDescription.getDeclaredAnnotations().ofType(Return.class);
                                return annotation == null ? UNDEFINED : new ForReturnValue(annotation.loadSilent().readOnly(), parameterDescription.getType().asErasure());
                            }

                            public String toString() {
                                return "Advice.Dispatcher.Active.Resolved.OffsetMapping.ForReturnValue.Factory." + this.name();
                            }
                        }
                    }

                    public static enum ForEnterValue implements OffsetMapping
                    {
                        WRITABLE(false),
                        READ_ONLY(true);

                        private final boolean readOnly;

                        private ForEnterValue(boolean readOnly) {
                            this.readOnly = readOnly;
                        }

                        public static OffsetMapping of(boolean readOnly) {
                            return readOnly ? READ_ONLY : WRITABLE;
                        }

                        @Override
                        public Target resolve(MethodDescription.InDefinedShape instrumentedMethod, StackSize additionalSize) {
                            return this.readOnly ? new Target.ReadOnly(instrumentedMethod.getStackSize()) : new Target.ReadWrite(instrumentedMethod.getStackSize());
                        }

                        public String toString() {
                            return "Advice.Dispatcher.Active.Resolved.OffsetMapping.ForEnterValue." + this.name();
                        }

                        protected static class Factory
                        implements nl.jqno.equalsverifier.internal.lib.bytebuddy.asm.Advice$Dispatcher$Active$Resolved$OffsetMapping$Factory {
                            private final TypeDescription enterType;

                            protected Factory(TypeDescription enterType) {
                                this.enterType = enterType;
                            }

                            @Override
                            public OffsetMapping make(ParameterDescription.InDefinedShape parameterDescription) {
                                AnnotationDescription.Loadable<Enter> annotation = parameterDescription.getDeclaredAnnotations().ofType(Enter.class);
                                if (annotation != null) {
                                    boolean readOnly = annotation.loadSilent().readOnly();
                                    if (!readOnly && !this.enterType.equals(parameterDescription.getType().asErasure())) {
                                        throw new IllegalStateException("read-only type of " + parameterDescription + " does not equal " + this.enterType);
                                    }
                                    if (readOnly && !this.enterType.isAssignableTo(parameterDescription.getType().asErasure())) {
                                        throw new IllegalStateException("Cannot assign the type of " + parameterDescription + " to supplied type " + this.enterType);
                                    }
                                    return ForEnterValue.of(readOnly);
                                }
                                return UNDEFINED;
                            }

                            public boolean equals(Object other) {
                                return this == other || other != null && this.getClass() == other.getClass() && this.enterType.equals(((Factory)other).enterType);
                            }

                            public int hashCode() {
                                return this.enterType.hashCode();
                            }

                            public String toString() {
                                return "Advice.Dispatcher.Active.Resolved.OffsetMapping.ForEnterValue.Factory{enterType=" + this.enterType + '}';
                            }
                        }
                    }

                    public static class ForThisReference
                    implements OffsetMapping {
                        private static final int THIS_REFERENCE = 0;
                        private final boolean readOnly;
                        private final TypeDescription targetType;

                        protected ForThisReference(boolean readOnly, TypeDescription targetType) {
                            this.readOnly = readOnly;
                            this.targetType = targetType;
                        }

                        @Override
                        public Target resolve(MethodDescription.InDefinedShape instrumentedMethod, StackSize additionalSize) {
                            if (instrumentedMethod.isStatic()) {
                                throw new IllegalStateException("Cannot map this reference for static method " + instrumentedMethod);
                            }
                            if (!this.readOnly && !instrumentedMethod.getDeclaringType().equals(this.targetType)) {
                                throw new IllegalStateException("Declaring type of " + instrumentedMethod + " is not equal to read-only " + this.targetType);
                            }
                            if (this.readOnly && !instrumentedMethod.getDeclaringType().isAssignableTo(this.targetType)) {
                                throw new IllegalStateException("Declaring type of " + instrumentedMethod + " is not assignable to " + this.targetType);
                            }
                            return this.readOnly ? new Target.ReadOnly(0) : new Target.ReadWrite(0);
                        }

                        public boolean equals(Object object) {
                            if (this == object) {
                                return true;
                            }
                            if (object == null || this.getClass() != object.getClass()) {
                                return false;
                            }
                            ForThisReference that = (ForThisReference)object;
                            return this.readOnly == that.readOnly && this.targetType.equals(that.targetType);
                        }

                        public int hashCode() {
                            int result = this.readOnly ? 1 : 0;
                            result = 31 * result + this.targetType.hashCode();
                            return result;
                        }

                        public String toString() {
                            return "Advice.Dispatcher.Active.Resolved.OffsetMapping.ForThisReference{readOnly=" + this.readOnly + ", targetType=" + this.targetType + '}';
                        }

                        protected static enum Factory implements nl.jqno.equalsverifier.internal.lib.bytebuddy.asm.Advice$Dispatcher$Active$Resolved$OffsetMapping$Factory
                        {
                            INSTANCE;


                            @Override
                            public OffsetMapping make(ParameterDescription.InDefinedShape parameterDescription) {
                                AnnotationDescription.Loadable<This> annotation = parameterDescription.getDeclaredAnnotations().ofType(This.class);
                                return annotation == null ? UNDEFINED : new ForThisReference(annotation.loadSilent().readOnly(), parameterDescription.getType().asErasure());
                            }

                            public String toString() {
                                return "Advice.Dispatcher.Active.Resolved.OffsetMapping.ForThisReference.Factory." + this.name();
                            }
                        }
                    }

                    public static class ForParameter
                    implements OffsetMapping {
                        private final int index;
                        private final boolean readOnly;
                        private final TypeDescription targetType;

                        protected ForParameter(Argument argument, TypeDescription targetType) {
                            this(argument.value(), argument.readOnly(), targetType);
                        }

                        protected ForParameter(int index, boolean readOnly, TypeDescription targetType) {
                            this.index = index;
                            this.readOnly = readOnly;
                            this.targetType = targetType;
                        }

                        @Override
                        public Target resolve(MethodDescription.InDefinedShape instrumentedMethod, StackSize additionalSize) {
                            ParameterList<ParameterDescription.InDefinedShape> parameters = instrumentedMethod.getParameters();
                            if (parameters.size() <= this.index) {
                                throw new IllegalStateException(instrumentedMethod + " does not define an index " + this.index);
                            }
                            if (!this.readOnly && !((ParameterDescription)parameters.get(this.index)).getType().asErasure().equals(this.targetType)) {
                                throw new IllegalStateException("read-only " + this.targetType + " is not equal to type of " + parameters.get(this.index));
                            }
                            if (this.readOnly && !((ParameterDescription)parameters.get(this.index)).getType().asErasure().isAssignableTo(this.targetType)) {
                                throw new IllegalStateException(this.targetType + " is not assignable to " + parameters.get(this.index));
                            }
                            return this.readOnly ? new Target.ReadOnly(((ParameterDescription)parameters.get(this.index)).getOffset()) : new Target.ReadWrite(((ParameterDescription)parameters.get(this.index)).getOffset());
                        }

                        public boolean equals(Object object) {
                            if (this == object) {
                                return true;
                            }
                            if (object == null || this.getClass() != object.getClass()) {
                                return false;
                            }
                            ForParameter that = (ForParameter)object;
                            return this.index == that.index && this.readOnly == that.readOnly && this.targetType.equals(that.targetType);
                        }

                        public int hashCode() {
                            int result = this.index;
                            result = 31 * result + (this.readOnly ? 1 : 0);
                            result = 31 * result + this.targetType.hashCode();
                            return result;
                        }

                        public String toString() {
                            return "Advice.Dispatcher.Active.Resolved.OffsetMapping.ForParameter{index=" + this.index + ", readOnly=" + this.readOnly + ", targetType=" + this.targetType + '}';
                        }

                        protected static enum Factory implements nl.jqno.equalsverifier.internal.lib.bytebuddy.asm.Advice$Dispatcher$Active$Resolved$OffsetMapping$Factory
                        {
                            INSTANCE;


                            @Override
                            public OffsetMapping make(ParameterDescription.InDefinedShape parameterDescription) {
                                AnnotationDescription.Loadable<Argument> annotation = parameterDescription.getDeclaredAnnotations().ofType(Argument.class);
                                return annotation == null ? UNDEFINED : new ForParameter(annotation.loadSilent(), parameterDescription.getType().asErasure());
                            }

                            public String toString() {
                                return "Advice.Dispatcher.Active.Resolved.OffsetMapping.ForParameter.Factory." + this.name();
                            }
                        }
                    }

                    public static interface Factory {
                        public static final OffsetMapping UNDEFINED = null;

                        public OffsetMapping make(ParameterDescription.InDefinedShape var1);
                    }

                    public static interface Target {
                        public boolean supports(int var1);

                        public int getOffset();

                        public static class ReadOnly
                        implements Target {
                            private final int offset;

                            protected ReadOnly(int offset) {
                                this.offset = offset;
                            }

                            @Override
                            public boolean supports(int opcode) {
                                switch (opcode) {
                                    case 54: 
                                    case 55: 
                                    case 56: 
                                    case 57: 
                                    case 58: {
                                        return false;
                                    }
                                }
                                return true;
                            }

                            @Override
                            public int getOffset() {
                                return this.offset;
                            }

                            public boolean equals(Object object) {
                                if (this == object) {
                                    return true;
                                }
                                if (object == null || this.getClass() != object.getClass()) {
                                    return false;
                                }
                                ReadOnly readOnly = (ReadOnly)object;
                                return this.offset == readOnly.offset;
                            }

                            public int hashCode() {
                                return this.offset;
                            }

                            public String toString() {
                                return "Advice.Dispatcher.Active.Resolved.OffsetMapping.Target.ReadOnly{offset=" + this.offset + '}';
                            }
                        }

                        public static class ReadWrite
                        implements Target {
                            private final int offset;

                            protected ReadWrite(int offset) {
                                this.offset = offset;
                            }

                            @Override
                            public boolean supports(int opcode) {
                                return true;
                            }

                            @Override
                            public int getOffset() {
                                return this.offset;
                            }

                            public boolean equals(Object object) {
                                if (this == object) {
                                    return true;
                                }
                                if (object == null || this.getClass() != object.getClass()) {
                                    return false;
                                }
                                ReadWrite readWrite = (ReadWrite)object;
                                return this.offset == readWrite.offset;
                            }

                            public int hashCode() {
                                return this.offset;
                            }

                            public String toString() {
                                return "Advice.Dispatcher.Active.Resolved.OffsetMapping.Target.ReadWrite{offset=" + this.offset + '}';
                            }
                        }
                    }
                }
            }
        }

        public static enum Inactive implements Dispatcher,
        Resolved.ForMethodEnter,
        Resolved.ForMethodExit
        {
            INSTANCE;


            @Override
            public boolean isAlive() {
                return false;
            }

            @Override
            public boolean isSkipThrowable() {
                return true;
            }

            @Override
            public TypeDescription getEnterType() {
                return TypeDescription.VOID;
            }

            @Override
            public Resolved.ForMethodEnter asMethodEnter() {
                return this;
            }

            @Override
            public Resolved.ForMethodExit asMethodExitTo(Resolved.ForMethodEnter dispatcher) {
                return this;
            }

            @Override
            public MethodVisitor apply(String internalName, String descriptor, MethodVisitor methodVisitor, MethodDescription.InDefinedShape instrumentedMethod) {
                return IGNORE_METHOD;
            }

            public String toString() {
                return "Advice.Dispatcher.Inactive." + this.name();
            }
        }

        public static interface Resolved {
            public MethodVisitor apply(String var1, String var2, MethodVisitor var3, MethodDescription.InDefinedShape var4);

            public static interface ForMethodExit
            extends Resolved {
                public boolean isSkipThrowable();
            }

            public static interface ForMethodEnter
            extends Resolved {
                public TypeDescription getEnterType();
            }
        }
    }

    protected static abstract class AdviceVisitor
    extends MethodVisitor {
        private static final int NO_OFFSET = 0;
        protected final MethodDescription.InDefinedShape instrumentedMethod;
        private final Dispatcher.Resolved.ForMethodEnter methodEnter;
        private final Dispatcher.Resolved.ForMethodExit methodExit;
        private final ClassReader classReader;

        protected AdviceVisitor(MethodVisitor methodVisitor, MethodDescription.InDefinedShape instrumentedMethod, Dispatcher.Resolved.ForMethodEnter methodEnter, Dispatcher.Resolved.ForMethodExit methodExit, byte[] binaryRepresentation) {
            super(327680, methodVisitor);
            this.instrumentedMethod = instrumentedMethod;
            this.methodEnter = methodEnter;
            this.methodExit = methodExit;
            this.classReader = new ClassReader(binaryRepresentation);
        }

        @Override
        public void visitCode() {
            super.visitCode();
            this.onMethodStart();
        }

        protected abstract void onMethodStart();

        @Override
        public void visitVarInsn(int opcode, int offset) {
            super.visitVarInsn(opcode, offset < this.instrumentedMethod.getStackSize() ? offset : offset + this.methodEnter.getEnterType().getStackSize().getSize());
        }

        @Override
        @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT"}, justification="Switch is supposed to fall through")
        public void visitInsn(int opcode) {
            switch (opcode) {
                case 177: {
                    this.onMethodExit();
                    break;
                }
                case 172: {
                    this.onMethodExit(54, 21);
                    break;
                }
                case 174: {
                    this.onMethodExit(56, 23);
                    break;
                }
                case 175: {
                    this.onMethodExit(57, 24);
                    break;
                }
                case 173: {
                    this.onMethodExit(55, 22);
                    break;
                }
                case 176: {
                    this.onMethodExit(58, 25);
                }
            }
            this.mv.visitInsn(opcode);
        }

        private void onMethodExit(int store, int load) {
            this.variable(store);
            this.mv.visitInsn(1);
            this.variable(58, this.instrumentedMethod.getReturnType().getStackSize().getSize());
            this.onMethodExit();
            this.variable(load);
        }

        protected abstract void onMethodExit();

        protected void variable(int opcode) {
            this.variable(opcode, 0);
        }

        protected void variable(int opcode, int offset) {
            this.mv.visitVarInsn(opcode, this.instrumentedMethod.getStackSize() + this.methodEnter.getEnterType().getStackSize().getSize() + offset);
        }

        @Override
        public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        }

        @Override
        public void visitMaxs(int maxStack, int maxLocals) {
            this.onMethodEnd();
            super.visitMaxs(maxStack, maxLocals);
        }

        protected abstract void onMethodEnd();

        protected void appendEnter() {
            this.append(this.methodEnter);
        }

        protected void appendExit() {
            this.append(this.methodExit);
        }

        private void append(Dispatcher.Resolved dispatcher) {
            this.classReader.accept(new CodeCopier(dispatcher), 2);
        }

        protected static class WithoutExceptionHandling
        extends AdviceVisitor {
            protected WithoutExceptionHandling(MethodVisitor methodVisitor, MethodDescription.InDefinedShape instrumentedMethod, Dispatcher.Resolved.ForMethodEnter methodEnter, Dispatcher.Resolved.ForMethodExit methodExit, byte[] binaryRepresentation) {
                super(methodVisitor, instrumentedMethod, methodEnter, methodExit, binaryRepresentation);
            }

            @Override
            protected void onMethodStart() {
                this.appendEnter();
            }

            @Override
            protected void onMethodExit() {
                this.appendExit();
            }

            @Override
            protected void onMethodEnd() {
            }

            public String toString() {
                return "Advice.AdviceVisitor.WithoutExceptionHandling{instrumentedMethod=" + this.instrumentedMethod + '}';
            }
        }

        protected static class WithExceptionHandling
        extends AdviceVisitor {
            private static final String ANY_THROWABLE = null;
            private final Label handler = new Label();
            private Label userEnd;

            protected WithExceptionHandling(MethodVisitor methodVisitor, MethodDescription.InDefinedShape instrumentedMethod, Dispatcher.Resolved.ForMethodEnter methodEnter, Dispatcher.Resolved.ForMethodExit methodExit, byte[] binaryRepresentation) {
                super(methodVisitor, instrumentedMethod, methodEnter, methodExit, binaryRepresentation);
            }

            @Override
            protected void onMethodStart() {
                this.appendEnter();
                Label userStart = new Label();
                this.userEnd = new Label();
                this.mv.visitTryCatchBlock(userStart, this.userEnd, this.handler, null);
                this.mv.visitLabel(userStart);
            }

            @Override
            protected void onMethodExit() {
                this.mv.visitLabel(this.userEnd);
                this.appendExit();
                Label userStart = new Label();
                this.userEnd = new Label();
                this.mv.visitTryCatchBlock(userStart, this.userEnd, this.handler, ANY_THROWABLE);
                this.mv.visitLabel(userStart);
            }

            @Override
            protected void onMethodEnd() {
                this.mv.visitLabel(this.userEnd);
                this.mv.visitLabel(this.handler);
                this.variable(58, this.instrumentedMethod.getReturnType().getStackSize().getSize());
                this.storeDefaultReturn();
                this.appendExit();
                this.variable(25, this.instrumentedMethod.getReturnType().getStackSize().getSize());
                this.mv.visitInsn(191);
            }

            private void storeDefaultReturn() {
                if (this.instrumentedMethod.getReturnType().represents(Boolean.TYPE) || this.instrumentedMethod.getReturnType().represents(Byte.TYPE) || this.instrumentedMethod.getReturnType().represents(Short.TYPE) || this.instrumentedMethod.getReturnType().represents(Character.TYPE) || this.instrumentedMethod.getReturnType().represents(Integer.TYPE)) {
                    this.mv.visitInsn(3);
                    this.variable(54);
                } else if (this.instrumentedMethod.getReturnType().represents(Long.TYPE)) {
                    this.mv.visitInsn(9);
                    this.variable(55);
                } else if (this.instrumentedMethod.getReturnType().represents(Float.TYPE)) {
                    this.mv.visitInsn(11);
                    this.variable(56);
                } else if (this.instrumentedMethod.getReturnType().represents(Double.TYPE)) {
                    this.mv.visitInsn(14);
                    this.variable(57);
                } else if (!this.instrumentedMethod.getReturnType().represents(Void.TYPE)) {
                    this.mv.visitInsn(1);
                    this.variable(58);
                }
            }

            public String toString() {
                return "Advice.AdviceVisitor.WithExceptionHandling{instrumentedMethod=" + this.instrumentedMethod + '}';
            }
        }

        protected class CodeCopier
        extends ClassVisitor {
            private final Dispatcher.Resolved dispatcher;

            protected CodeCopier(Dispatcher.Resolved dispatcher) {
                super(327680);
                this.dispatcher = dispatcher;
            }

            @Override
            public MethodVisitor visitMethod(int modifiers, String internalName, String descriptor, String signature, String[] exception) {
                return this.dispatcher.apply(internalName, descriptor, AdviceVisitor.this.mv, AdviceVisitor.this.instrumentedMethod);
            }

            public String toString() {
                return "Advice.AdviceVisitor.CodeCopier{outer=" + AdviceVisitor.this + ", dispatcher=" + this.dispatcher + '}';
            }
        }
    }
}

