/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.bytebuddy.matcher;

import java.util.Arrays;
import java.util.List;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.field.FieldDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.MethodDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.matcher.ElementMatcher;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.matcher.ElementMatchers;

public interface LatentMatcher<T> {
    public ElementMatcher<? super T> resolve(TypeDescription var1);

    public static class Compound<S>
    implements LatentMatcher<S> {
        private final List<? extends LatentMatcher<? super S>> matchers;

        public Compound(LatentMatcher<? super S> ... matcher) {
            this(Arrays.asList(matcher));
        }

        public Compound(List<? extends LatentMatcher<? super S>> matchers) {
            this.matchers = matchers;
        }

        @Override
        public ElementMatcher<? super S> resolve(TypeDescription typeDescription) {
            ElementMatcher.Junction<Object> matcher = ElementMatchers.none();
            for (LatentMatcher<S> latentMatcher : this.matchers) {
                matcher = matcher.or(latentMatcher.resolve(typeDescription));
            }
            return matcher;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.matchers.equals(((Compound)other).matchers);
        }

        public int hashCode() {
            return this.matchers.hashCode();
        }

        public String toString() {
            return "LatentMatcher.Compound{matchers=" + this.matchers + '}';
        }
    }

    public static class ForMethodToken
    implements LatentMatcher<MethodDescription> {
        private final MethodDescription.Token token;

        public ForMethodToken(MethodDescription.Token token) {
            this.token = token;
        }

        @Override
        public ElementMatcher<? super MethodDescription> resolve(TypeDescription typeDescription) {
            return new ResolvedMatcher(this.token.asSignatureToken(typeDescription));
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.token.equals(((ForMethodToken)other).token);
        }

        public int hashCode() {
            return this.token.hashCode();
        }

        public String toString() {
            return "LatentMatcher.ForMethodToken{token=" + this.token + '}';
        }

        protected static class ResolvedMatcher
        implements ElementMatcher<MethodDescription> {
            private final MethodDescription.SignatureToken signatureToken;

            protected ResolvedMatcher(MethodDescription.SignatureToken signatureToken) {
                this.signatureToken = signatureToken;
            }

            @Override
            public boolean matches(MethodDescription target) {
                return target.asSignatureToken().equals(this.signatureToken);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.signatureToken.equals(((ResolvedMatcher)other).signatureToken);
            }

            public int hashCode() {
                return this.signatureToken.hashCode();
            }

            public String toString() {
                return "LatentMatcher.ForMethodToken.ResolvedMatcher{signatureToken=" + this.signatureToken + '}';
            }
        }
    }

    public static class ForFieldToken
    implements LatentMatcher<FieldDescription> {
        private final FieldDescription.Token token;

        public ForFieldToken(FieldDescription.Token token) {
            this.token = token;
        }

        @Override
        public ElementMatcher<? super FieldDescription> resolve(TypeDescription typeDescription) {
            return new ResolvedMatcher(this.token.asSignatureToken(typeDescription));
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.token.equals(((ForFieldToken)other).token);
        }

        public int hashCode() {
            return this.token.hashCode();
        }

        public String toString() {
            return "LatentMatcher.ForFieldToken{token=" + this.token + '}';
        }

        protected static class ResolvedMatcher
        implements ElementMatcher<FieldDescription> {
            private final FieldDescription.SignatureToken signatureToken;

            protected ResolvedMatcher(FieldDescription.SignatureToken signatureToken) {
                this.signatureToken = signatureToken;
            }

            @Override
            public boolean matches(FieldDescription target) {
                return target.asSignatureToken().equals(this.signatureToken);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.signatureToken.equals(((ResolvedMatcher)other).signatureToken);
            }

            public int hashCode() {
                return this.signatureToken.hashCode();
            }

            public String toString() {
                return "LatentMatcher.ForFieldToken.ResolvedMatcher{signatureToken=" + this.signatureToken + '}';
            }
        }
    }

    public static class Resolved<S>
    implements LatentMatcher<S> {
        private final ElementMatcher<? super S> matcher;

        public Resolved(ElementMatcher<? super S> matcher) {
            this.matcher = matcher;
        }

        @Override
        public ElementMatcher<? super S> resolve(TypeDescription typeDescription) {
            return this.matcher;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.matcher.equals(((Resolved)other).matcher);
        }

        public int hashCode() {
            return this.matcher.hashCode();
        }

        public String toString() {
            return "LatentMatcher.Resolved{matcher=" + this.matcher + '}';
        }
    }
}

