/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.gui;

import antlr.ASTFactory;
import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.gui.ParseTreeTableModel;
import com.puppycrawl.tools.checkstyle.utils.TokenUtils;

public class ParseTreeTablePModel {
    private static final String[] COLUMN_NAMES = new String[]{"Tree", "Type", "Line", "Column", "Text"};
    private final Object root = ParseTreeTablePModel.createArtificialTreeRoot();

    public ParseTreeTablePModel(DetailAST parseTree) {
        this.setParseTree(parseTree);
    }

    private static DetailAST createArtificialTreeRoot() {
        ASTFactory factory = new ASTFactory();
        factory.setASTNodeClass(DetailAST.class.getName());
        return (DetailAST)factory.create(1, "ROOT");
    }

    protected final void setParseTree(DetailAST parseTree) {
        ((AST)this.root).setFirstChild(parseTree);
    }

    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    public Class<?> getColumnClass(int column) {
        Class columnClass;
        switch (column) {
            case 0: {
                columnClass = ParseTreeTableModel.class;
                break;
            }
            case 1: {
                columnClass = String.class;
                break;
            }
            case 2: {
                columnClass = Integer.class;
                break;
            }
            case 3: {
                columnClass = Integer.class;
                break;
            }
            case 4: {
                columnClass = String.class;
                break;
            }
            default: {
                columnClass = Object.class;
            }
        }
        return columnClass;
    }

    public Object getValueAt(Object node, int column) {
        Object value;
        DetailAST ast = (DetailAST)node;
        switch (column) {
            case 1: {
                value = TokenUtils.getTokenName(ast.getType());
                break;
            }
            case 2: {
                value = ast.getLineNo();
                break;
            }
            case 3: {
                value = ast.getColumnNo();
                break;
            }
            case 4: {
                value = ast.getText();
                break;
            }
            default: {
                value = null;
            }
        }
        return value;
    }

    public Object getChild(Object parent, int index) {
        DetailAST ast = (DetailAST)parent;
        AST child = ast.getFirstChild();
        for (int currentIndex = 0; currentIndex < index; ++currentIndex) {
            child = child.getNextSibling();
        }
        return child;
    }

    public int getChildCount(Object parent) {
        DetailAST ast = (DetailAST)parent;
        return ast.getChildCount();
    }

    public Object getRoot() {
        return this.root;
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    public int getIndexOfChild(Object parent, Object child) {
        int index = -1;
        for (int i = 0; i < this.getChildCount(parent); ++i) {
            if (!this.getChild(parent, i).equals(child)) continue;
            index = i;
            break;
        }
        return index;
    }

    public boolean isCellEditable(int column) {
        return this.getColumnClass(column).equals(ParseTreeTablePModel.class);
    }
}

