/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.input;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import org.jdom.DefaultJDOMFactory;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.JDOMFactory;
import org.jdom.input.BuilderErrorHandler;
import org.jdom.input.JDOMParseException;
import org.jdom.input.SAXHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SAXBuilder {
    private static final String CVS_ID = "@(#) $RCSfile: SAXBuilder.java,v $ $Revision: 1.89 $ $Date: 2004/09/03 18:24:28 $ $Name: jdom_1_0 $";
    private static final String DEFAULT_SAX_DRIVER = "org.apache.xerces.parsers.SAXParser";
    private boolean validate;
    private boolean expand;
    private String saxDriverClass;
    private ErrorHandler saxErrorHandler;
    private EntityResolver saxEntityResolver;
    private DTDHandler saxDTDHandler;
    private XMLFilter saxXMLFilter;
    private JDOMFactory factory;
    private boolean ignoringWhite;
    private HashMap features;
    private HashMap properties;
    private boolean reuseParser;
    private XMLReader saxParser;
    static /* synthetic */ Class class$java$util$Map;

    public String getDriverClass() {
        return this.saxDriverClass;
    }

    public JDOMFactory getFactory() {
        return this.factory;
    }

    public void setFactory(JDOMFactory factory) {
        this.factory = factory;
    }

    public boolean getValidation() {
        return this.validate;
    }

    public void setValidation(boolean validate) {
        this.validate = validate;
    }

    public ErrorHandler getErrorHandler() {
        return this.saxErrorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.saxErrorHandler = errorHandler;
    }

    public EntityResolver getEntityResolver() {
        return this.saxEntityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.saxEntityResolver = entityResolver;
    }

    public DTDHandler getDTDHandler() {
        return this.saxDTDHandler;
    }

    public void setDTDHandler(DTDHandler dtdHandler) {
        this.saxDTDHandler = dtdHandler;
    }

    public XMLFilter getXMLFilter() {
        return this.saxXMLFilter;
    }

    public void setXMLFilter(XMLFilter xmlFilter) {
        this.saxXMLFilter = xmlFilter;
    }

    public boolean getIgnoringElementContentWhitespace() {
        return this.ignoringWhite;
    }

    public void setIgnoringElementContentWhitespace(boolean ignoringWhite) {
        this.ignoringWhite = ignoringWhite;
    }

    public boolean getReuseParser() {
        return this.reuseParser;
    }

    public void setReuseParser(boolean reuseParser) {
        this.reuseParser = reuseParser;
        this.saxParser = null;
    }

    public void setFeature(String name, boolean value) {
        this.features.put(name, new Boolean(value));
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Document build(InputSource in) throws JDOMException, IOException {
        SAXHandler contentHandler = null;
        try {
            try {
                contentHandler = this.createContentHandler();
                this.configureContentHandler(contentHandler);
                XMLReader parser = this.saxParser;
                if (parser == null) {
                    parser = this.createParser();
                    if (this.saxXMLFilter != null) {
                        XMLFilter root = this.saxXMLFilter;
                        while (root.getParent() instanceof XMLFilter) {
                            root = (XMLFilter)root.getParent();
                        }
                        root.setParent(parser);
                        parser = this.saxXMLFilter;
                    }
                    this.configureParser(parser, contentHandler);
                    if (this.reuseParser) {
                        this.saxParser = parser;
                    }
                } else {
                    this.configureParser(parser, contentHandler);
                }
                parser.parse(in);
                Document document = contentHandler.getDocument();
                Object var4_9 = null;
                contentHandler = null;
                return document;
            }
            catch (SAXParseException e) {
                String systemId;
                Document doc = contentHandler.getDocument();
                if (!doc.hasRootElement()) {
                    doc = null;
                }
                if ((systemId = e.getSystemId()) != null) {
                    throw new JDOMParseException("Error on line " + e.getLineNumber() + " of document " + systemId, e, doc);
                }
                throw new JDOMParseException("Error on line " + e.getLineNumber(), e, doc);
            }
            catch (SAXException e) {
                throw new JDOMParseException("Error in building: " + e.getMessage(), e, contentHandler.getDocument());
            }
        }
        catch (Throwable throwable) {
            Object var4_10 = null;
            contentHandler = null;
            throw throwable;
        }
    }

    protected SAXHandler createContentHandler() {
        SAXHandler contentHandler = new SAXHandler(this.factory);
        return contentHandler;
    }

    protected void configureContentHandler(SAXHandler contentHandler) {
        contentHandler.setExpandEntities(this.expand);
        contentHandler.setIgnoringElementContentWhitespace(this.ignoringWhite);
    }

    protected XMLReader createParser() throws JDOMException {
        XMLReader parser = null;
        if (this.saxDriverClass != null) {
            try {
                parser = XMLReaderFactory.createXMLReader(this.saxDriverClass);
                this.setFeaturesAndProperties(parser, true);
            }
            catch (SAXException e) {
                throw new JDOMException("Could not load " + this.saxDriverClass, e);
            }
        }
        try {
            Class clazz;
            Class<?> factoryClass = Class.forName("org.jdom.input.JAXPParserFactory");
            Class[] classArray = new Class[3];
            classArray[0] = Boolean.TYPE;
            Class clazz2 = class$java$util$Map;
            if (clazz2 == null) {
                clazz2 = classArray[1] = (class$java$util$Map = SAXBuilder.class("[Ljava.util.Map;", false));
            }
            if ((clazz = class$java$util$Map) == null) {
                clazz = class$java$util$Map = SAXBuilder.class("[Ljava.util.Map;", false);
            }
            classArray[2] = clazz;
            Method createParser = factoryClass.getMethod("createParser", classArray);
            parser = (XMLReader)createParser.invoke(null, new Boolean(this.validate), this.features, this.properties);
            this.setFeaturesAndProperties(parser, false);
        }
        catch (JDOMException e) {
            throw e;
        }
        catch (NoClassDefFoundError e) {
        }
        catch (Exception e) {
            // empty catch block
        }
        if (parser == null) {
            try {
                parser = XMLReaderFactory.createXMLReader(DEFAULT_SAX_DRIVER);
                this.saxDriverClass = parser.getClass().getName();
                this.setFeaturesAndProperties(parser, true);
            }
            catch (SAXException e) {
                throw new JDOMException("Could not load default SAX parser: org.apache.xerces.parsers.SAXParser", e);
            }
        }
        return parser;
    }

    protected void configureParser(XMLReader parser, SAXHandler contentHandler) throws JDOMException {
        parser.setContentHandler(contentHandler);
        if (this.saxEntityResolver != null) {
            parser.setEntityResolver(this.saxEntityResolver);
        }
        if (this.saxDTDHandler != null) {
            parser.setDTDHandler(this.saxDTDHandler);
        } else {
            parser.setDTDHandler(contentHandler);
        }
        if (this.saxErrorHandler != null) {
            parser.setErrorHandler(this.saxErrorHandler);
        } else {
            parser.setErrorHandler(new BuilderErrorHandler());
        }
        boolean lexicalReporting = false;
        try {
            parser.setProperty("http://xml.org/sax/handlers/LexicalHandler", contentHandler);
            lexicalReporting = true;
        }
        catch (SAXNotSupportedException e) {
        }
        catch (SAXNotRecognizedException e) {
            // empty catch block
        }
        if (!lexicalReporting) {
            try {
                parser.setProperty("http://xml.org/sax/properties/lexical-handler", contentHandler);
                lexicalReporting = true;
            }
            catch (SAXNotSupportedException e) {
            }
            catch (SAXNotRecognizedException e) {
                // empty catch block
            }
        }
        if (!this.expand) {
            try {
                parser.setProperty("http://xml.org/sax/properties/declaration-handler", contentHandler);
            }
            catch (SAXNotSupportedException e) {
            }
            catch (SAXNotRecognizedException e) {
                // empty catch block
            }
        }
    }

    private final void setFeaturesAndProperties(XMLReader parser, boolean coreFeatures) throws JDOMException {
        String name;
        Iterator iter = this.features.keySet().iterator();
        while (iter.hasNext()) {
            name = (String)iter.next();
            Boolean value = (Boolean)this.features.get(name);
            this.internalSetFeature(parser, name, value, name);
        }
        iter = this.properties.keySet().iterator();
        while (iter.hasNext()) {
            name = (String)iter.next();
            this.internalSetProperty(parser, name, this.properties.get(name), name);
        }
        if (coreFeatures) {
            block9: {
                try {
                    this.internalSetFeature(parser, "http://xml.org/sax/features/validation", this.validate, "Validation");
                }
                catch (JDOMException e) {
                    if (!this.validate) break block9;
                    throw e;
                }
            }
            this.internalSetFeature(parser, "http://xml.org/sax/features/namespaces", true, "Namespaces");
            this.internalSetFeature(parser, "http://xml.org/sax/features/namespace-prefixes", true, "Namespace prefixes");
        }
        try {
            if (parser.getFeature("http://xml.org/sax/features/external-general-entities") != this.expand) {
                parser.setFeature("http://xml.org/sax/features/external-general-entities", this.expand);
            }
        }
        catch (SAXNotRecognizedException e) {
        }
        catch (SAXNotSupportedException e) {
            // empty catch block
        }
    }

    private final void internalSetFeature(XMLReader parser, String feature, boolean value, String displayName) throws JDOMException {
        try {
            parser.setFeature(feature, value);
        }
        catch (SAXNotSupportedException e) {
            throw new JDOMException(displayName + " feature not supported for SAX driver " + parser.getClass().getName());
        }
        catch (SAXNotRecognizedException e) {
            throw new JDOMException(displayName + " feature not recognized for SAX driver " + parser.getClass().getName());
        }
    }

    private final void internalSetProperty(XMLReader parser, String property, Object value, String displayName) throws JDOMException {
        try {
            parser.setProperty(property, value);
        }
        catch (SAXNotSupportedException e) {
            throw new JDOMException(displayName + " property not supported for SAX driver " + parser.getClass().getName());
        }
        catch (SAXNotRecognizedException e) {
            throw new JDOMException(displayName + " property not recognized for SAX driver " + parser.getClass().getName());
        }
    }

    public Document build(InputStream in) throws JDOMException, IOException {
        return this.build(new InputSource(in));
    }

    public Document build(File file) throws JDOMException, IOException {
        try {
            URL url = SAXBuilder.fileToURL(file);
            return this.build(url);
        }
        catch (MalformedURLException e) {
            throw new JDOMException("Error in building", e);
        }
    }

    public Document build(URL url) throws JDOMException, IOException {
        String systemID = url.toExternalForm();
        return this.build(new InputSource(systemID));
    }

    public Document build(InputStream in, String systemId) throws JDOMException, IOException {
        InputSource src = new InputSource(in);
        src.setSystemId(systemId);
        return this.build(src);
    }

    public Document build(Reader characterStream) throws JDOMException, IOException {
        return this.build(new InputSource(characterStream));
    }

    public Document build(Reader characterStream, String systemId) throws JDOMException, IOException {
        InputSource src = new InputSource(characterStream);
        src.setSystemId(systemId);
        return this.build(src);
    }

    public Document build(String systemId) throws JDOMException, IOException {
        return this.build(new InputSource(systemId));
    }

    private static final URL fileToURL(File file) throws MalformedURLException {
        StringBuffer buffer = new StringBuffer();
        String path = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            path = path.replace(File.separatorChar, '/');
        }
        if (!path.startsWith("/")) {
            buffer.append('/');
        }
        int len = path.length();
        int i = 0;
        while (i < len) {
            char c = path.charAt(i);
            if (c == ' ') {
                buffer.append("%20");
            } else if (c == '#') {
                buffer.append("%23");
            } else if (c == '%') {
                buffer.append("%25");
            } else if (c == '&') {
                buffer.append("%26");
            } else if (c == ';') {
                buffer.append("%3B");
            } else if (c == '<') {
                buffer.append("%3C");
            } else if (c == '=') {
                buffer.append("%3D");
            } else if (c == '>') {
                buffer.append("%3E");
            } else if (c == '?') {
                buffer.append("%3F");
            } else if (c == '~') {
                buffer.append("%7E");
            } else {
                buffer.append(c);
            }
            ++i;
        }
        if (!path.endsWith("/") && file.isDirectory()) {
            buffer.append('/');
        }
        return new URL("file", "", buffer.toString());
    }

    public boolean getExpandEntities() {
        return this.expand;
    }

    public void setExpandEntities(boolean expand) {
        this.expand = expand;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.expand = true;
        this.saxErrorHandler = null;
        this.saxEntityResolver = null;
        this.saxDTDHandler = null;
        this.saxXMLFilter = null;
        this.factory = new DefaultJDOMFactory();
        this.ignoringWhite = false;
        this.features = new HashMap(5);
        this.properties = new HashMap(5);
        this.reuseParser = true;
        this.saxParser = null;
    }

    public SAXBuilder() {
        this(false);
    }

    public SAXBuilder(boolean validate) {
        this.this();
        this.validate = validate;
    }

    public SAXBuilder(String saxDriverClass) {
        this(saxDriverClass, false);
    }

    public SAXBuilder(String saxDriverClass, boolean validate) {
        this.this();
        this.saxDriverClass = saxDriverClass;
        this.validate = validate;
    }
}

